/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.model;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredElement;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredSequenceFlow;
import org.camunda.bpm.extension.process_test_coverage.model.ProcessCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.CoveredElementComparator;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class MethodCoverage
implements AggregatedCoverage {
    private String deploymentId;
    private Map<String, ProcessCoverage> processDefinitionKeyToProcessCoverage = new HashMap<String, ProcessCoverage>();

    public MethodCoverage(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void addProcessCoverage(ProcessCoverage processCoverage) {
        String processDefinitionId = processCoverage.getProcessDefinitionKey();
        this.processDefinitionKeyToProcessCoverage.put(processDefinitionId, processCoverage);
    }

    public void addCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        processCoverage.addCoveredElement(element);
    }

    public void endCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        processCoverage.endCoveredElement(element);
    }

    @Override
    public double getCoveragePercentage() {
        HashSet<CoveredElement> deploymentCoveredFlowNodes = new HashSet<CoveredElement>();
        HashSet<FlowNode> deploymentDefinitionsFlowNodes = new HashSet<FlowNode>();
        HashSet<CoveredElement> deploymentCoveredSequenceFlows = new HashSet<CoveredElement>();
        HashSet<SequenceFlow> deploymentDefinitionsSequenceFlows = new HashSet<SequenceFlow>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredFlowNode> coveredFlowNodes = processCoverage.getCoveredFlowNodes();
            deploymentCoveredFlowNodes.addAll(coveredFlowNodes);
            Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
            deploymentDefinitionsFlowNodes.addAll(definitionFlowNodes);
            Set<CoveredSequenceFlow> coveredSequenceFlows = processCoverage.getCoveredSequenceFlows();
            deploymentCoveredSequenceFlows.addAll(coveredSequenceFlows);
            Set<SequenceFlow> definitionSequenceFlows = processCoverage.getDefinitionSequenceFlows();
            deploymentDefinitionsSequenceFlows.addAll(definitionSequenceFlows);
        }
        double coveragePercentage = this.getCoveragePercentage(deploymentCoveredFlowNodes, deploymentDefinitionsFlowNodes, deploymentCoveredSequenceFlows, deploymentDefinitionsSequenceFlows);
        return coveragePercentage;
    }

    private double getCoveragePercentage(Set<CoveredElement> coveredFlowNodes, Set<FlowNode> definitionsFlowNodes, Set<CoveredElement> coveredSequenceFlows, Set<SequenceFlow> definitionsSequenceFlows) {
        int numberOfDefinedElements = definitionsFlowNodes.size() + definitionsSequenceFlows.size();
        int numberOfCoveredElemenets = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return (double)numberOfCoveredElemenets / (double)numberOfDefinedElements;
    }

    public Set<FlowNode> getProcessDefinitionsFlowNodes() {
        HashSet<FlowNode> flowNodes = new HashSet<FlowNode>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
            flowNodes.addAll(definitionFlowNodes);
        }
        return flowNodes;
    }

    public Set<SequenceFlow> getProcessDefinitionsSequenceFlows() {
        HashSet<SequenceFlow> sequenceFlows = new HashSet<SequenceFlow>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<SequenceFlow> definitionSequenceFlows = processCoverage.getDefinitionSequenceFlows();
            sequenceFlows.addAll(definitionSequenceFlows);
        }
        return sequenceFlows;
    }

    public Set<CoveredFlowNode> getCoveredFlowNodes() {
        TreeSet<CoveredElement> flowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredFlowNode> definitionFlowNodes = processCoverage.getCoveredFlowNodes();
            flowNodes.addAll(definitionFlowNodes);
        }
        return flowNodes;
    }

    public Set<CoveredSequenceFlow> getCoveredSequenceFlows() {
        TreeSet<CoveredElement> sequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredSequenceFlow> definitionSequenceFlows = processCoverage.getCoveredSequenceFlows();
            sequenceFlows.addAll(definitionSequenceFlows);
        }
        return sequenceFlows;
    }

    @Override
    public Set<String> getCoveredFlowNodeIds(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredFlowNodeIds();
    }

    @Override
    public Set<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredFlowNodes();
    }

    @Override
    public Set<String> getCoveredSequenceFlowIds(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredSequenceFlowIds();
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        TreeSet<ProcessDefinition> processDefinitions = new TreeSet<ProcessDefinition>(new Comparator<ProcessDefinition>(){

            @Override
            public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                return o1.getResourceName().compareTo(o2.getResourceName());
            }
        });
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            processDefinitions.add(processCoverage.getProcessDefinition());
        }
        return processDefinitions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Deployment ID: ");
        builder.append(this.deploymentId);
        builder.append("\nDeployment process definitions:\n");
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            builder.append(processCoverage);
            builder.append('\n');
        }
        return builder.toString();
    }
}

