/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.util.CoverageReportUtil;

public class BpmnJsReport {
    private static final String REPORT_TEMPLATE = "bpmn.js-report-template.html";
    protected static final String PLACEHOLDER_PROCESS_KEY = "//PROCESSKEY";
    protected static final String PLACEHOLDER_COVERAGE = "//COVERAGE";
    protected static final String PLACEHOLDER_TESTCLASS = "//TESTCLASS";
    protected static final String PLACEHOLDER_TESTMETHOD = "//TESTMETHOD";
    protected static final String PLACEHOLDER_ANNOTATIONS = "          //YOUR ANNOTATIONS GO HERE";
    protected static final String PLACEHOLDER_BPMN_XML = "YOUR BPMN XML CONTENT";
    protected static final String JQUERY_SEQUENCEFLOW_MARKING_COMMAND = "\\$(\"g[data-element-id=''{0}'']\").find(''path'').attr(''stroke'', ''#00ff00'');\n";
    protected static final String JQUERY_RUNNING_FLOWNODE_MARKING_COMMAND = "\\$(\"g[data-element-id=''{0}'']\").addClass(''highlight-running'');\n";

    public static void generateReportWithHighlightedFlowNodesAndSequenceFlows(String bpmnXml, Collection<CoveredFlowNode> flowNodes, Collection<String> sequenceFlowIds, String reportName, String processDefinitionKey, double coverage, String testClass, String testMethod, boolean classReport, String targetDir) throws IOException {
        String flowNodeMarkers = BpmnJsReport.generateJavaScriptFlowNodeAnnotations(flowNodes);
        String sequenceFlowMarkers = BpmnJsReport.generateJavaScriptSequenceFlowAnnotations(sequenceFlowIds);
        String markers = flowNodeMarkers + sequenceFlowMarkers;
        String html = BpmnJsReport.generateHtml(markers, bpmnXml, processDefinitionKey, coverage, testClass, testMethod, classReport);
        BpmnJsReport.writeToFile(targetDir, reportName, html);
    }

    protected static String generateHtml(String javaScript, String bpmnXml, String processDefinitionKey, double coverage, String testClass, String testMethod, boolean classReport) throws IOException {
        String html = IOUtils.toString((InputStream)CoverageReportUtil.class.getClassLoader().getResourceAsStream(REPORT_TEMPLATE));
        return BpmnJsReport.injectIntoHtmlTemplate(javaScript, bpmnXml, html, processDefinitionKey, coverage, testClass, testMethod, classReport);
    }

    protected static String injectIntoHtmlTemplate(String javaScript, String bpmnXml, String html, String processDefinitionKey, double coverage, String testClass, String testMethod, boolean classReport) {
        html = html.replace(PLACEHOLDER_BPMN_XML, StringEscapeUtils.escapeEcmaScript((String)bpmnXml));
        html = html.replaceAll(PLACEHOLDER_ANNOTATIONS, javaScript + PLACEHOLDER_ANNOTATIONS);
        html = html.replaceAll(PLACEHOLDER_PROCESS_KEY, processDefinitionKey);
        html = html.replaceAll(PLACEHOLDER_COVERAGE, BpmnJsReport.getCoveragePercent(coverage));
        html = html.replaceAll(PLACEHOLDER_TESTCLASS, testClass);
        html = classReport ? html.replaceAll(PLACEHOLDER_TESTMETHOD, "") : html.replaceAll(PLACEHOLDER_TESTMETHOD, "<div>TestMethod: " + testMethod + "</div>");
        return html;
    }

    private static String getCoveragePercent(double coverage) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(1);
        return percentFormat.format(coverage);
    }

    protected static String generateJavaScriptFlowNodeAnnotations(Collection<CoveredFlowNode> flowNodeIds) {
        StringBuilder javaScript = new StringBuilder();
        for (CoveredFlowNode flowNode : flowNodeIds) {
            javaScript.append("\t\t\t");
            if (flowNode.hasEnded()) {
                javaScript.append("canvas.addMarker('" + flowNode.getElementId() + "', 'highlight');\n");
                continue;
            }
            javaScript.append(MessageFormat.format(JQUERY_RUNNING_FLOWNODE_MARKING_COMMAND, flowNode.getElementId()));
        }
        return javaScript.toString();
    }

    protected static String generateJavaScriptSequenceFlowAnnotations(Collection<String> sequenceFlowIds) {
        StringBuilder javaScript = new StringBuilder();
        for (String sequenceFlowId : sequenceFlowIds) {
            javaScript.append("\t\t\t");
            javaScript.append(MessageFormat.format(JQUERY_SEQUENCEFLOW_MARKING_COMMAND, sequenceFlowId));
        }
        return javaScript.toString();
    }

    protected static void writeToFile(String targetDir, String fileName, String html) throws IOException {
        FileUtils.writeStringToFile((File)new File(targetDir + "/" + fileName), (String)html);
    }
}

