/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.impl.juel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.camunda.bpm.impl.juel.LocalMessages;
import org.camunda.bpm.impl.juel.TypeConverter;
import org.camunda.bpm.impl.juel.jakarta.el.ELException;

public class NumberOperations {
    private static final Long LONG_ZERO = 0L;

    private static final boolean isDotEe(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            switch (value.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean isDotEe(Object value) {
        return value instanceof String && NumberOperations.isDotEe((String)value);
    }

    private static final boolean isFloatOrDouble(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    private static final boolean isFloatOrDoubleOrDotEe(Object value) {
        return NumberOperations.isFloatOrDouble(value) || NumberOperations.isDotEe(value);
    }

    private static final boolean isBigDecimalOrBigInteger(Object value) {
        return value instanceof BigDecimal || value instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object value) {
        return value instanceof BigDecimal || NumberOperations.isFloatOrDoubleOrDotEe(value);
    }

    public static final Number add(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) + converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).add(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) + converter.convert(o2, Long.class);
    }

    public static final Number sub(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) - converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).subtract(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) - converter.convert(o2, Long.class);
    }

    public static final Number mul(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) * converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).multiply(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) * converter.convert(o2, Long.class);
    }

    public static final Number div(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(o1) || NumberOperations.isBigDecimalOrBigInteger(o2)) {
            return converter.convert(o1, BigDecimal.class).divide(converter.convert(o2, BigDecimal.class), RoundingMode.HALF_UP);
        }
        return converter.convert(o1, Double.class) / converter.convert(o2, Double.class);
    }

    public static final Number mod(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(o1) || NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(o2)) {
            return converter.convert(o1, Double.class) % converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).remainder(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) % converter.convert(o2, Long.class);
    }

    public static final Number neg(TypeConverter converter, Object value) {
        if (value == null) {
            return LONG_ZERO;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        if (value instanceof String) {
            if (NumberOperations.isDotEe((String)value)) {
                return -converter.convert(value, Double.class).doubleValue();
            }
            return -converter.convert(value, Long.class).longValue();
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Short) {
            return -((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return -((Byte)value).byteValue();
        }
        throw new ELException(LocalMessages.get("error.negate", value.getClass()));
    }
}

