/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.builder;

import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ErrorEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.ErrorEventDefinition;
import org.camunda.bpm.model.bpmn.instance.EscalationEventDefinition;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.bpmndi.BpmnEdge;
import org.camunda.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import org.camunda.bpm.model.bpmn.instance.dc.Bounds;
import org.camunda.bpm.model.bpmn.instance.di.Waypoint;

public abstract class AbstractBoundaryEventBuilder<B extends AbstractBoundaryEventBuilder<B>>
extends AbstractCatchEventBuilder<B, BoundaryEvent> {
    protected AbstractBoundaryEventBuilder(BpmnModelInstance modelInstance, BoundaryEvent element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public B cancelActivity(Boolean cancelActivity) {
        ((BoundaryEvent)this.element).setCancelActivity(cancelActivity);
        return (B)((AbstractBoundaryEventBuilder)this.myself);
    }

    public B error() {
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        ((BoundaryEvent)this.element).getEventDefinitions().add(errorEventDefinition);
        return (B)((AbstractBoundaryEventBuilder)this.myself);
    }

    public B error(String errorCode) {
        ErrorEventDefinition errorEventDefinition = this.createErrorEventDefinition(errorCode);
        ((BoundaryEvent)this.element).getEventDefinitions().add(errorEventDefinition);
        return (B)((AbstractBoundaryEventBuilder)this.myself);
    }

    public ErrorEventDefinitionBuilder errorEventDefinition(String id) {
        ErrorEventDefinition errorEventDefinition = this.createEmptyErrorEventDefinition();
        if (id != null) {
            errorEventDefinition.setId(id);
        }
        ((BoundaryEvent)this.element).getEventDefinitions().add(errorEventDefinition);
        return new ErrorEventDefinitionBuilder(this.modelInstance, errorEventDefinition);
    }

    public ErrorEventDefinitionBuilder errorEventDefinition() {
        ErrorEventDefinition errorEventDefinition = this.createEmptyErrorEventDefinition();
        ((BoundaryEvent)this.element).getEventDefinitions().add(errorEventDefinition);
        return new ErrorEventDefinitionBuilder(this.modelInstance, errorEventDefinition);
    }

    public B escalation() {
        EscalationEventDefinition escalationEventDefinition = this.createInstance(EscalationEventDefinition.class);
        ((BoundaryEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return (B)((AbstractBoundaryEventBuilder)this.myself);
    }

    public B escalation(String escalationCode) {
        EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinition(escalationCode);
        ((BoundaryEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return (B)((AbstractBoundaryEventBuilder)this.myself);
    }

    @Override
    protected void setCoordinates(BpmnShape shape) {
        BpmnShape source = this.findBpmnShape((BaseElement)this.element);
        Bounds shapeBounds = shape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (source != null) {
            Bounds sourceBounds = source.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceWidth = sourceBounds.getWidth();
            double sourceY = sourceBounds.getY();
            double sourceHeight = sourceBounds.getHeight();
            double targetHeight = shapeBounds.getHeight();
            x = sourceX + sourceWidth + 12.5;
            y = sourceY + sourceHeight - targetHeight / 2.0 + 50.0;
        }
        shapeBounds.setX(x);
        shapeBounds.setY(y);
    }

    @Override
    protected void setWaypointsWithSourceAndTarget(BpmnEdge edge, FlowNode edgeSource, FlowNode edgeTarget) {
        BpmnShape source = this.findBpmnShape(edgeSource);
        BpmnShape target = this.findBpmnShape(edgeTarget);
        if (source != null && target != null) {
            Bounds sourceBounds = source.getBounds();
            Bounds targetBounds = target.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceY = sourceBounds.getY();
            double sourceWidth = sourceBounds.getWidth();
            double sourceHeight = sourceBounds.getHeight();
            double targetX = targetBounds.getX();
            double targetY = targetBounds.getY();
            double targetHeight = targetBounds.getHeight();
            Waypoint w1 = this.createInstance(Waypoint.class);
            w1.setX(sourceX + sourceWidth / 2.0);
            w1.setY(sourceY + sourceHeight);
            Waypoint w2 = this.createInstance(Waypoint.class);
            w2.setX(sourceX + sourceWidth / 2.0);
            w2.setY(sourceY + sourceHeight + 50.0);
            Waypoint w3 = this.createInstance(Waypoint.class);
            w3.setX(targetX);
            w3.setY(targetY + targetHeight / 2.0);
            edge.addChildElement(w1);
            edge.addChildElement(w2);
            edge.addChildElement(w3);
        }
    }
}

