/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.fasterxml.uuid;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class EgressInterfaceFinder {
    public static final int DEFAULT_TIMEOUT_MILLIS = 5000;

    public NetworkInterface egressInterface() throws EgressResolutionException {
        return this.fromDefaultMechanisms(5000);
    }

    public NetworkInterface fromDefaultMechanisms(int timeoutMillis) throws EgressResolutionException {
        Finder[] finders = new Finder[]{this.rootNameServerFinder(timeoutMillis), this.remoteConnectionFinder(timeoutMillis, new InetSocketAddress("1.1.1.1", 0)), this.remoteConnectionFinder(timeoutMillis, new InetSocketAddress("1::1", 0))};
        return this.fromAggregate(finders);
    }

    public NetworkInterface fromAggregate(Finder[] finders) throws EgressResolutionException {
        ArrayList<EgressResolutionException> exceptions = new ArrayList<EgressResolutionException>();
        for (Finder finder : finders) {
            try {
                return finder.egressInterface();
            }
            catch (EgressResolutionException e) {
                exceptions.add(e);
            }
        }
        throw new EgressResolutionException(exceptions.toArray(new EgressResolutionException[0]));
    }

    private Finder rootNameServerFinder(final int timeoutMillis) {
        return new Finder(){

            @Override
            public NetworkInterface egressInterface() throws EgressResolutionException {
                return EgressInterfaceFinder.this.fromRootNameserverConnection(timeoutMillis);
            }
        };
    }

    public NetworkInterface fromRootNameserverConnection(int timeoutMillis) throws EgressResolutionException {
        String domainName = EgressInterfaceFinder.randomRootServerName();
        InetSocketAddress address = new InetSocketAddress(domainName, 53);
        return this.fromRemoteConnection(timeoutMillis, address);
    }

    static String randomRootServerName() {
        String roots = "abcdefghijklm";
        int index = new Random().nextInt(roots.length());
        return roots.charAt(index) + ".root-servers.net";
    }

    private Finder remoteConnectionFinder(final int timeoutMillis, final InetSocketAddress address) {
        return new Finder(){

            @Override
            public NetworkInterface egressInterface() throws EgressResolutionException {
                return EgressInterfaceFinder.this.fromRemoteConnection(timeoutMillis, address);
            }
        };
    }

    public NetworkInterface fromRemoteConnection(int timeoutMillis, InetSocketAddress remoteAddress) throws EgressResolutionException {
        if (remoteAddress.isUnresolved()) {
            throw new EgressResolutionException(String.format("remote address [%s] is unresolved", remoteAddress));
        }
        Finder socketFinder = this.remoteSocketConnectionFinder(timeoutMillis, remoteAddress);
        Finder datagramSocketFinder = this.remoteDatagramSocketConnectionFinder(remoteAddress);
        Finder[] finders = new Finder[]{datagramSocketFinder, socketFinder};
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Mac")) {
            finders = new Finder[]{socketFinder, datagramSocketFinder};
        }
        return this.fromAggregate(finders);
    }

    private Finder remoteSocketConnectionFinder(final int timeoutMillis, final InetSocketAddress address) {
        return new Finder(){

            @Override
            public NetworkInterface egressInterface() throws EgressResolutionException {
                return EgressInterfaceFinder.this.fromRemoteSocketConnection(timeoutMillis, address);
            }
        };
    }

    public NetworkInterface fromRemoteSocketConnection(int timeoutMillis, InetSocketAddress remoteAddress) throws EgressResolutionException {
        Socket socket = new Socket();
        try {
            socket.connect(remoteAddress, timeoutMillis);
            NetworkInterface networkInterface = this.fromLocalAddress(socket.getLocalAddress());
            return networkInterface;
        }
        catch (IOException e) {
            throw new EgressResolutionException(String.format("Socket connection to [%s]", remoteAddress), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Finder remoteDatagramSocketConnectionFinder(final InetSocketAddress address) {
        return new Finder(){

            @Override
            public NetworkInterface egressInterface() throws EgressResolutionException {
                return EgressInterfaceFinder.this.fromRemoteDatagramSocketConnection(address);
            }
        };
    }

    public NetworkInterface fromRemoteDatagramSocketConnection(InetSocketAddress remoteAddress) throws EgressResolutionException {
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            socket.connect(remoteAddress);
            NetworkInterface networkInterface = this.fromLocalAddress(socket.getLocalAddress());
            return networkInterface;
        }
    }

    public NetworkInterface fromLocalAddress(InetAddress localAddress) throws EgressResolutionException {
        try {
            InetAddress unspecifiedIPv4 = InetAddress.getByName("0.0.0.0");
            InetAddress unspecifiedIPv6 = InetAddress.getByName("::");
            if (localAddress.equals(unspecifiedIPv4) || localAddress.equals(unspecifiedIPv6)) {
                throw new EgressResolutionException(String.format("local address [%s] is unspecified", localAddress));
            }
            NetworkInterface ni = NetworkInterface.getByInetAddress(localAddress);
            if (ni == null) {
                throw new EgressResolutionException(String.format("no interface found with local address [%s]", localAddress));
            }
            return ni;
        }
        catch (IOException e) {
            throw new EgressResolutionException(String.format("local address [%s]", localAddress), e);
        }
    }

    static interface Finder {
        public NetworkInterface egressInterface() throws EgressResolutionException;
    }

    public static class EgressResolutionException
    extends Exception {
        private final List<String> messages = new ArrayList<String>();

        public EgressResolutionException(String message) {
            super(message);
            this.messages.add(message);
        }

        public EgressResolutionException(String message, Throwable cause) {
            super(message, cause);
            this.messages.add(message);
            this.messages.add(cause.toString());
        }

        public EgressResolutionException(EgressResolutionException[] priors) {
            super(Arrays.toString(priors));
            for (EgressResolutionException e : priors) {
                this.messages.add("----------------------------------------------------------------------------");
                this.messages.addAll(e.messages);
            }
        }

        public void report() {
            this.reportLine("");
            this.reportLine("====================================");
            this.reportLine("| Egress Resolution Failure Report |");
            this.reportLine("====================================");
            this.reportLine("");
            this.reportLine("Please share this report in order to help improve the egress resolution");
            this.reportLine("mechanism.  Also please indicate if you believe that you have a currently");
            this.reportLine("working network connection.");
            this.reportLine("");
            this.showProperty("java.version");
            this.showProperty("java.version.date");
            this.showProperty("java.runtime.name");
            this.showProperty("java.runtime.version");
            this.showProperty("java.vendor");
            this.showProperty("java.vendor.url");
            this.showProperty("java.vendor.url.bug");
            this.showProperty("java.vendor.version");
            this.showProperty("java.vm.name");
            this.showProperty("java.vm.vendor");
            this.showProperty("java.vm.version");
            this.showProperty("os.arch");
            this.showProperty("os.name");
            this.showProperty("os.version");
            for (String message : this.messages) {
                this.reportLine(message);
            }
        }

        protected void reportLine(String line) {
            System.out.println(line);
        }

        private void showProperty(String key) {
            this.reportLine(key + ": " + System.getProperty(key));
        }

        public Collection<String> getMessages() {
            return this.messages;
        }
    }
}

