/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.org.plumelib.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.nullaway.checker.formatter.qual.FormatBottom;
import org.checkerframework.nullaway.checker.formatter.qual.UnknownFormat;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.interning.qual.Interned;
import org.checkerframework.nullaway.checker.interning.qual.UnknownInterned;
import org.checkerframework.nullaway.checker.lock.qual.GuardSatisfied;
import org.checkerframework.nullaway.checker.lock.qual.GuardedBy;
import org.checkerframework.nullaway.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.nullaway.checker.mustcall.qual.MustCall;
import org.checkerframework.nullaway.checker.nonempty.qual.EnsuresNonEmptyIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.regex.qual.UnknownRegex;
import org.checkerframework.nullaway.checker.signature.qual.SignatureUnknown;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.common.initializedfields.qual.InitializedFields;
import org.checkerframework.nullaway.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;
import org.checkerframework.nullaway.org.plumelib.util.IPair;

public class OrderedPairIterator<@FormatBottom T>
implements Iterator<IPair<T, T>> {
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor1;
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor2;
    @Nullable T next1;
    @Nullable T next2;
    @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Comparator<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @InitializedFields(value={}) ? super T> comparator;

    public OrderedPairIterator(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor1, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor2) {
        this.itor1 = itor1;
        this.itor2 = itor2;
        this.setnext1();
        this.setnext2();
    }

    public OrderedPairIterator(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor1, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<T> itor2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Comparator<T> comparator) {
        this(itor1, itor2);
        this.comparator = comparator;
    }

    @RequiresNonNull(value={"itor1"})
    private void setnext1(@GuardSatisfied OrderedPairIterator<T> this) {
        this.next1 = this.itor1.hasNext() ? this.itor1.next() : null;
    }

    @RequiresNonNull(value={"itor2"})
    private void setnext2(@GuardSatisfied OrderedPairIterator<T> this) {
        this.next2 = this.itor2.hasNext() ? this.itor2.next() : null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean hasNext(@GuardSatisfied OrderedPairIterator<T> this) {
        return this.next1 != null || this.next2 != null;
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) IPair<@Nullable T, @Nullable T> return1(@GuardSatisfied OrderedPairIterator<T> this) {
        IPair<@Nullable T, @Nullable Object> result = IPair.of(this.next1, null);
        this.setnext1();
        return result;
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) IPair<@Nullable T, @Nullable T> return2(@GuardSatisfied OrderedPairIterator<T> this) {
        IPair<@Nullable Object, @Nullable T> result = IPair.of(null, this.next2);
        this.setnext2();
        return result;
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) IPair<@Nullable T, @Nullable T> returnboth(@GuardSatisfied OrderedPairIterator<T> this) {
        IPair<@Nullable T, @Nullable T> result = IPair.of(this.next1, this.next2);
        this.setnext1();
        this.setnext2();
        return result;
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) IPair<@Nullable T, @Nullable T> next(@GuardSatisfied OrderedPairIterator<T> this) {
        int comparison;
        if (this.next1 == null) {
            if (this.next2 == null) {
                throw new NoSuchElementException();
            }
            return this.return2();
        }
        if (this.next2 == null) {
            return this.return1();
        }
        try {
            if (this.comparator == null) {
                Comparable cble1 = (Comparable)this.next1;
                comparison = cble1.compareTo(this.next2);
            } else {
                comparison = this.comparator.compare(this.next1, this.next2);
            }
        }
        catch (NullPointerException npe) {
            if (this.next1 == null && this.next2 == null) {
                comparison = 0;
            }
            if (this.next1 == null && this.next2 != null) {
                comparison = -1;
            }
            if (this.next1 != null && this.next2 == null) {
                comparison = 1;
            }
            throw new RuntimeException("this can't happen " + this.next1 + " " + this.next2);
        }
        if (comparison < 0) {
            return this.return1();
        }
        if (comparison > 0) {
            return this.return2();
        }
        return this.returnboth();
    }

    @Override
    public void remove(@GuardSatisfied OrderedPairIterator<T> this) {
        throw new UnsupportedOperationException();
    }
}

