/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.org.plumelib.util;

import java.util.LinkedHashSet;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.nullaway.checker.formatter.qual.FormatBottom;
import org.checkerframework.nullaway.checker.formatter.qual.UnknownFormat;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.interning.qual.Interned;
import org.checkerframework.nullaway.checker.interning.qual.UnknownInterned;
import org.checkerframework.nullaway.checker.lock.qual.GuardSatisfied;
import org.checkerframework.nullaway.checker.lock.qual.GuardedBy;
import org.checkerframework.nullaway.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.nullaway.checker.mustcall.qual.MustCall;
import org.checkerframework.nullaway.checker.nonempty.qual.EnsuresNonEmpty;
import org.checkerframework.nullaway.checker.nonempty.qual.EnsuresNonEmptyIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.regex.qual.UnknownRegex;
import org.checkerframework.nullaway.checker.signature.qual.SignatureUnknown;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.common.initializedfields.qual.InitializedFields;
import org.checkerframework.nullaway.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;
import org.checkerframework.nullaway.org.plumelib.util.AbstractMostlySingletonSet;

public final class MostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public MostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public MostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    @EnsuresNonEmpty(value={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean add(@GuardSatisfied MostlySingletonSet<T> this, T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                if (this.value.equals(e)) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): ANY => value != null";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton() {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = new LinkedHashSet();
        assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied MostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                return this.value.equals(o);
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

