/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="unlock-snapshots", threadSafe=true)
public class UnlockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final Pattern TIMESTAMPED_SNAPSHOT_REGEX = Pattern.compile("-(\\d{8}\\.\\d{6})-(\\d+)$");
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;

    @Inject
    public UnlockSnapshotsMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return true;
    }

    @Override
    protected boolean getProcessDependencies() {
        return this.processDependencies;
    }

    @Override
    protected boolean getProcessDependencyManagement() {
        return this.processDependencyManagement;
    }

    @Override
    public boolean getProcessParent() {
        return this.processParent;
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.getProcessDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.unlockSnapshots(pom, dependencyManagement.getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.getProcessDependencies()) {
                this.unlockSnapshots(pom, this.getProject().getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.getProcessParent()) {
                this.unlockParentSnapshot(pom, this.getProject().getParent());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void unlockSnapshots(MutableXMLStreamReader pom, List<Dependency> dependencies, DependencyChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String version;
            Matcher versionMatcher;
            if (this.getExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length()) continue;
            String unlockedVersion = versionMatcher.replaceFirst("-SNAPSHOT");
            if (!PomHelper.setDependencyVersion((MutableXMLStreamReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion(), (String)unlockedVersion, (Model)this.getProject().getModel(), (Log)this.getLog())) continue;
            this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(changeKind).withDependency(dep).withNewVersion(unlockedVersion).build());
            this.getLog().info((CharSequence)("Unlocked " + this.toString(dep) + " to version " + unlockedVersion));
        }
    }

    private void unlockParentSnapshot(MutableXMLStreamReader pom, MavenProject parent) throws XMLStreamException, MojoExecutionException {
        String unlockedParentVersion;
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length() && PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)(unlockedParentVersion = versionMatcher.replaceFirst("-SNAPSHOT")))) {
            this.getLog().info((CharSequence)("Unlocked parent " + parentArtifact + " to version " + unlockedParentVersion));
            this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(DependencyChangeRecord.ChangeKind.PARENT).withArtifact(parentArtifact).withNewVersion(unlockedParentVersion).build());
        }
    }
}

