/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.jodatime.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.TypeConverter;
import org.joda.time.Interval;

public class JodaIntervalMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        ColumnMetaData[] colmds = JodaIntervalMapping.getColumnMetaDataForMember((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember);
        if (colmds != null && colmds.length == 1) {
            MappingManager mmgr = this.table.getStoreManager().getMappingManager();
            Column col = mmgr.createColumn((JavaTypeMapping)this, ClassNameConstants.JAVA_LANG_STRING, 0);
            mmgr.createColumnMapping((JavaTypeMapping)this, this.mmd, 0, col);
        } else {
            this.addColumns(ClassNameConstants.JAVA_SQL_TIMESTAMP);
            this.addColumns(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        }
    }

    public String getJavaTypeForColumnMapping(int index) {
        if (this.columnMappings != null && this.columnMappings.length == 1 && this.columnMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return ClassNameConstants.JAVA_SQL_TIMESTAMP;
    }

    public Class getJavaType() {
        return Interval.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Interval intvl = (Interval)value;
        if (this.getNumberOfColumnMappings() == 1) {
            return super.getValueForColumnMapping(nucleusCtx, index, value);
        }
        if (index == 0) {
            return intvl.getStartMillis();
        }
        if (index == 1) {
            return intvl.getEndMillis();
        }
        throw new IndexOutOfBoundsException();
    }

    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(rs, exprIndex[0]) == null) {
            return null;
        }
        if (this.columnMappings != null && this.columnMappings.length == 1 && this.columnMappings[0].isStringBased()) {
            Object datastoreValue = this.getColumnMapping(0).getObject(rs, exprIndex[0]);
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(Interval.class, String.class);
            if (conv != null) {
                return conv.toMemberType(datastoreValue);
            }
            throw new NucleusUserException("This type doesn't support persistence as a String");
        }
        Timestamp start = (Timestamp)this.getColumnMapping(0).getObject(rs, exprIndex[0]);
        Timestamp end = (Timestamp)this.getColumnMapping(1).getObject(rs, exprIndex[1]);
        return new Interval(start.getTime(), end.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Interval interval = (Interval)value;
        if (this.columnMappings != null && this.columnMappings.length == 1 && this.columnMappings[0].isStringBased()) {
            if (value == null) {
                this.getColumnMapping(0).setObject(ps, exprIndex[0], null);
                return;
            } else {
                TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(Interval.class, String.class);
                if (conv == null) throw new NucleusUserException("This type doesn't support persistence as a String");
                this.getColumnMapping(0).setObject(ps, exprIndex[0], conv.toDatastoreType(value));
            }
            return;
        } else if (interval == null) {
            this.getColumnMapping(0).setObject(ps, exprIndex[0], null);
            this.getColumnMapping(1).setObject(ps, exprIndex[1], null);
            return;
        } else {
            this.getColumnMapping(0).setObject(ps, exprIndex[0], (Object)new Timestamp(interval.getStartMillis()));
            this.getColumnMapping(1).setObject(ps, exprIndex[1], (Object)new Timestamp(interval.getEndMillis()));
        }
    }
}

