/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.jodatime.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringTemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.jodatime.rdbms.mapping.JodaIntervalMapping;
import org.datanucleus.store.types.jodatime.rdbms.sql.method.JodaIntervalInstantMapping;

public abstract class IntervalInstantMethod
implements SQLMethod {
    protected SQLExpression getExpressionForSingleMapping(SQLStatement stmt, SQLExpression expr, List args, int mappingIndex) {
        if (args != null && !args.isEmpty()) {
            throw new NucleusException("Cannot invoke getStart()/getEnd() with arguments.");
        }
        if (!(expr instanceof StringTemporalExpression)) {
            throw new NucleusException("Can only be used with 'StringTemporalExpression' expression types.");
        }
        JavaTypeMapping javaTypeMapping = expr.getJavaTypeMapping();
        if (!(javaTypeMapping instanceof JodaIntervalMapping)) {
            throw new NucleusException("Can only be used with 'JodaIntervalMapping' Java Type mappings.");
        }
        JodaIntervalMapping jodaIntervalMapping = (JodaIntervalMapping)javaTypeMapping;
        JodaIntervalInstantMapping startEndMapping = new JodaIntervalInstantMapping(jodaIntervalMapping, mappingIndex);
        return new TemporalExpression(stmt, expr.getSQLTable(), (JavaTypeMapping)startEndMapping);
    }
}

