/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CompositeKnowledgeBuilderImpl
implements CompositeKnowledgeBuilder {
    private final PackageBuilder pkgBuilder;
    private final Map<ResourceType, List<ResourceDescr>> resourcesByType = new HashMap<ResourceType, List<ResourceDescr>>();
    private RuntimeException buildException = null;
    public ResourceType currentType = null;
    private static final ResourceToPkgDescrMapper DRL_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(PackageBuilder pkgBuilder, ResourceDescr resourceDescr) throws Exception {
            return pkgBuilder.drlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DSLR_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(PackageBuilder pkgBuilder, ResourceDescr resourceDescr) throws Exception {
            return pkgBuilder.dslrToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper XML_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(PackageBuilder pkgBuilder, ResourceDescr resourceDescr) throws Exception {
            return pkgBuilder.xmlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DTABLE_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(PackageBuilder pkgBuilder, ResourceDescr resourceDescr) throws Exception {
            return pkgBuilder.decisionTableToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };
    private static final ResourceToPkgDescrMapper SCARD_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(PackageBuilder pkgBuilder, ResourceDescr resourceDescr) throws Exception {
            return pkgBuilder.scoreCardToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };

    public CompositeKnowledgeBuilderImpl(PackageBuilder pkgBuilder) {
        this.pkgBuilder = pkgBuilder;
    }

    public CompositeKnowledgeBuilder type(ResourceType type) {
        this.currentType = type;
        return this;
    }

    public CompositeKnowledgeBuilder add(Resource resource) {
        if (this.currentType == null) {
            throw new RuntimeException("You must declare the type of the resource");
        }
        return this.add(resource, this.currentType);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type) {
        return this.add(resource, type, resource.getConfiguration());
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceChangeSet changes) {
        return this.add(resource, type, resource.getConfiguration(), changes);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        return this.add(resource, type, configuration, null);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration, ResourceChangeSet changes) {
        ResourceDescr resourceDescr = new ResourceDescr(configuration, resource, changes);
        List<ResourceDescr> resourceDescrs = this.resourcesByType.get(type);
        if (resourceDescrs == null) {
            resourceDescrs = new ArrayList<ResourceDescr>();
            this.resourcesByType.put(type, resourceDescrs);
        }
        resourceDescrs.add(resourceDescr);
        return this;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (List<ResourceDescr> resourceDescrs : this.resourcesByType.values()) {
            for (ResourceDescr resourceDescr : resourceDescrs) {
                resources.add(resourceDescr.resource);
            }
        }
        return resources;
    }

    public void build() {
        this.buildException = null;
        this.pkgBuilder.registerBuildResources(this.getResources());
        this.registerDSL();
        this.buildResources();
        this.buildPackages();
        this.buildOthers();
        this.resourcesByType.clear();
        if (this.buildException != null) {
            throw this.buildException;
        }
    }

    private void buildPackages() {
        Collection<CompositePackageDescr> packages = this.buildPackageDescr();
        this.buildTypeDeclarations(packages);
        this.buildRules(packages);
    }

    private void registerDSL() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DSL);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addDsl(resourceDescr.resource);
                    this.pkgBuilder.setAssetFilter(null);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResources() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DRF);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.BPMN2)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    BPMN2ProcessFactory.configurePackageBuilder(this.pkgBuilder);
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.CHANGE_SET)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addPackageFromChangeSet(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.XSD)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addPackageFromXSD(resourceDescr.resource, (JaxbConfigurationImpl)resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.PMML)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addPackageFromPMML(resourceDescr.resource, ResourceType.PMML, resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
    }

    private void buildOthers() {
        try {
            for (Map.Entry<ResourceType, List<ResourceDescr>> entry : this.resourcesByType.entrySet()) {
                for (ResourceDescr resourceDescr : entry.getValue()) {
                    this.pkgBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.pkgBuilder.addPackageForExternalType(resourceDescr.resource, entry.getKey(), resourceDescr.configuration);
                    this.pkgBuilder.setAssetFilter(null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildRules(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.pkgBuilder.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.pkgBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.pkgBuilder.processOtherDeclarations(pkgRegistry, packageDescr);
            this.pkgBuilder.compileAllRules(packageDescr, pkgRegistry);
            this.pkgBuilder.setAssetFilter(null);
        }
    }

    private void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
                if (this.pkgBuilder.isEmpty(typeDeclarationDescr.getNamespace())) {
                    typeDeclarationDescr.setNamespace(packageDescr.getNamespace());
                }
                this.pkgBuilder.registerGeneratedType(typeDeclarationDescr);
            }
        }
        ArrayList<PackageBuilder.TypeDefinition> unresolvedTypes = new ArrayList<PackageBuilder.TypeDefinition>();
        for (CompositePackageDescr packageDescr : packages) {
            this.buildTypeDeclarations(packageDescr, unresolvedTypes);
        }
        for (PackageBuilder.TypeDefinition unresolvedType : unresolvedTypes) {
            this.pkgBuilder.processUnresolvedType(this.pkgBuilder.getPackageRegistry(unresolvedType.getNamespace()), unresolvedType);
        }
        for (CompositePackageDescr packageDescr : packages) {
            for (ImportDescr importDescr : packageDescr.getImports()) {
                this.pkgBuilder.getPackageRegistry(packageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    private List<PackageBuilder.TypeDefinition> buildTypeDeclarations(CompositePackageDescr packageDescr, List<PackageBuilder.TypeDefinition> unresolvedTypes) {
        this.pkgBuilder.setAssetFilter(packageDescr.getFilter());
        PackageRegistry pkgRegistry = this.pkgBuilder.initPackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return null;
        }
        this.pkgBuilder.processEntryPointDeclarations(pkgRegistry, packageDescr);
        List<PackageBuilder.TypeDefinition> processTypeDeclarations = this.pkgBuilder.processTypeDeclarations(pkgRegistry, packageDescr, unresolvedTypes);
        this.pkgBuilder.setAssetFilter(null);
        return processTypeDeclarations;
    }

    private Collection<CompositePackageDescr> buildPackageDescr() {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        this.buildResource(packages, ResourceType.DRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DESCR, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.XDRL, XML_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DTABLE, DTABLE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.SCARD, SCARD_TO_PKG_DESCR);
        return packages.values();
    }

    private void buildResource(Map<String, CompositePackageDescr> packages, ResourceType resourceType, ResourceToPkgDescrMapper mapper) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(resourceDescr, packages, resourceDescr.resource, mapper.map(this.pkgBuilder, resourceDescr));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void registerPackageDescr(ResourceDescr resourceDescr, Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr != null) {
            CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
            if (compositePackageDescr == null) {
                compositePackageDescr = new CompositePackageDescr(resource, packageDescr);
                packages.put(packageDescr.getNamespace(), compositePackageDescr);
            } else {
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            compositePackageDescr.addFilter(resourceDescr.getFilter());
        }
    }

    private static interface ResourceToPkgDescrMapper {
        public PackageDescr map(PackageBuilder var1, ResourceDescr var2) throws Exception;
    }

    private static class ResourceDescr {
        final Resource resource;
        final ResourceConfiguration configuration;
        final ResourceChangeSet changes;
        final Map<String, ResourceChange> changeMap;

        private ResourceDescr(ResourceConfiguration configuration, Resource resource, ResourceChangeSet changes) {
            this.configuration = configuration;
            this.resource = resource;
            this.changes = changes;
            if (changes != null) {
                this.changeMap = new HashMap<String, ResourceChange>();
                for (ResourceChange c : changes.getChanges()) {
                    this.changeMap.put(c.getName(), c);
                }
            } else {
                this.changeMap = null;
            }
        }

        public PackageBuilder.AssetFilter getFilter() {
            return this.changeMap == null ? null : new ChangeSetAssetFilter();
        }

        private class ChangeSetAssetFilter
        implements PackageBuilder.AssetFilter {
            private ChangeSetAssetFilter() {
            }

            @Override
            public PackageBuilder.AssetFilter.Action accept(String pkgName, String assetName) {
                ResourceChange change = ResourceDescr.this.changeMap.get(assetName);
                if (change == null) {
                    return PackageBuilder.AssetFilter.Action.DO_NOTHING;
                }
                if (change.getChangeType().equals((Object)ChangeType.ADDED)) {
                    return PackageBuilder.AssetFilter.Action.ADD;
                }
                if (change.getChangeType().equals((Object)ChangeType.REMOVED)) {
                    return PackageBuilder.AssetFilter.Action.REMOVE;
                }
                if (change.getChangeType().equals((Object)ChangeType.UPDATED)) {
                    return PackageBuilder.AssetFilter.Action.UPDATE;
                }
                return PackageBuilder.AssetFilter.Action.DO_NOTHING;
            }
        }
    }
}

