/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr in different namespaces");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        List<ImportDescr> currentImports = this.getImports();
        for (ImportDescr importDescr : packageDescr.getImports()) {
            if (currentImports.contains(importDescr)) continue;
            this.addImport(importDescr);
            importDescr.setResource(resource);
        }
        List<FunctionImportDescr> currentFunctionImports = this.getFunctionImports();
        for (FunctionImportDescr functionImportDescr : packageDescr.getFunctionImports()) {
            if (currentFunctionImports.contains(functionImportDescr)) continue;
            this.addFunctionImport(functionImportDescr);
            functionImportDescr.setResource(resource);
        }
        List<AttributeDescr> list = this.getAttributes();
        for (AttributeDescr attributeDescr : packageDescr.getAttributes()) {
            if (list.contains(attributeDescr)) continue;
            this.addAttribute(attributeDescr);
            attributeDescr.setResource(resource);
        }
        List<GlobalDescr> list2 = this.getGlobals();
        for (GlobalDescr globalDescr : packageDescr.getGlobals()) {
            if (list2.contains(globalDescr)) continue;
            this.addGlobal(globalDescr);
            globalDescr.setResource(resource);
        }
        List<FunctionDescr> list3 = this.getFunctions();
        for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
            if (list3.contains(functionDescr)) continue;
            this.addFunction(functionDescr);
            functionDescr.setResource(resource);
        }
        List<RuleDescr> list4 = this.getRules();
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            if (list4.contains(ruleDescr)) continue;
            this.addRule(ruleDescr);
            ruleDescr.setResource(resource);
        }
        List<TypeDeclarationDescr> list5 = this.getTypeDeclarations();
        for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
            if (list5.contains(typeDeclarationDescr)) continue;
            this.addTypeDeclaration(typeDeclarationDescr);
            typeDeclarationDescr.setResource(resource);
        }
        Set<EntryPointDeclarationDescr> set = this.getEntryPointDeclarations();
        for (EntryPointDeclarationDescr descr : packageDescr.getEntryPointDeclarations()) {
            if (set.contains(descr)) continue;
            this.addEntryPointDeclaration(descr);
            descr.setResource(resource);
        }
        Set<WindowDeclarationDescr> set2 = this.getWindowDeclarations();
        for (WindowDeclarationDescr descr : packageDescr.getWindowDeclarations()) {
            if (set2.contains(descr)) continue;
            this.addWindowDeclaration(descr);
            descr.setResource(resource);
        }
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(PackageBuilder.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements PackageBuilder.AssetFilter {
        public List<PackageBuilder.AssetFilter> filters = new ArrayList<PackageBuilder.AssetFilter>();

        @Override
        public PackageBuilder.AssetFilter.Action accept(String pkgName, String assetName) {
            for (PackageBuilder.AssetFilter filter : this.filters) {
                PackageBuilder.AssetFilter.Action result = filter.accept(pkgName, assetName);
                if (PackageBuilder.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return PackageBuilder.AssetFilter.Action.DO_NOTHING;
        }
    }
}

