/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.licenses.maven;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;

public abstract class AbstractArtifactFilteringMojo
extends AbstractMojo {
    @Parameter(property="includeScope", defaultValue="compile")
    protected String includeScope;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter(property="includeTypes", defaultValue="")
    protected String includeTypes;
    @Parameter(property="excludeTypes", defaultValue="")
    protected String excludeTypes;
    @Parameter(property="includeClassifiers", defaultValue="")
    protected String includeClassifiers;
    @Parameter(property="excludeClassifiers", defaultValue="")
    protected String excludeClassifiers;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;

    protected Set<Artifact> filterArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter(AbstractArtifactFilteringMojo.sanitise(this.includeScope), AbstractArtifactFilteringMojo.sanitise(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(AbstractArtifactFilteringMojo.sanitise(this.includeTypes), AbstractArtifactFilteringMojo.sanitise(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(AbstractArtifactFilteringMojo.sanitise(this.includeClassifiers), AbstractArtifactFilteringMojo.sanitise(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(AbstractArtifactFilteringMojo.sanitise(this.includeGroupIds), AbstractArtifactFilteringMojo.sanitise(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(AbstractArtifactFilteringMojo.sanitise(this.includeArtifactIds), AbstractArtifactFilteringMojo.sanitise(this.excludeArtifactIds)));
        try {
            return filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static String sanitise(String value) {
        String sanitised = "";
        if (value != null && !value.isEmpty()) {
            sanitised = value.trim().replaceAll("[\\s]*,[\\s]*", ",");
        }
        return sanitised;
    }
}

