/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.licenses.maven;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.eclipse.dash.licenses.ContentId;
import org.eclipse.dash.licenses.IProxySettings;
import org.eclipse.dash.licenses.ISettings;
import org.eclipse.dash.licenses.LicenseChecker;
import org.eclipse.dash.licenses.LicenseData;
import org.eclipse.dash.licenses.cli.CSVCollector;
import org.eclipse.dash.licenses.cli.IResultsCollector;
import org.eclipse.dash.licenses.cli.NeedsReviewCollector;
import org.eclipse.dash.licenses.context.LicenseToolModule;
import org.eclipse.dash.licenses.maven.AbstractArtifactFilteringMojo;
import org.eclipse.dash.licenses.maven.MavenProxySettings;
import org.eclipse.dash.licenses.maven.MavenSettings;
import org.eclipse.dash.licenses.review.CreateReviewRequestCollector;
import org.eclipse.dash.licenses.review.GitLabSupport;
import org.eclipse.dash.licenses.validation.EclipseProjectIdValidator;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="license-check", requiresProject=true, aggregator=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class LicenseCheckMojo
extends AbstractArtifactFilteringMojo {
    private static final String P2_GROUPID_PREFIX = "p2.";
    @Parameter(property="dash.projectId")
    private String projectId;
    @Parameter(property="dash.repo")
    private String repo;
    @Parameter(property="dash.summary", defaultValue="${project.build.directory}/dash/summary")
    private File summary;
    @Parameter(property="dash.review.summary", defaultValue="${project.build.directory}/dash/review-summary")
    private File reviewSummary;
    @Parameter(property="dash.batch", defaultValue="500")
    private int batch;
    @Parameter(property="dash.foundationApi", defaultValue="https://www.eclipse.org/projects/services/license_check.php")
    private String foundationApi;
    @Parameter(property="dash.clearlyDefinedApi", defaultValue="https://api.clearlydefined.io/definitions")
    private String clearlyDefinedApi;
    @Parameter(property="dash.licenses", defaultValue="https://www.eclipse.org/legal/licenses.json")
    private String licenses;
    @Parameter(property="dash.confidence", defaultValue="60")
    private int confidence;
    @Parameter(property="dash.iplab.token")
    private String iplabToken;
    @Parameter(property="dash.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="dash.fail", defaultValue="false")
    private boolean failWhenReviewNeeded;
    @Parameter(property="dash.proxy")
    private String proxy;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component
    private SecDispatcher securityDispatcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EclipseProjectIdValidator validator;
        MavenSettings settings;
        if (!this.mavenSession.getCurrentProject().equals((Object)this.mavenSession.getTopLevelProject())) {
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping dependency license check");
            return;
        }
        try {
            settings = new MavenSettings(this.batch, this.foundationApi, this.clearlyDefinedApi, this.licenses, this.confidence, this.projectId, this.iplabToken, this.repo);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Invalid setting: " + e.getMessage());
        }
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (MavenProject project : this.reactorProjects) {
            filteredArtifacts.addAll(this.filterArtifacts(project.getArtifacts()));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Filtered dependency artifact list:");
            filteredArtifacts.stream().sorted().map(a -> "  " + a).forEach(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        }
        ArrayList deps = new ArrayList();
        filteredArtifacts.stream().sorted().forEach(a -> {
            String type = a.getGroupId().startsWith(P2_GROUPID_PREFIX) ? "p2" : "maven";
            String source = a.getGroupId().startsWith(P2_GROUPID_PREFIX) ? "orbit" : "mavencentral";
            deps.add(ContentId.getContentId((String)type, (String)source, (String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion()));
        });
        ArrayList<Object> collectors = new ArrayList<Object>();
        ByteArrayOutputStream primaryOut = new ByteArrayOutputStream();
        NeedsReviewCollector needsReviewCollector = new NeedsReviewCollector();
        collectors.add(needsReviewCollector);
        Injector injector = Guice.createInjector((Module[])new Module[]{new LicenseToolModule((ISettings)settings, this.createProxySettings())});
        if (settings.getProjectId() != null && !(validator = (EclipseProjectIdValidator)injector.getInstance(EclipseProjectIdValidator.class)).validate(settings.getProjectId(), message -> this.getLog().error((CharSequence)message))) {
            throw new MojoExecutionException("Invalid project id.");
        }
        LicenseChecker checker = (LicenseChecker)injector.getInstance(LicenseChecker.class);
        this.summary.getParentFile().mkdirs();
        this.reviewSummary.getParentFile().mkdirs();
        try (FileOutputStream summaryOut = new FileOutputStream(this.summary);
             PrintWriter reviewSummaryOut = new PrintWriter(new FileWriter(this.reviewSummary));){
            collectors.add(new CSVCollector((OutputStream)summaryOut));
            if (this.iplabToken != null && this.projectId != null) {
                collectors.add(new CreateReviewRequestCollector((GitLabSupport)injector.getInstance(GitLabSupport.class), (id, url) -> reviewSummaryOut.println("[" + id + "](" + url + ")")));
            } else if (this.iplabToken != null) {
                this.getLog().info((CharSequence)"Provide both an authentication token and a project id to automatically create review tickets.");
            }
            for (LicenseData licenseData : checker.getLicenseData(deps).values()) {
                collectors.forEach(c -> c.accept(licenseData));
            }
            collectors.forEach(IResultsCollector::close);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write dependency summary file", (Exception)e);
        }
        primaryOut.toString(StandardCharsets.UTF_8).lines().forEach(arg_0 -> ((Log)this.getLog()).info(arg_0));
        this.getLog().info((CharSequence)("Summary file was written to: " + this.summary));
        if (this.failWhenReviewNeeded && needsReviewCollector.getStatus() > 0) {
            this.getLog().error((CharSequence)"Dependency license check failed. Some dependencies need to be vetted.");
            throw new MojoFailureException("Some dependencies must be vetted.");
        }
    }

    protected IProxySettings createProxySettings() {
        Proxy proxyServer = this.mavenSession.getSettings().getActiveProxy();
        if (this.proxy != null && (proxyServer = (Proxy)this.mavenSession.getSettings().getProxies().stream().filter(p -> this.proxy.equals(p.getId())).findFirst().orElse(null)) == null) {
            this.getLog().warn((CharSequence)MessageFormat.format("No such proxy server is activated in settings.xml: {0}", this.proxy));
            return null;
        }
        if (proxyServer == null) {
            return null;
        }
        return new MavenProxySettings(proxyServer.getProtocol(), proxyServer.getHost(), proxyServer.getPort(), proxyServer.getUsername(), proxyServer.getPassword(), this.securityDispatcher, this.getLog());
    }
}

