/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.licenses.maven;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.dash.licenses.IProxySettings;
import org.gitlab4j.api.ProxyClientConfig;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class MavenProxySettings
implements IProxySettings {
    private static String DEFAULT_PROXY_PROTOCOL = "http";
    private static Pattern PROTOCOL_PATTERN = Pattern.compile("^\\w+");
    private final URI proxyURI;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;
    private final SecDispatcher securityDispatcher;
    private final Log log;

    public MavenProxySettings(String proxyProtocol, String proxyHost, int proxyPort, String username, String password, SecDispatcher securityDispatcher, Log log) {
        this.proxyURI = URI.create(String.format("%s://%s:%s", MavenProxySettings.sanitizeProtocol(proxyProtocol), proxyHost, proxyPort));
        this.proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
        this.username = username;
        this.password = password;
        this.securityDispatcher = securityDispatcher;
        this.log = log;
    }

    public void configure(HttpClient.Builder httpClientBuilder) {
        ProxySelector proxySelector = ProxySelector.of(this.proxyAddress);
        httpClientBuilder.proxy(proxySelector);
        if (this.username != null && this.password != null) {
            httpClientBuilder.authenticator(new ProxyAuthenticator());
        }
    }

    public void configureJerseyClient(Map<String, Object> clientConfig) {
        clientConfig.putAll(ProxyClientConfig.createProxyClientConfig((String)this.proxyURI.toString(), (String)this.username, (String)this.password));
    }

    private static String sanitizeProtocol(String protocol) {
        if (protocol == null || protocol.isBlank()) {
            return DEFAULT_PROXY_PROTOCOL;
        }
        Matcher matcher = PROTOCOL_PATTERN.matcher(protocol);
        return matcher.find() ? matcher.group() : DEFAULT_PROXY_PROTOCOL;
    }

    static {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
    }

    private class ProxyAuthenticator
    extends Authenticator {
        private ProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (!this.getRequestingHost().equals(MavenProxySettings.this.proxyAddress.getAddress().getHostName())) {
                return null;
            }
            MavenProxySettings.this.log.debug((CharSequence)("Request to authenticate proxy " + this.getRequestingHost()));
            String password = MavenProxySettings.this.password;
            try {
                password = MavenProxySettings.this.securityDispatcher.decrypt(password);
            }
            catch (SecDispatcherException e) {
                MavenProxySettings.this.log.warn((CharSequence)MessageFormat.format("Failed to decrypt password for proxy server: {0}\nPassword will be attempted verbatim.", e.getMessage()));
            }
            return new PasswordAuthentication(MavenProxySettings.this.username, password.toCharArray());
        }
    }
}

