/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.licenses.maven;

import java.net.URI;
import org.eclipse.dash.licenses.ISettings;

public class MavenSettings
implements ISettings {
    private final int batch;
    private final String foundationApi;
    private final String clearlyDefinedApi;
    private final String licenses;
    private final int confidence;
    private final String iplabToken;
    private String projectId;
    private String repository;

    public MavenSettings(int batch, String foundationApi, String clearlyDefinedApi, String licenses, int confidence, String projectId, String iplabToken, String repo) {
        this.iplabToken = iplabToken;
        this.projectId = projectId;
        this.repository = repo;
        if (batch < 0) {
            throw new IllegalArgumentException("batch must be a positive integer");
        }
        this.batch = batch;
        URI.create(foundationApi);
        this.foundationApi = foundationApi;
        URI.create(clearlyDefinedApi);
        this.clearlyDefinedApi = clearlyDefinedApi;
        URI.create(licenses);
        this.licenses = licenses;
        if (confidence < 0 || confidence > 100) {
            throw new IllegalArgumentException("confidence must be in the range 0-100");
        }
        this.confidence = confidence;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public String getLicenseCheckUrl() {
        return this.foundationApi;
    }

    public String getClearlyDefinedDefinitionsUrl() {
        return this.clearlyDefinedApi;
    }

    public String getApprovedLicensesUrl() {
        return this.licenses;
    }

    public int getConfidenceThreshold() {
        return this.confidence;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRepository() {
        if (this.repository != null && this.repository.isBlank()) {
            return null;
        }
        return this.repository;
    }

    public String getIpLabToken() {
        return this.iplabToken;
    }
}

