/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api;

import io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.openshift.api.model.DeploymentConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.enricher.api.Enricher;
import org.eclipse.jkube.kit.enricher.api.EnricherConfig;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.model.Configuration;

public class BaseEnricher
implements Enricher {
    public static final String FABRIC8_GENERATED_CONTAINERS = "FABRIC8_GENERATED_CONTAINERS";
    public static final String NEED_IMAGECHANGE_TRIGGERS = "IMAGECHANGE_TRIGGER";
    public static final String IMAGE_CHANGE_TRIGGERS = "jkube.openshift.imageChangeTriggers";
    public static final String OPENSHIFT_TRIM_IMAGE_IN_CONTAINER_SPEC = "jkube.openshift.trimImageInContainerSpec";
    public static final String OPENSHIFT_ENABLE_AUTOMATIC_TRIGGER = "jkube.openshift.enableAutomaticTrigger";
    public static final String SIDECAR = "jkube.sidecar";
    public static final String ENRICH_ALL_WITH_IMAGE_TRIGGERS = "jkube.openshift.enrichAllWithImageChangeTrigger";
    public static final String OPENSHIFT_DEPLOY_TIMEOUT_SECONDS = "jkube.openshift.deployTimeoutSeconds";
    private static final String SWITCH_TO_DEPLOYMENT = "jkube.build.switchToDeployment";
    public static final String CREATE_EXTERNAL_URLS = "jkube.createExternalUrls";
    public static final String JKUBE_DOMAIN = "jkube.domain";
    public static final String JKUBE_ENFORCED_REPLICAS = "jkube.replicas";
    public static final String JKUBE_DEFAULT_IMAGE_PULL_POLICY = "IfNotPresent";
    public static final String JKUBE_ENFORCED_IMAGE_PULL_POLICY = "jkube.imagePullPolicy";
    private final EnricherConfig config;
    private final String name;
    protected EnricherContext enricherContext;
    protected KitLogger log;

    public BaseEnricher(EnricherContext enricherContext, String name) {
        this.enricherContext = enricherContext;
        this.config = new EnricherConfig(name, enricherContext);
        this.log = new PrefixedLogger(name, enricherContext.getLog());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    @Override
    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    @Override
    public EnricherContext getContext() {
        return this.enricherContext;
    }

    protected KitLogger getLog() {
        return this.log;
    }

    protected List<ImageConfiguration> getImages() {
        return Optional.ofNullable(this.enricherContext.getConfiguration().getImages()).orElse(Collections.emptyList());
    }

    protected boolean hasImageConfiguration() {
        return !this.enricherContext.getConfiguration().getImages().isEmpty();
    }

    protected Configuration getConfiguration() {
        return this.enricherContext.getConfiguration();
    }

    protected String getConfig(Configs.Config key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Config key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected String getConfigWithFallback(Configs.Config key, String fallbackPropertyKey, String defaultVal) {
        String value = this.getConfig(key, Configs.getFromSystemPropertyWithPropertiesAsFallback((Properties)this.enricherContext.getProperties(), (String)fallbackPropertyKey));
        if (value != null) {
            return value;
        }
        return defaultVal;
    }

    protected boolean isOpenShiftMode() {
        Properties properties = this.getContext().getProperties();
        if (properties != null) {
            return RuntimeMode.isOpenShiftMode((Properties)properties);
        }
        return false;
    }

    protected List<String> getProcessingInstructionViaKey(String key) {
        ArrayList<String> containers = new ArrayList<String>();
        if (this.enricherContext.getProcessingInstructions() != null && this.enricherContext.getProcessingInstructions().get(key) != null) {
            containers.addAll(Arrays.asList(this.enricherContext.getProcessingInstructions().get(key).split(",")));
        }
        return containers;
    }

    protected Long getOpenshiftDeployTimeoutInSeconds(Long defaultValue) {
        return Long.parseLong(this.getValueFromConfig(OPENSHIFT_DEPLOY_TIMEOUT_SECONDS, defaultValue.toString()));
    }

    protected String getControllerName(ResourceConfig resourceConfig, String defaultValue) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getControllerName).orElse(defaultValue);
    }

    protected String getImagePullPolicy(ResourceConfig resourceConfig, Configs.Config enricherConfig) {
        String imagePullPolicyFromEnricherConfig;
        String imagePullPolicyFromProperty = this.getValueFromConfig(JKUBE_ENFORCED_IMAGE_PULL_POLICY, null);
        if (StringUtils.isNotBlank((CharSequence)imagePullPolicyFromProperty)) {
            return imagePullPolicyFromProperty;
        }
        if (resourceConfig != null && StringUtils.isNotBlank((CharSequence)resourceConfig.getImagePullPolicy())) {
            return resourceConfig.getImagePullPolicy();
        }
        String string = imagePullPolicyFromEnricherConfig = enricherConfig != null ? this.getConfig(enricherConfig) : null;
        if (StringUtils.isNotBlank((CharSequence)imagePullPolicyFromEnricherConfig)) {
            return imagePullPolicyFromEnricherConfig;
        }
        return JKUBE_DEFAULT_IMAGE_PULL_POLICY;
    }

    protected boolean getCreateExternalUrls() {
        String propertyValue = this.getContext().getProperty(CREATE_EXTERNAL_URLS);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            return Boolean.parseBoolean(propertyValue);
        }
        if (this.getConfiguration().getResource().getCreateExternalUrls() != null) {
            return this.getConfiguration().getResource().getCreateExternalUrls();
        }
        return false;
    }

    protected static int getReplicaCount(KubernetesListBuilder builder, ResourceConfig xmlResourceConfig, int defaultValue) {
        if (xmlResourceConfig != null) {
            List items = Optional.ofNullable(builder).map(BaseKubernetesListFluentImpl::buildItems).orElse(Collections.emptyList());
            for (HasMetadata item : items) {
                if (item instanceof Deployment && ((Deployment)item).getSpec().getReplicas() != null) {
                    return ((Deployment)item).getSpec().getReplicas();
                }
                if (!(item instanceof DeploymentConfig) || ((DeploymentConfig)item).getSpec().getReplicas() == null) continue;
                return ((DeploymentConfig)item).getSpec().getReplicas();
            }
            return xmlResourceConfig.getReplicas() != null ? xmlResourceConfig.getReplicas() : defaultValue;
        }
        return defaultValue;
    }

    public static String getNamespace(ResourceConfig resourceConfig, String defaultValue) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getNamespace).orElse(defaultValue);
    }

    protected void setProcessingInstruction(String key, List<String> containerNames) {
        HashMap<String, String> processingInstructionsMap = new HashMap<String, String>();
        if (this.enricherContext.getProcessingInstructions() != null) {
            processingInstructionsMap.putAll(this.enricherContext.getProcessingInstructions());
        }
        processingInstructionsMap.put(key, String.join((CharSequence)",", containerNames));
        this.enricherContext.setProcessingInstructions(processingInstructionsMap);
    }

    protected boolean getValueFromConfig(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getValueFromConfig(propertyName, Boolean.toString(defaultValue)));
    }

    protected boolean useDeploymentForOpenShift() {
        return this.getValueFromConfig(SWITCH_TO_DEPLOYMENT, false);
    }

    protected String getValueFromConfig(String propertyName, String defaultValue) {
        if (this.getContext().getProperty(propertyName) != null) {
            return this.getContext().getProperty(propertyName);
        }
        return defaultValue;
    }
}

