/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-target-definition")
public class TychoTargetMapping
extends AbstractXMLTychoMapping {
    private static final String NAME_PREFIX = "[target] ";
    private static final String TARGET_EXTENSION = ".target";
    public static final String PACKAGING = "eclipse-target-definition";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    public float getPriority() {
        return 10.0f;
    }

    @Override
    protected boolean isValidLocation(Path location) {
        return TychoTargetMapping.getFileName(location).endsWith(TARGET_EXTENSION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected File getPrimaryArtifact(File dir) {
        File file2 = new File(dir, dir.getName() + TARGET_EXTENSION);
        if (file2.exists()) {
            return file2;
        }
        try (Stream<File> targetFiles = TychoTargetMapping.filesWithExtension(dir.toPath(), TARGET_EXTENSION);){
            List<File> files = targetFiles.toList();
            if (files.size() == 1) {
                File file = files.get(0);
                return file;
            }
            if (files.size() <= 1) return null;
            String sb = files.stream().map(File::getName).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Only one .target file is allowed per target project, or target must be named like the folder (<foldername>.target), the following targets were found: " + sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void initModelFromXML(Model model, Element xml, Path artifactFile) throws IOException {
        String fileName = TychoTargetMapping.getFileName(artifactFile);
        String artifactId = fileName.substring(0, fileName.length() - TARGET_EXTENSION.length());
        model.setArtifactId(artifactId);
        String name = TychoTargetMapping.getXMLAttributeValue(xml, "name");
        model.setName(NAME_PREFIX + (name != null ? name : artifactId));
    }
}

