/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.extensions.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.util.internal.Channels;

public final class CommandlineStreams
implements Closeable {
    private final ReadableByteChannel stdOutChannel;
    private final ReadableByteChannel stdErrChannel;
    private final WritableByteChannel stdInChannel;
    private volatile boolean closed;

    public CommandlineStreams(@Nonnull Process process) {
        InputStream stdOutStream = process.getInputStream();
        this.stdOutChannel = Channels.newBufferedChannel(stdOutStream);
        InputStream stdErrStream = process.getErrorStream();
        this.stdErrChannel = Channels.newBufferedChannel(stdErrStream);
        this.stdInChannel = Channels.newChannel(process.getOutputStream());
    }

    public ReadableByteChannel getStdOutChannel() {
        return this.stdOutChannel;
    }

    public ReadableByteChannel getStdErrChannel() {
        return this.stdErrChannel;
    }

    public WritableByteChannel getStdInChannel() {
        return this.stdInChannel;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try (ReadableByteChannel c1 = this.stdOutChannel;
             ReadableByteChannel c2 = this.stdErrChannel;
             WritableByteChannel c3 = this.stdInChannel;){
            this.closed = true;
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }
}

