/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.failsafe.util.FailsafeSummaryXmlUtils;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.extensions.SurefireConsoleOutputReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.extensions.junit5.JUnit5ConsoleOutputReporter;
import org.apache.maven.plugin.surefire.extensions.junit5.JUnit5StatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.extensions.junit5.JUnit5Xml30StatelessReporter;
import org.apache.maven.plugin.surefire.log.api.PrintStreamLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.report.ReporterConfiguration;
import org.apache.maven.surefire.api.report.ReporterFactoryOptions;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.api.testset.RunOrderParameters;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ForkedBooter;
import org.apache.maven.surefire.booter.ProcessCheckerType;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.tycho.surefire.osgibooter.Activator;
import org.eclipse.tycho.surefire.osgibooter.BundleClassLoader;
import org.eclipse.tycho.surefire.osgibooter.DumpStackTracesTimer;
import org.eclipse.tycho.surefire.osgibooter.SurefireLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiSurefireBooter {
    private static final String XSD = "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd";
    private static final String JUNIT_PLATFORM_PROVIDER = "org.apache.maven.surefire.junitplatform.JUnitPlatformProvider";

    public static int run(String[] args, Properties testProps) throws Exception {
        Bundle[] fragments;
        boolean printWires = Boolean.parseBoolean(testProps.getProperty("printWires"));
        Bundle testClassLoader = OsgiSurefireBooter.getBundleClassLoader(testProps.getProperty("testpluginname"));
        Bundle surefireClassLoader = FrameworkUtil.getBundle(ForkedBooter.class);
        BundleClassLoader delegate = new BundleClassLoader(Arrays.asList(testClassLoader, surefireClassLoader), printWires);
        ArrayList<URL> urls = new ArrayList<URL>();
        Bundle bundle = FrameworkUtil.getBundle(OsgiSurefireBooter.class);
        urls.add(OsgiSurefireBooter.getURL(bundle));
        for (Bundle frag : fragments = OsgiSurefireBooter.getFragments(bundle)) {
            urls.add(OsgiSurefireBooter.getURL(frag));
        }
        try (SurefireLoader classLoader = new SurefireLoader(urls, delegate);){
            Class<?> bootLoaded = classLoader.loadClass(OsgiSurefireBooter.class.getName());
            Method method = bootLoaded.getMethod("invokeSureFire", String[].class, Properties.class);
            int n = (Integer)method.invoke(null, args, testProps);
            return n;
        }
    }

    private static URL getURL(Bundle bundle) throws MalformedURLException {
        File adapt = (File)bundle.adapt(File.class);
        if (adapt == null) {
            String prefix;
            String location = bundle.getLocation();
            if (location.startsWith(prefix = "initial@reference:file:")) {
                File file = new File(location.substring(prefix.length()));
                try {
                    URL url = file.getCanonicalFile().toURI().toURL();
                    return url;
                }
                catch (IOException e) {
                    return file.toURI().toURL();
                }
            }
            throw new IllegalStateException("Can't adapt bundle to file: " + bundle);
        }
        return adapt.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int invokeSureFire(String[] args, Properties testProps) throws Exception {
        boolean redirectTestOutputToFile = Boolean.parseBoolean(testProps.getProperty("redirectTestOutputToFile", "false"));
        File testClassesDir = new File(testProps.getProperty("testclassesdirectory"));
        File reportsDir = new File(testProps.getProperty("reportsdirectory"));
        String provider = testProps.getProperty("testprovider");
        String runOrder = testProps.getProperty("runOrder");
        boolean trimStackTrace = Boolean.parseBoolean(testProps.getProperty("trimStackTrace", "false"));
        int skipAfterFailureCount = Integer.parseInt(testProps.getProperty("skipAfterFailureCount", "0"));
        int rerunFailingTestsCount = Integer.parseInt(testProps.getProperty("rerunFailingTestsCount", "0"));
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String key : testProps.stringPropertyNames()) {
            propertiesMap.put(key, testProps.getProperty(key));
        }
        PropertiesWrapper wrapper = new PropertiesWrapper(propertiesMap);
        List<String> suiteXmlFiles = wrapper.getStringList("testSuiteXmlFiles");
        String timeoutParameter = OsgiSurefireBooter.getArgumentValue(args, "-timeout");
        if (timeoutParameter != null) {
            DumpStackTracesTimer.startStackDumpTimeoutTimer(timeoutParameter);
        }
        boolean useSystemClassloader = false;
        boolean useManifestOnlyJar = false;
        boolean useFile = true;
        boolean printSummary = true;
        boolean disableXmlReport = false;
        ClasspathConfiguration classPathConfig = new ClasspathConfiguration(false, false);
        StartupConfiguration startupConfiguration = new StartupConfiguration(provider, classPathConfig, new ClassLoaderConfiguration(useSystemClassloader, useManifestOnlyJar), ProcessCheckerType.ALL, new LinkedList<String[]>());
        DirectoryScannerParameters dirScannerParams = new DirectoryScannerParameters(testClassesDir, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), runOrder);
        ReporterConfiguration reporterConfig = new ReporterConfiguration(reportsDir, trimStackTrace);
        TestRequest testRequest = new TestRequest(suiteXmlFiles, testClassesDir, TestListResolver.getEmptyTestListResolver(), rerunFailingTestsCount);
        ProviderConfiguration providerConfiguration = new ProviderConfiguration(dirScannerParams, new RunOrderParameters(runOrder, null), reporterConfig, null, testRequest, OsgiSurefireBooter.extractProviderProperties(testProps), null, false, Collections.emptyList(), skipAfterFailureCount, Shutdown.DEFAULT, 30);
        StartupReportConfiguration startupReportConfig = new StartupReportConfiguration(useFile, printSummary, "plain", redirectTestOutputToFile, reportsDir, trimStackTrace, null, new File(reportsDir, "TESTHASH"), false, rerunFailingTestsCount, XSD, StandardCharsets.UTF_8.toString(), false, true, true, OsgiSurefireBooter.getSurefireStatelessReporter(provider, disableXmlReport, null), OsgiSurefireBooter.getSurefireConsoleOutputReporter(provider), OsgiSurefireBooter.getSurefireStatelessTestsetInfoReporter(provider), new ReporterFactoryOptions());
        DefaultReporterFactory reporterFactory = new DefaultReporterFactory(startupReportConfig, new PrintStreamLogger(System.out));
        ClassLoader loader = OsgiSurefireBooter.class.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            RunResult result = ProviderFactory.invokeProvider(null, loader, reporterFactory, providerConfiguration, false, startupConfiguration, true);
            String failsafe = testProps.getProperty("failsafe");
            if (failsafe != null && !failsafe.trim().isEmpty()) {
                FailsafeSummaryXmlUtils.writeSummary(result, new File(failsafe), false);
            }
            int n = result.getFailsafeCode() == null ? 0 : result.getFailsafeCode();
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected static void printBundleInfos(Properties testProps) {
        boolean printBundles = Boolean.parseBoolean(testProps.getProperty("printBundles"));
        boolean printWires = Boolean.parseBoolean(testProps.getProperty("printWires"));
        if (printBundles || printWires) {
            Bundle[] bundles;
            System.out.println("====== Installed Bundles ========");
            Bundle fwbundle = OsgiSurefireBooter.getBundle("system.bundle");
            for (Bundle bundle : bundles = fwbundle.getBundleContext().getBundles()) {
                System.out.println("[" + bundle.getBundleId() + "][" + OsgiSurefireBooter.getBundleState(bundle) + "] " + bundle.getSymbolicName() + " (" + bundle.getVersion() + ") " + OsgiSurefireBooter.getLocation(bundle));
                if (!printWires) continue;
                OsgiSurefireBooter.printImports(bundle);
            }
            System.out.println("=================================");
        }
    }

    private static String getLocation(Bundle bundle) {
        File file = (File)bundle.adapt(File.class);
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return file.getAbsolutePath();
            }
        }
        return bundle.getLocation();
    }

    private static String getBundleState(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNKOWN";
    }

    private static void printImports(Bundle source) {
        BundleWiring bundleWiring = (BundleWiring)source.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return;
        }
        List wires = bundleWiring.getRequiredWires("osgi.wiring.package");
        if (wires.isEmpty()) {
            return;
        }
        System.out.println(" Imported-Packages:");
        for (BundleWire wire : wires) {
            String pack = (String)wire.getCapability().getAttributes().get("osgi.wiring.package");
            Bundle bundle = wire.getProviderWiring().getBundle();
            System.out.println("   " + pack + " <--> " + bundle.getSymbolicName() + " (" + bundle.getVersion() + ") @ " + OsgiSurefireBooter.getLocation(bundle));
        }
    }

    private static Map<String, String> extractProviderProperties(Properties surefireProps) {
        HashMap<String, String> providerProps = new HashMap<String, String>();
        for (String entry : surefireProps.stringPropertyNames()) {
            if (!entry.startsWith("__provider.")) continue;
            providerProps.put(entry.substring("__provider.".length()), surefireProps.getProperty(entry));
        }
        return providerProps;
    }

    private static SurefireStatelessReporter getSurefireStatelessReporter(String provider, boolean disableXmlReport, String version) {
        if (provider.equals(JUNIT_PLATFORM_PROVIDER)) {
            JUnit5Xml30StatelessReporter jUnit5Xml30StatelessReporter = new JUnit5Xml30StatelessReporter();
            jUnit5Xml30StatelessReporter.setDisable(false);
            jUnit5Xml30StatelessReporter.setVersion("3.0");
            jUnit5Xml30StatelessReporter.setUsePhrasedFileName(false);
            jUnit5Xml30StatelessReporter.setUsePhrasedTestCaseClassName(true);
            jUnit5Xml30StatelessReporter.setUsePhrasedTestCaseMethodName(true);
            jUnit5Xml30StatelessReporter.setUsePhrasedTestSuiteClassName(true);
            return jUnit5Xml30StatelessReporter;
        }
        return new SurefireStatelessReporter(disableXmlReport, version);
    }

    private static SurefireConsoleOutputReporter getSurefireConsoleOutputReporter(String provider) {
        if (provider.equals(JUNIT_PLATFORM_PROVIDER)) {
            JUnit5ConsoleOutputReporter jUnit5ConsoleOutputReporter = new JUnit5ConsoleOutputReporter();
            jUnit5ConsoleOutputReporter.setDisable(false);
            jUnit5ConsoleOutputReporter.setEncoding("UTF-8");
            jUnit5ConsoleOutputReporter.setUsePhrasedFileName(false);
            return jUnit5ConsoleOutputReporter;
        }
        SurefireConsoleOutputReporter consoleOutputReporter = new SurefireConsoleOutputReporter();
        return consoleOutputReporter;
    }

    private static SurefireStatelessTestsetInfoReporter getSurefireStatelessTestsetInfoReporter(String provider) {
        if (provider.equals(JUNIT_PLATFORM_PROVIDER)) {
            JUnit5StatelessTestsetInfoReporter jUnit5StatelessTestsetInfoReporter = new JUnit5StatelessTestsetInfoReporter();
            jUnit5StatelessTestsetInfoReporter.setDisable(false);
            jUnit5StatelessTestsetInfoReporter.setUsePhrasedFileName(false);
            jUnit5StatelessTestsetInfoReporter.setUsePhrasedClassNameInRunning(true);
            jUnit5StatelessTestsetInfoReporter.setUsePhrasedClassNameInTestCaseSummary(true);
            return jUnit5StatelessTestsetInfoReporter;
        }
        return new SurefireStatelessTestsetInfoReporter();
    }

    private static File getTestProperties(String[] args) throws CoreException {
        File file;
        String arg = OsgiSurefireBooter.getArgumentValue(args, "-testproperties");
        if (arg != null && (file = new File(arg)).canRead()) {
            return file;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.tycho.surefire.osgibooter", 0, "-testproperties command line parameter is not specified or does not point to an accessible file", null));
    }

    private static String getArgumentValue(String[] args, String argumentName) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (!argumentName.equalsIgnoreCase(args[i]) || args.length < i + 1) continue;
            arg = args[i + 1];
            break;
        }
        return arg;
    }

    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            p.load(in);
        }
        return p;
    }

    private static Bundle getBundleClassLoader(String symbolicName) throws BundleException {
        Bundle bundle = OsgiSurefireBooter.getBundle(symbolicName);
        try {
            bundle.start();
        }
        catch (BundleException ex) {
            if (ex.getType() == 4) {
                System.err.println("Resolution errors for " + bundle.toString());
                Set<ResolverError> errors = Activator.getResolutionErrors(bundle);
                if (!errors.isEmpty()) {
                    for (ResolverError error : errors) {
                        System.err.println("\t" + error.toString());
                    }
                }
            } else {
                System.err.println("Could not start test bundle: " + bundle.getSymbolicName());
                ex.printStackTrace();
            }
            throw ex;
        }
        return bundle;
    }

    protected static Bundle getBundle(String symbolicName) {
        Bundle bundle = Activator.getBundle(symbolicName);
        if (bundle == null) {
            throw new RuntimeException("Bundle " + symbolicName + " is not found");
        }
        return bundle;
    }

    public static Properties loadProperties(String[] args) throws IOException, CoreException {
        return OsgiSurefireBooter.loadProperties(OsgiSurefireBooter.getTestProperties(args));
    }

    private static Bundle[] getFragments(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Bundle[0];
        }
        List hostWires = wiring.getProvidedWires("osgi.wiring.host");
        if (hostWires == null) {
            return new Bundle[0];
        }
        return (Bundle[])hostWires.stream().map(wire -> wire.getRequirer().getBundle()).filter(Objects::nonNull).sorted(Comparator.comparing(Bundle::getSymbolicName)).toArray(Bundle[]::new);
    }
}

