/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.bnd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="bnd-test")
public class BndTestBundlesInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private Logger logger;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        Plugin plugin;
        if (this.projectTypes.get(project.getPackaging()) instanceof BundleProject && (plugin = project.getPlugin("org.eclipse.tycho:tycho-surefire-plugin")) != null) {
            List testbundles = plugin.getExecutions().stream().filter(pe -> pe.getGoals().contains("bnd-test")).map(pe -> pe.getConfiguration()).filter(Xpp3Dom.class::isInstance).map(Xpp3Dom.class::cast).flatMap(dom -> {
                Xpp3Dom child = dom.getChild("bundles");
                if (child == null) {
                    return Stream.empty();
                }
                if (child.getChildCount() == 0) {
                    String value = child.getValue();
                    if (value.isBlank()) {
                        return Stream.empty();
                    }
                    return Arrays.stream(value.split(",")).map(String::trim);
                }
                return Arrays.stream(child.getChildren()).map(Xpp3Dom::getValue);
            }).toList();
            List<IRequirement> additionalBundleRequirements = testbundles.stream().map(bundleName -> MetadataFactory.createRequirement((String)"osgi.bundle", (String)bundleName, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true)).toList();
            return this.createIU(additionalBundleRequirements);
        }
        return Collections.emptyList();
    }

    private Collection<IInstallableUnit> createIU(List<IRequirement> additionalBundleRequirements) {
        if (additionalBundleRequirements.isEmpty()) {
            return Collections.emptyList();
        }
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        result.setId("bnd-test-bundles-" + String.valueOf(UUID.randomUUID()));
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)String.valueOf(System.currentTimeMillis())));
        result.addRequirements(additionalBundleRequirements);
        return List.of(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result));
    }
}

