/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.surefire.provider.impl.ProviderSelection;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;

@Component(role=ProviderHelper.class)
public class ProviderHelper {
    @Requirement
    private Map<String, TestFrameworkProvider> providers;
    @Requirement
    private BundleReader bundleReader;
    private static final Comparator<ProviderSelection> VERSION_COMPARATOR = Comparator.comparing(ProviderSelection::provider, Comparator.comparing(TestFrameworkProvider::getVersion));

    public ProviderSelection selectProvider(MavenProject project, List<ClasspathEntry> classpath, Properties providerProperties, String providerHint) throws MojoExecutionException {
        if (providerHint != null) {
            TestFrameworkProvider provider = this.providers.get(providerHint);
            if (provider == null) {
                throw new MojoExecutionException("Could not find test framework provider with role hint '" + providerHint + "'. Available providers: " + String.valueOf(this.providers.keySet()));
            }
            return new ProviderSelection(provider, providerHint);
        }
        ArrayList<ProviderSelection> candidates = new ArrayList<ProviderSelection>();
        for (Map.Entry<String, TestFrameworkProvider> provider : this.providers.entrySet()) {
            if (!provider.getValue().isEnabled(project, classpath, providerProperties)) continue;
            candidates.add(new ProviderSelection(provider.getValue(), provider.getKey()));
        }
        this.validateCandidates(candidates);
        if (candidates.size() == 1) {
            return (ProviderSelection)candidates.get(0);
        }
        return Collections.max(candidates, VERSION_COMPARATOR);
    }

    public Set<Artifact> filterTestFrameworkBundles(TestFrameworkProvider provider, List<Artifact> pluginArtifacts) throws MojoExecutionException {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        ArrayList<Dependency> requiredArtifacts = new ArrayList<Dependency>();
        requiredArtifacts.add(ProviderHelper.newDependency("org.eclipse.tycho", "org.eclipse.tycho.surefire.osgibooter"));
        requiredArtifacts.addAll(provider.getRequiredArtifacts());
        for (Dependency dependency : requiredArtifacts) {
            boolean found = false;
            for (Artifact artifact : pluginArtifacts) {
                if (!dependency.getGroupId().equals(artifact.getGroupId()) || !dependency.getArtifactId().equals(artifact.getArtifactId()) || dependency.getVersion() != null && !dependency.getVersion().isEmpty() && !dependency.getVersion().equals(artifact.getVersion())) continue;
                found = true;
                result.add(artifact);
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Unable to locate test framework dependency " + String.valueOf(dependency) + "\n");
            sb.append("Test framework: " + provider.getSurefireProviderClassName() + "\n");
            sb.append("All plugin artifacts: ");
            for (Artifact artifact : pluginArtifacts) {
                sb.append("\n\t").append(artifact.toString());
            }
            throw new MojoExecutionException(sb.toString());
        }
        return result;
    }

    static Dependency newDependency(String groupId, String artifactId) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        return dependency;
    }

    static Dependency newDependency(String artifactId) {
        return ProviderHelper.newDependency("org.eclipse.tycho", artifactId);
    }

    private void validateCandidates(List<ProviderSelection> candidates) throws MojoExecutionException {
        if (candidates.isEmpty()) {
            throw new MojoExecutionException("Could not determine test framework provider. Available providers: " + String.valueOf(this.providers.keySet()));
        }
        if (candidates.size() == 1) {
            return;
        }
        String firstType = candidates.get(0).provider().getType();
        for (int i = 1; i < candidates.size(); ++i) {
            if (firstType.equals(candidates.get(i).provider().getType())) continue;
            throw new MojoExecutionException("Could not determine test framework provider. Providers with different types (" + firstType + "," + candidates.get(i).provider().getType() + ") are enabled. Try specifying a providerHint; available provider hints: " + String.valueOf(this.providers.keySet()));
        }
    }

    public List<String> getSymbolicNames(Set<Artifact> bundleArtifacts) {
        ArrayList<String> result = new ArrayList<String>();
        for (Artifact artifact : bundleArtifacts) {
            result.add(this.bundleReader.loadManifest(artifact.getFile()).getBundleSymbolicName());
        }
        return result;
    }
}

