/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricMilestoneInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.deployer.ResourceNameUtil;
import org.flowable.cmmn.rest.service.api.CmmnRestUrls;
import org.flowable.cmmn.rest.service.api.FormModelResponse;
import org.flowable.cmmn.rest.service.api.engine.RestIdentityLink;
import org.flowable.cmmn.rest.service.api.engine.variable.QueryVariable;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceResponse;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceResponse;
import org.flowable.cmmn.rest.service.api.history.planitem.HistoricPlanItemInstanceResponse;
import org.flowable.cmmn.rest.service.api.history.task.HistoricIdentityLinkResponse;
import org.flowable.cmmn.rest.service.api.history.task.HistoricTaskInstanceResponse;
import org.flowable.cmmn.rest.service.api.history.variable.HistoricVariableInstanceResponse;
import org.flowable.cmmn.rest.service.api.management.HistoryJobResponse;
import org.flowable.cmmn.rest.service.api.management.JobResponse;
import org.flowable.cmmn.rest.service.api.repository.CaseDefinitionResponse;
import org.flowable.cmmn.rest.service.api.repository.CmmnDeploymentResponse;
import org.flowable.cmmn.rest.service.api.repository.DecisionResponse;
import org.flowable.cmmn.rest.service.api.repository.DeploymentResourceResponse;
import org.flowable.cmmn.rest.service.api.repository.FormDefinitionResponse;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.cmmn.rest.service.api.runtime.caze.EventSubscriptionResponse;
import org.flowable.cmmn.rest.service.api.runtime.planitem.PlanItemInstanceResponse;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskResponse;
import org.flowable.cmmn.rest.service.api.runtime.variable.VariableInstanceResponse;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.common.rest.util.RestUrlBuilder;
import org.flowable.common.rest.variable.BooleanRestVariableConverter;
import org.flowable.common.rest.variable.DateRestVariableConverter;
import org.flowable.common.rest.variable.DoubleRestVariableConverter;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.InstantRestVariableConverter;
import org.flowable.common.rest.variable.IntegerRestVariableConverter;
import org.flowable.common.rest.variable.JsonObjectRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateTimeRestVariableConverter;
import org.flowable.common.rest.variable.LongRestVariableConverter;
import org.flowable.common.rest.variable.RestVariableConverter;
import org.flowable.common.rest.variable.ShortRestVariableConverter;
import org.flowable.common.rest.variable.StringRestVariableConverter;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.form.api.FormDefinition;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class CmmnRestResponseFactory {
    public static final int VARIABLE_TASK = 1;
    public static final int VARIABLE_EXECUTION = 2;
    public static final int VARIABLE_CASE = 3;
    public static final int VARIABLE_VARINSTANCE = 4;
    public static final int VARIABLE_HISTORY_TASK = 5;
    public static final int VARIABLE_HISTORY_CASE = 6;
    public static final int VARIABLE_HISTORY_VARINSTANCE = 7;
    public static final int VARIABLE_PLAN_ITEM = 8;
    public static final String BYTE_ARRAY_VARIABLE_TYPE = "binary";
    public static final String SERIALIZABLE_VARIABLE_TYPE = "serializable";
    protected ObjectMapper objectMapper;
    protected List<RestVariableConverter> variableConverters = new ArrayList<RestVariableConverter>();

    public CmmnRestResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.initializeVariableConverters();
    }

    public List<TaskResponse> createTaskResponseList(List<Task> tasks) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<TaskResponse> responseList = new ArrayList<TaskResponse>(tasks.size());
        for (Task instance : tasks) {
            responseList.add(this.createTaskResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public TaskResponse createTaskResponse(Task task) {
        return this.createTaskResponse(task, this.createUrlBuilder());
    }

    public TaskResponse createTaskResponse(Task task, RestUrlBuilder urlBuilder) {
        Map variableMap;
        TaskResponse response = new TaskResponse(task);
        response.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_TASK, new Object[]{task.getId()}));
        if (response.getParentTaskId() != null) {
            response.setParentTaskUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_TASK, new Object[]{response.getParentTaskId()}));
        }
        if (response.getCaseDefinitionId() != null) {
            response.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{response.getCaseDefinitionId()}));
        }
        if (response.getCaseInstanceId() != null) {
            response.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{response.getCaseInstanceId()}));
        }
        if (task.getProcessVariables() != null) {
            variableMap = task.getProcessVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, task.getId(), 1, false, urlBuilder));
            }
        }
        if (task.getTaskLocalVariables() != null) {
            variableMap = task.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, task.getId(), 1, false, urlBuilder));
            }
        }
        return response;
    }

    public List<CmmnDeploymentResponse> createDeploymentResponseList(List<CmmnDeployment> deployments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<CmmnDeploymentResponse> responseList = new ArrayList<CmmnDeploymentResponse>(deployments.size());
        for (CmmnDeployment instance : deployments) {
            responseList.add(this.createDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public CmmnDeploymentResponse createDeploymentResponse(CmmnDeployment deployment) {
        return this.createDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public CmmnDeploymentResponse createDeploymentResponse(CmmnDeployment deployment, RestUrlBuilder urlBuilder) {
        return new CmmnDeploymentResponse(deployment, urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT, new Object[]{deployment.getId()}));
    }

    public List<DeploymentResourceResponse> createDeploymentResourceResponseList(String deploymentId, List<String> resourceList, ContentTypeResolver contentTypeResolver) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DeploymentResourceResponse> responseList = new ArrayList<DeploymentResourceResponse>(resourceList.size());
        for (String resourceId : resourceList) {
            String contentType = null;
            contentType = resourceId.toLowerCase().endsWith(".cmmn") ? ContentType.TEXT_XML.getMimeType() : contentTypeResolver.resolveContentType(resourceId);
            responseList.add(this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, urlBuilder));
        }
        return responseList;
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType) {
        return this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, this.createUrlBuilder());
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType, RestUrlBuilder urlBuilder) {
        String resourceUrl = urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{deploymentId, resourceId});
        String resourceContentUrl = urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT_RESOURCE_CONTENT, new Object[]{deploymentId, resourceId});
        String type = "resource";
        for (String suffix : ResourceNameUtil.CMMN_RESOURCE_SUFFIXES) {
            if (!resourceId.endsWith(suffix)) continue;
            type = "caseDefinition";
            break;
        }
        return new DeploymentResourceResponse(resourceId, resourceUrl, resourceContentUrl, contentType, type);
    }

    public List<CaseDefinitionResponse> createCaseDefinitionResponseList(List<CaseDefinition> caseDefinitions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<CaseDefinitionResponse> responseList = new ArrayList<CaseDefinitionResponse>(caseDefinitions.size());
        for (CaseDefinition instance : caseDefinitions) {
            responseList.add(this.createCaseDefinitionResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public CaseDefinitionResponse createCaseDefinitionResponse(CaseDefinition caseDefinition) {
        return this.createCaseDefinitionResponse(caseDefinition, this.createUrlBuilder());
    }

    public CaseDefinitionResponse createCaseDefinitionResponse(CaseDefinition caseDefinition, RestUrlBuilder urlBuilder) {
        CaseDefinitionResponse response = new CaseDefinitionResponse();
        response.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{caseDefinition.getId()}));
        response.setId(caseDefinition.getId());
        response.setKey(caseDefinition.getKey());
        response.setVersion(caseDefinition.getVersion());
        response.setCategory(caseDefinition.getCategory());
        response.setName(caseDefinition.getName());
        response.setDescription(caseDefinition.getDescription());
        response.setGraphicalNotationDefined(caseDefinition.hasGraphicalNotation());
        response.setStartFormDefined(caseDefinition.hasStartFormKey());
        response.setTenantId(caseDefinition.getTenantId());
        response.setDeploymentId(caseDefinition.getDeploymentId());
        response.setDeploymentUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT, new Object[]{caseDefinition.getDeploymentId()}));
        response.setResource(urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{caseDefinition.getDeploymentId(), caseDefinition.getResourceName()}));
        if (caseDefinition.getDiagramResourceName() != null) {
            response.setDiagramResource(urlBuilder.buildUrl(CmmnRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{caseDefinition.getDeploymentId(), caseDefinition.getDiagramResourceName()}));
        }
        return response;
    }

    public String getFormModelString(FormModelResponse formModelResponse) {
        try {
            return this.objectMapper.writeValueAsString((Object)formModelResponse);
        }
        catch (Exception e) {
            throw new FlowableException("Error writing form model response", (Throwable)e);
        }
    }

    public List<RestVariable> createRestVariables(Map<String, Object> variables, String id, int variableType) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variables.size());
        for (Map.Entry<String, Object> pair : variables.entrySet()) {
            result.add(this.createRestVariable(pair.getKey(), pair.getValue(), null, id, variableType, false, urlBuilder));
        }
        return result;
    }

    public List<RestVariable> createRestVariables(Map<String, Object> variables, String id, int variableType, RestVariable.RestVariableScope scope) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variables.size());
        for (Map.Entry<String, Object> pair : variables.entrySet()) {
            result.add(this.createRestVariable(pair.getKey(), pair.getValue(), scope, id, variableType, false, urlBuilder));
        }
        return result;
    }

    public RestVariable createRestVariable(String name, Object value, RestVariable.RestVariableScope scope, String id, int variableType, boolean includeBinaryValue) {
        return this.createRestVariable(name, value, scope, id, variableType, includeBinaryValue, this.createUrlBuilder());
    }

    public RestVariable createRestVariable(String name, Object value, RestVariable.RestVariableScope scope, String id, int variableType, boolean includeBinaryValue, RestUrlBuilder urlBuilder) {
        RestVariableConverter converter = null;
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        if (value != null) {
            for (RestVariableConverter c : this.variableConverters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, (EngineRestVariable)restVar);
                restVar.setType(converter.getRestTypeName());
            } else {
                if (value instanceof Byte[] || value instanceof byte[]) {
                    restVar.setType(BYTE_ARRAY_VARIABLE_TYPE);
                } else {
                    restVar.setType(SERIALIZABLE_VARIABLE_TYPE);
                }
                if (includeBinaryValue) {
                    restVar.setValue(value);
                }
                if (variableType == 1) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_TASK_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 3) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 4) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_VARIABLE_INSTANCE_DATA, new Object[]{id, name}));
                } else if (variableType == 5) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_TASK_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 7) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_VARIABLE_INSTANCE_DATA, new Object[]{id, name}));
                } else if (variableType == 6) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 8) {
                    restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_PLAN_ITEM_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                }
            }
        }
        return restVar;
    }

    public RestVariable createBinaryRestVariable(String name, RestVariable.RestVariableScope scope, String type, String instanceId, int responseVariableType) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        restVar.setType(type);
        if (responseVariableType == 1) {
            restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_TASK_VARIABLE_DATA, new Object[]{instanceId, name}));
        } else if (responseVariableType == 3) {
            restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE_VARIABLE_DATA, new Object[]{instanceId, name}));
        } else if (responseVariableType == 8) {
            restVar.setValueUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_PLAN_ITEM_INSTANCE_VARIABLE_DATA, new Object[]{instanceId, name}));
        }
        return restVar;
    }

    public Object getVariableValue(RestVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            value = converter.getVariableValue((EngineRestVariable)restVariable);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public Object getVariableValue(QueryVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            RestVariable temp = new RestVariable();
            temp.setValue(restVariable.getValue());
            temp.setType(restVariable.getType());
            temp.setName(restVariable.getName());
            value = converter.getVariableValue((EngineRestVariable)temp);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public List<RestIdentityLink> createRestIdentityLinks(List<IdentityLink> links) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<RestIdentityLink> responseList = new ArrayList<RestIdentityLink>(links.size());
        for (IdentityLink instance : links) {
            responseList.add(this.createRestIdentityLink(instance, urlBuilder));
        }
        return responseList;
    }

    public RestIdentityLink createRestIdentityLink(IdentityLink link) {
        return this.createRestIdentityLink(link, this.createUrlBuilder());
    }

    public RestIdentityLink createRestIdentityLink(IdentityLink link, RestUrlBuilder urlBuilder) {
        return this.createRestIdentityLink(link.getType(), link.getUserId(), link.getGroupId(), link.getTaskId(), link.getScopeDefinitionId(), link.getScopeId(), urlBuilder);
    }

    public RestIdentityLink createRestIdentityLink(String type, String userId, String groupId, String taskId, String caseDefinitionId, String caseInstanceId) {
        return this.createRestIdentityLink(type, userId, groupId, taskId, caseDefinitionId, caseInstanceId, this.createUrlBuilder());
    }

    public RestIdentityLink createRestIdentityLink(String type, String userId, String groupId, String taskId, String caseDefinitionId, String caseInstanceId, RestUrlBuilder urlBuilder) {
        RestIdentityLink result = new RestIdentityLink();
        result.setUser(userId);
        result.setGroup(groupId);
        result.setType(type);
        String family = null;
        family = userId != null ? "users" : "groups";
        if (caseInstanceId != null) {
            result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE_IDENTITYLINK, new Object[]{caseInstanceId, userId != null ? userId : groupId, type}));
        } else if (taskId != null) {
            result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_TASK_IDENTITYLINK, new Object[]{taskId, family, userId != null ? userId : groupId, type}));
        } else if (caseDefinitionId != null) {
            result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION_IDENTITYLINK, new Object[]{caseDefinitionId, family, userId != null ? userId : groupId}));
        }
        return result;
    }

    public List<CaseInstanceResponse> createCaseInstanceResponseList(List<CaseInstance> caseInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<CaseInstanceResponse> responseList = new ArrayList<CaseInstanceResponse>(caseInstances.size());
        for (CaseInstance instance : caseInstances) {
            responseList.add(this.createCaseInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public CaseInstanceResponse createCaseInstanceResponse(CaseInstance caseInstance) {
        return this.createCaseInstanceResponse(caseInstance, this.createUrlBuilder());
    }

    public CaseInstanceResponse createCaseInstanceResponse(CaseInstance caseInstance, RestUrlBuilder urlBuilder) {
        CaseInstanceResponse result = new CaseInstanceResponse();
        result.setBusinessKey(caseInstance.getBusinessKey());
        result.setBusinessStatus(caseInstance.getBusinessStatus());
        result.setId(caseInstance.getId());
        result.setName(caseInstance.getName());
        result.setStartTime(caseInstance.getStartTime());
        result.setStartUserId(caseInstance.getStartUserId());
        result.setState(caseInstance.getState());
        result.setCaseDefinitionId(caseInstance.getCaseDefinitionId());
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{caseInstance.getCaseDefinitionId()}));
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{caseInstance.getId()}));
        result.setParentId(caseInstance.getParentId());
        result.setCallbackId(caseInstance.getCallbackId());
        result.setCallbackType(caseInstance.getCallbackType());
        result.setReferenceId(caseInstance.getReferenceId());
        result.setReferenceType(caseInstance.getReferenceType());
        result.setTenantId(caseInstance.getTenantId());
        for (String name : caseInstance.getCaseVariables().keySet()) {
            result.addVariable(this.createRestVariable(name, caseInstance.getCaseVariables().get(name), RestVariable.RestVariableScope.LOCAL, caseInstance.getId(), 3, false, urlBuilder));
        }
        return result;
    }

    public CaseInstanceResponse createCaseInstanceResponse(CaseInstance caseInstance, boolean returnVariables, Map<String, Object> runtimeVariableMap) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        CaseInstanceResponse result = new CaseInstanceResponse();
        result.setBusinessKey(caseInstance.getBusinessKey());
        result.setId(caseInstance.getId());
        result.setName(caseInstance.getName());
        result.setStartTime(caseInstance.getStartTime());
        result.setStartUserId(caseInstance.getStartUserId());
        result.setState(caseInstance.getState());
        result.setCaseDefinitionId(caseInstance.getCaseDefinitionId());
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{caseInstance.getCaseDefinitionId()}));
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{caseInstance.getId()}));
        result.setParentId(caseInstance.getParentId());
        result.setCallbackId(caseInstance.getCallbackId());
        result.setCallbackType(caseInstance.getCallbackType());
        result.setReferenceId(caseInstance.getReferenceId());
        result.setReferenceType(caseInstance.getReferenceType());
        result.setTenantId(caseInstance.getTenantId());
        result.setCompleted(false);
        if (returnVariables && runtimeVariableMap != null) {
            for (String name : runtimeVariableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, runtimeVariableMap.get(name), RestVariable.RestVariableScope.LOCAL, caseInstance.getId(), 3, false, urlBuilder));
            }
        }
        return result;
    }

    public List<PlanItemInstanceResponse> createPlanItemInstanceResponseList(List<PlanItemInstance> planItemInstances) {
        ArrayList<PlanItemInstanceResponse> responseList = new ArrayList<PlanItemInstanceResponse>(planItemInstances.size());
        for (PlanItemInstance planItemInstance : planItemInstances) {
            responseList.add(this.createPlanItemInstanceResponse(planItemInstance));
        }
        return responseList;
    }

    public PlanItemInstanceResponse createPlanItemInstanceResponse(PlanItemInstance planItemInstance) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        PlanItemInstanceResponse result = new PlanItemInstanceResponse();
        result.setId(planItemInstance.getId());
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_PLAN_ITEM_INSTANCE, new Object[]{planItemInstance.getId()}));
        result.setName(planItemInstance.getName());
        result.setCaseDefinitionId(planItemInstance.getCaseDefinitionId());
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{planItemInstance.getCaseDefinitionId()}));
        if (planItemInstance.getDerivedCaseDefinitionId() != null) {
            result.setDerivedCaseDefinitionId(planItemInstance.getDerivedCaseDefinitionId());
            result.setDerivedCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{planItemInstance.getDerivedCaseDefinitionId()}));
        }
        result.setCaseInstanceId(planItemInstance.getCaseInstanceId());
        result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{planItemInstance.getCaseInstanceId()}));
        if (planItemInstance.getStageInstanceId() != null) {
            result.setStageInstanceId(planItemInstance.getStageInstanceId());
            result.setStageInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_PLAN_ITEM_INSTANCE, new Object[]{planItemInstance.getStageInstanceId()}));
        }
        result.setPlanItemDefinitionId(planItemInstance.getPlanItemDefinitionId());
        result.setPlanItemDefinitionType(planItemInstance.getPlanItemDefinitionType());
        result.setState(planItemInstance.getState());
        result.setElementId(planItemInstance.getElementId());
        result.setReferenceId(planItemInstance.getReferenceId());
        result.setReferenceType(planItemInstance.getReferenceType());
        result.setCreateTime(planItemInstance.getCreateTime());
        result.setLastAvailableTime(planItemInstance.getLastAvailableTime());
        result.setLastEnabledTime(planItemInstance.getLastEnabledTime());
        result.setLastDisabledTime(planItemInstance.getLastDisabledTime());
        result.setLastStartedTime(planItemInstance.getLastStartedTime());
        result.setLastSuspendedTime(planItemInstance.getLastSuspendedTime());
        result.setCompletedTime(planItemInstance.getCompletedTime());
        result.setOccurredTime(planItemInstance.getOccurredTime());
        result.setTerminatedTime(planItemInstance.getTerminatedTime());
        result.setExitTime(planItemInstance.getExitTime());
        result.setEndedTime(planItemInstance.getEndedTime());
        result.setStartUserId(planItemInstance.getStartUserId());
        result.setStage(planItemInstance.isStage());
        result.setCompletable(planItemInstance.isCompletable());
        result.setEntryCriterionId(planItemInstance.getEntryCriterionId());
        result.setExitCriterionId(planItemInstance.getExitCriterionId());
        result.setFormKey(planItemInstance.getFormKey());
        result.setExtraValue(planItemInstance.getExtraValue());
        result.setTenantId(planItemInstance.getTenantId());
        return result;
    }

    public List<VariableInstanceResponse> createVariableInstanceResponseList(List<VariableInstance> variableInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<VariableInstanceResponse> responseList = new ArrayList<VariableInstanceResponse>(variableInstances.size());
        for (VariableInstance instance : variableInstances) {
            responseList.add(this.createVariableInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public VariableInstanceResponse createVariableInstanceResponse(VariableInstance variableInstance) {
        return this.createVariableInstanceResponse(variableInstance, this.createUrlBuilder());
    }

    public VariableInstanceResponse createVariableInstanceResponse(VariableInstance variableInstance, RestUrlBuilder urlBuilder) {
        VariableInstanceResponse result = new VariableInstanceResponse();
        result.setId(variableInstance.getId());
        if (variableInstance.getScopeId() != null && "cmmn".equals(variableInstance.getScopeType())) {
            result.setCaseInstanceId(variableInstance.getScopeId());
            result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{variableInstance.getScopeId()}));
        }
        result.setTaskId(variableInstance.getTaskId());
        result.setPlanItemInstanceId(variableInstance.getSubScopeId());
        RestVariable.RestVariableScope scope = variableInstance.getSubScopeId() != null && !variableInstance.getSubScopeId().equals(variableInstance.getScopeId()) || variableInstance.getTaskId() != null ? RestVariable.RestVariableScope.LOCAL : RestVariable.RestVariableScope.GLOBAL;
        result.setVariable(this.createRestVariable(variableInstance.getName(), variableInstance.getValue(), scope, variableInstance.getId(), 4, false, urlBuilder));
        return result;
    }

    public List<EventSubscriptionResponse> createEventSubscriptionResponseList(List<EventSubscription> eventSubscriptions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<EventSubscriptionResponse> responseList = new ArrayList<EventSubscriptionResponse>(eventSubscriptions.size());
        for (EventSubscription instance : eventSubscriptions) {
            responseList.add(this.createEventSubscriptionResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public EventSubscriptionResponse createEventSubscriptionResponse(EventSubscription eventSubscription) {
        return this.createEventSubscriptionResponse(eventSubscription, this.createUrlBuilder());
    }

    public EventSubscriptionResponse createEventSubscriptionResponse(EventSubscription eventSubscription, RestUrlBuilder urlBuilder) {
        EventSubscriptionResponse response = new EventSubscriptionResponse();
        response.setId(eventSubscription.getId());
        response.setCreated(eventSubscription.getCreated());
        response.setEventType(eventSubscription.getEventType());
        response.setEventName(eventSubscription.getEventName());
        response.setActivityId(eventSubscription.getActivityId());
        response.setPlanItemInstanceId(eventSubscription.getSubScopeId());
        response.setCaseDefinitionId(eventSubscription.getScopeDefinitionId());
        response.setCaseInstanceId(eventSubscription.getScopeId());
        response.setExecutionId(eventSubscription.getExecutionId());
        response.setProcessInstanceId(eventSubscription.getProcessInstanceId());
        response.setProcessDefinitionId(eventSubscription.getProcessDefinitionId());
        response.setSubScopeId(eventSubscription.getSubScopeId());
        response.setScopeId(eventSubscription.getScopeId());
        response.setScopeType(eventSubscription.getScopeType());
        response.setScopeDefinitionId(eventSubscription.getScopeDefinitionId());
        response.setConfiguration(eventSubscription.getConfiguration());
        response.setTenantId(eventSubscription.getTenantId());
        response.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_EVENT_SUBSCRIPTION, new Object[]{eventSubscription.getId()}));
        if (eventSubscription.getScopeDefinitionId() != null) {
            response.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{eventSubscription.getScopeDefinitionId()}));
        }
        if (eventSubscription.getScopeId() != null) {
            response.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{eventSubscription.getScopeId()}));
        }
        if (eventSubscription.getSubScopeId() != null) {
            response.setPlanItemInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_PLAN_ITEM_INSTANCE, new Object[]{eventSubscription.getSubScopeId()}));
        }
        return response;
    }

    public List<HistoricCaseInstanceResponse> createHistoricCaseInstanceResponseList(List<HistoricCaseInstance> caseInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricCaseInstanceResponse> responseList = new ArrayList<HistoricCaseInstanceResponse>(caseInstances.size());
        for (HistoricCaseInstance instance : caseInstances) {
            responseList.add(this.createHistoricCaseInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricCaseInstanceResponse createHistoricCaseInstanceResponse(HistoricCaseInstance caseInstance) {
        return this.createHistoricCaseInstanceResponse(caseInstance, this.createUrlBuilder());
    }

    public HistoricCaseInstanceResponse createHistoricCaseInstanceResponse(HistoricCaseInstance caseInstance, RestUrlBuilder urlBuilder) {
        HistoricCaseInstanceResponse result = new HistoricCaseInstanceResponse();
        result.setBusinessKey(caseInstance.getBusinessKey());
        result.setBusinessStatus(caseInstance.getBusinessStatus());
        result.setName(caseInstance.getName());
        result.setEndTime(caseInstance.getEndTime());
        result.setId(caseInstance.getId());
        result.setCaseDefinitionId(caseInstance.getCaseDefinitionId());
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{caseInstance.getCaseDefinitionId()}));
        result.setStartTime(caseInstance.getStartTime());
        result.setStartUserId(caseInstance.getStartUserId());
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{caseInstance.getId()}));
        if (caseInstance.getCaseVariables() != null) {
            Map variableMap = caseInstance.getCaseVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, caseInstance.getId(), 6, false, urlBuilder));
            }
        }
        result.setTenantId(caseInstance.getTenantId());
        result.setState(caseInstance.getState());
        result.setReferenceId(caseInstance.getReferenceId());
        result.setReferenceType(caseInstance.getReferenceType());
        result.setCallbackId(caseInstance.getCallbackId());
        result.setCallbackType(caseInstance.getCallbackType());
        return result;
    }

    public List<HistoricTaskInstanceResponse> createHistoricTaskInstanceResponseList(List<HistoricTaskInstance> taskInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricTaskInstanceResponse> responseList = new ArrayList<HistoricTaskInstanceResponse>(taskInstances.size());
        for (HistoricTaskInstance instance : taskInstances) {
            responseList.add(this.createHistoricTaskInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(HistoricTaskInstance taskInstance) {
        return this.createHistoricTaskInstanceResponse(taskInstance, this.createUrlBuilder());
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(HistoricTaskInstance taskInstance, RestUrlBuilder urlBuilder) {
        Map variableMap;
        HistoricTaskInstanceResponse result = new HistoricTaskInstanceResponse();
        result.setAssignee(taskInstance.getAssignee());
        result.setClaimTime(taskInstance.getClaimTime());
        result.setDeleteReason(taskInstance.getDeleteReason());
        result.setDescription(taskInstance.getDescription());
        result.setDueDate(taskInstance.getDueDate());
        result.setDurationInMillis(taskInstance.getDurationInMillis());
        result.setEndTime(taskInstance.getEndTime());
        result.setFormKey(taskInstance.getFormKey());
        result.setId(taskInstance.getId());
        result.setName(taskInstance.getName());
        result.setOwner(taskInstance.getOwner());
        result.setParentTaskId(taskInstance.getParentTaskId());
        result.setPriority(taskInstance.getPriority());
        result.setScopeDefinitionId(taskInstance.getScopeDefinitionId());
        result.setScopeId(taskInstance.getScopeId());
        result.setSubScopeId(taskInstance.getSubScopeId());
        result.setScopeType(taskInstance.getScopeType());
        result.setPropagatedStageInstanceId(taskInstance.getPropagatedStageInstanceId());
        result.setExecutionId(taskInstance.getExecutionId());
        result.setProcessInstanceId(taskInstance.getProcessInstanceId());
        result.setProcessDefinitionId(taskInstance.getProcessDefinitionId());
        result.setTenantId(taskInstance.getTenantId());
        result.setCategory(taskInstance.getCategory());
        if (taskInstance.getScopeDefinitionId() != null && "cmmn".equals(taskInstance.getScopeType())) {
            result.setCaseDefinitionId(taskInstance.getScopeDefinitionId());
            result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{taskInstance.getScopeDefinitionId()}));
        }
        if (taskInstance.getScopeId() != null && "cmmn".equals(taskInstance.getScopeType())) {
            result.setCaseInstanceId(taskInstance.getScopeId());
            result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{taskInstance.getScopeId()}));
        }
        result.setStartTime(taskInstance.getStartTime());
        result.setTaskDefinitionKey(taskInstance.getTaskDefinitionKey());
        result.setWorkTimeInMillis(taskInstance.getWorkTimeInMillis());
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{taskInstance.getId()}));
        if (taskInstance.getProcessVariables() != null) {
            variableMap = taskInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, taskInstance.getId(), 5, false, urlBuilder));
            }
        }
        if (taskInstance.getTaskLocalVariables() != null) {
            variableMap = taskInstance.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, taskInstance.getId(), 5, false, urlBuilder));
            }
        }
        return result;
    }

    public List<HistoricVariableInstanceResponse> createHistoricVariableInstanceResponseList(List<HistoricVariableInstance> variableInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricVariableInstanceResponse> responseList = new ArrayList<HistoricVariableInstanceResponse>(variableInstances.size());
        for (HistoricVariableInstance instance : variableInstances) {
            responseList.add(this.createHistoricVariableInstanceResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricVariableInstanceResponse createHistoricVariableInstanceResponse(HistoricVariableInstance variableInstance) {
        return this.createHistoricVariableInstanceResponse(variableInstance, this.createUrlBuilder());
    }

    public HistoricVariableInstanceResponse createHistoricVariableInstanceResponse(HistoricVariableInstance variableInstance, RestUrlBuilder urlBuilder) {
        HistoricVariableInstanceResponse result = new HistoricVariableInstanceResponse();
        result.setId(variableInstance.getId());
        if (variableInstance.getScopeId() != null && "cmmn".equals(variableInstance.getScopeType())) {
            result.setCaseInstanceId(variableInstance.getScopeId());
            result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{variableInstance.getScopeId()}));
        }
        result.setTaskId(variableInstance.getTaskId());
        result.setPlanItemInstanceId(variableInstance.getSubScopeId());
        RestVariable.RestVariableScope scope = variableInstance.getSubScopeId() != null && !variableInstance.getSubScopeId().equals(variableInstance.getScopeId()) || variableInstance.getTaskId() != null ? RestVariable.RestVariableScope.LOCAL : RestVariable.RestVariableScope.GLOBAL;
        result.setVariable(this.createRestVariable(variableInstance.getVariableName(), variableInstance.getValue(), scope, variableInstance.getId(), 7, false, urlBuilder));
        return result;
    }

    public List<HistoricIdentityLinkResponse> createHistoricIdentityLinkResponseList(List<HistoricIdentityLink> identityLinks) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricIdentityLinkResponse> responseList = new ArrayList<HistoricIdentityLinkResponse>(identityLinks.size());
        for (HistoricIdentityLink instance : identityLinks) {
            responseList.add(this.createHistoricIdentityLinkResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public HistoricIdentityLinkResponse createHistoricIdentityLinkResponse(HistoricIdentityLink identityLink) {
        return this.createHistoricIdentityLinkResponse(identityLink, this.createUrlBuilder());
    }

    public HistoricIdentityLinkResponse createHistoricIdentityLinkResponse(HistoricIdentityLink identityLink, RestUrlBuilder urlBuilder) {
        HistoricIdentityLinkResponse result = new HistoricIdentityLinkResponse();
        result.setType(identityLink.getType());
        result.setUserId(identityLink.getUserId());
        result.setGroupId(identityLink.getGroupId());
        result.setTaskId(identityLink.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getTaskId())) {
            result.setTaskUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{identityLink.getTaskId()}));
        }
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getScopeId()) && "cmmn".equals(identityLink.getScopeType())) {
            result.setCaseInstanceId(identityLink.getScopeId());
            result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{identityLink.getScopeId()}));
        }
        return result;
    }

    public List<HistoricMilestoneInstanceResponse> createHistoricMilestoneInstanceResponseList(List<HistoricMilestoneInstance> historicMilestoneInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        return historicMilestoneInstances.stream().map(m -> this.createHistoricMilestoneInstanceResponse((HistoricMilestoneInstance)m, urlBuilder)).collect(Collectors.toList());
    }

    public HistoricMilestoneInstanceResponse createHistoricMilestoneInstanceResponse(HistoricMilestoneInstance historicMilestoneInstance) {
        return this.createHistoricMilestoneInstanceResponse(historicMilestoneInstance, this.createUrlBuilder());
    }

    public HistoricMilestoneInstanceResponse createHistoricMilestoneInstanceResponse(HistoricMilestoneInstance historicMilestoneInstance, RestUrlBuilder urlBuilder) {
        HistoricMilestoneInstanceResponse result = new HistoricMilestoneInstanceResponse();
        result.setId(historicMilestoneInstance.getId());
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_MILESTONE_INSTANCE, new Object[]{historicMilestoneInstance.getId()}));
        result.setName(historicMilestoneInstance.getName());
        result.setElementId(historicMilestoneInstance.getElementId());
        result.setTimestamp(historicMilestoneInstance.getTimeStamp());
        result.setCaseInstanceId(historicMilestoneInstance.getCaseInstanceId());
        result.setHistoricCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{historicMilestoneInstance.getCaseInstanceId()}));
        result.setCaseDefinitionId(historicMilestoneInstance.getCaseDefinitionId());
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{historicMilestoneInstance.getCaseDefinitionId()}));
        return result;
    }

    public List<HistoricPlanItemInstanceResponse> createHistoricPlanItemInstanceResponseList(List<HistoricPlanItemInstance> historicPlanItemInstances) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        return historicPlanItemInstances.stream().map(m -> this.createHistoricPlanItemInstanceResponse((HistoricPlanItemInstance)m, urlBuilder)).collect(Collectors.toList());
    }

    public HistoricPlanItemInstanceResponse createHistoricPlanItemInstanceResponse(HistoricPlanItemInstance historicPlanItemInstance) {
        return this.createHistoricPlanItemInstanceResponse(historicPlanItemInstance, this.createUrlBuilder());
    }

    public HistoricPlanItemInstanceResponse createHistoricPlanItemInstanceResponse(HistoricPlanItemInstance historicPlanItemInstance, RestUrlBuilder urlBuilder) {
        HistoricPlanItemInstanceResponse result = new HistoricPlanItemInstanceResponse();
        result.setId(historicPlanItemInstance.getId());
        result.setName(historicPlanItemInstance.getName());
        result.setState(historicPlanItemInstance.getState());
        result.setCaseDefinitionId(historicPlanItemInstance.getCaseDefinitionId());
        result.setDerivedCaseDefinitionId(historicPlanItemInstance.getDerivedCaseDefinitionId());
        result.setCaseInstanceId(historicPlanItemInstance.getCaseInstanceId());
        result.setStageInstanceId(historicPlanItemInstance.getStageInstanceId());
        result.setStage(historicPlanItemInstance.isStage());
        result.setElementId(historicPlanItemInstance.getElementId());
        result.setPlanItemDefinitionId(historicPlanItemInstance.getPlanItemDefinitionId());
        result.setPlanItemDefinitionType(historicPlanItemInstance.getPlanItemDefinitionType());
        result.setCreateTime(historicPlanItemInstance.getCreateTime());
        result.setLastAvailableTime(historicPlanItemInstance.getLastAvailableTime());
        result.setLastEnabledTime(historicPlanItemInstance.getLastEnabledTime());
        result.setLastDisabledTime(historicPlanItemInstance.getLastDisabledTime());
        result.setLastStartedTime(historicPlanItemInstance.getLastStartedTime());
        result.setLastSuspendedTime(historicPlanItemInstance.getLastSuspendedTime());
        result.setCompletedTime(historicPlanItemInstance.getCompletedTime());
        result.setOccurredTime(historicPlanItemInstance.getOccurredTime());
        result.setTerminatedTime(historicPlanItemInstance.getTerminatedTime());
        result.setExitTime(historicPlanItemInstance.getExitTime());
        result.setEndedTime(historicPlanItemInstance.getEndedTime());
        result.setLastUpdatedTime(historicPlanItemInstance.getLastUpdatedTime());
        result.setStartUserId(historicPlanItemInstance.getStartUserId());
        result.setReferenceId(historicPlanItemInstance.getReferenceId());
        result.setReferenceType(historicPlanItemInstance.getReferenceType());
        result.setEntryCriterionId(historicPlanItemInstance.getEntryCriterionId());
        result.setExitCriterionId(historicPlanItemInstance.getExitCriterionId());
        result.setFormKey(historicPlanItemInstance.getFormKey());
        result.setExtraValue(historicPlanItemInstance.getExtraValue());
        result.setShowInOverview(historicPlanItemInstance.isShowInOverview());
        result.setTenantId(historicPlanItemInstance.getTenantId());
        result.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_PLANITEM_INSTANCE, new Object[]{historicPlanItemInstance.getId()}));
        result.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_CASE_INSTANCE, new Object[]{historicPlanItemInstance.getCaseInstanceId()}));
        result.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{historicPlanItemInstance.getCaseDefinitionId()}));
        if (historicPlanItemInstance.getDerivedCaseDefinitionId() != null) {
            result.setDerivedCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{historicPlanItemInstance.getDerivedCaseDefinitionId()}));
        }
        if (historicPlanItemInstance.getStageInstanceId() != null) {
            result.setStageInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORIC_PLANITEM_INSTANCE, new Object[]{historicPlanItemInstance.getStageInstanceId()}));
        }
        return result;
    }

    public List<DecisionResponse> createDecisionResponseList(List<DmnDecision> decisions, String processDefinitionId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DecisionResponse> responseList = new ArrayList<DecisionResponse>(decisions.size());
        for (DmnDecision decision : decisions) {
            responseList.add(this.createDecisionResponse(decision, processDefinitionId, urlBuilder));
        }
        return responseList;
    }

    public DecisionResponse createDecisionResponse(DmnDecision decision, String processDefinitionId) {
        return this.createDecisionResponse(decision, processDefinitionId, this.createUrlBuilder());
    }

    public DecisionResponse createDecisionResponse(DmnDecision decision, String caseDefinitionId, RestUrlBuilder urlBuilder) {
        DecisionResponse decisionResponse = new DecisionResponse(decision);
        decisionResponse.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION_DECISION_COLLECTION, new Object[]{caseDefinitionId}));
        return decisionResponse;
    }

    public List<FormDefinitionResponse> createFormDefinitionResponseList(List<FormDefinition> formDefinitions, String processDefinitionId) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<FormDefinitionResponse> responseList = new ArrayList<FormDefinitionResponse>(formDefinitions.size());
        for (FormDefinition formDefinition : formDefinitions) {
            responseList.add(this.createFormDefinitionResponse(formDefinition, processDefinitionId, urlBuilder));
        }
        return responseList;
    }

    public FormDefinitionResponse createFormDefintionResponse(FormDefinition formDefinition, String processDefinitionId) {
        return this.createFormDefinitionResponse(formDefinition, processDefinitionId, this.createUrlBuilder());
    }

    public FormDefinitionResponse createFormDefinitionResponse(FormDefinition formDefinition, String caseDefinitionId, RestUrlBuilder urlBuilder) {
        FormDefinitionResponse formDefinitionResponse = new FormDefinitionResponse(formDefinition);
        formDefinitionResponse.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION_FORM_DEFINITIONS_COLLECTION, new Object[]{caseDefinitionId}));
        return formDefinitionResponse;
    }

    public List<JobResponse> createJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, CmmnRestUrls.URL_JOB);
    }

    public List<JobResponse> createTimerJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, CmmnRestUrls.URL_TIMER_JOB);
    }

    public List<JobResponse> createSuspendedJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, CmmnRestUrls.URL_SUSPENDED_JOB);
    }

    public List<JobResponse> createDeadLetterJobResponseList(List<Job> jobs) {
        return this.createJobResponseList(jobs, CmmnRestUrls.URL_DEADLETTER_JOB);
    }

    public List<JobResponse> createJobResponseList(List<Job> jobs, String[] urlJobSegments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<JobResponse> responseList = new ArrayList<JobResponse>(jobs.size());
        for (Job instance : jobs) {
            responseList.add(this.createJobResponse(instance, urlBuilder, urlJobSegments));
        }
        return responseList;
    }

    public JobResponse createJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), CmmnRestUrls.URL_JOB);
    }

    public JobResponse createTimerJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), CmmnRestUrls.URL_TIMER_JOB);
    }

    public JobResponse createSuspendedJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), CmmnRestUrls.URL_SUSPENDED_JOB);
    }

    public JobResponse createDeadLetterJobResponse(Job job) {
        return this.createJobResponse(job, this.createUrlBuilder(), CmmnRestUrls.URL_DEADLETTER_JOB);
    }

    public JobResponse createJobResponse(Job job, RestUrlBuilder urlBuilder, String[] urlJobSegments) {
        JobResponse response = new JobResponse();
        response.setId(job.getId());
        response.setDueDate(job.getDuedate());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setRetries(job.getRetries());
        response.setCreateTime(job.getCreateTime());
        if (job instanceof JobInfoEntity) {
            JobInfoEntity jobInfoEntity = (JobInfoEntity)job;
            response.setLockOwner(jobInfoEntity.getLockOwner());
            response.setLockExpirationTime(jobInfoEntity.getLockExpirationTime());
        }
        response.setTenantId(job.getTenantId());
        response.setElementId(job.getElementId());
        response.setElementName(job.getElementName());
        response.setUrl(urlBuilder.buildUrl(urlJobSegments, new Object[]{job.getId()}));
        if ("cmmn".equals(job.getScopeType())) {
            if (job.getScopeDefinitionId() != null) {
                response.setCaseDefinitionId(job.getScopeDefinitionId());
                response.setCaseDefinitionUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_DEFINITION, new Object[]{job.getScopeDefinitionId()}));
            }
            if (job.getScopeId() != null) {
                response.setCaseInstanceId(job.getScopeId());
                response.setCaseInstanceUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_CASE_INSTANCE, new Object[]{job.getScopeId()}));
            }
            if (job.getSubScopeId() != null) {
                response.setPlanItemInstanceId(job.getSubScopeId());
            }
        }
        return response;
    }

    public List<HistoryJobResponse> createHistoryJobResponseList(List<HistoryJob> jobs) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoryJobResponse> responseList = new ArrayList<HistoryJobResponse>(jobs.size());
        for (HistoryJob job : jobs) {
            responseList.add(this.createHistoryJobResponse(job, urlBuilder));
        }
        return responseList;
    }

    public HistoryJobResponse createHistoryJobResponse(HistoryJob job) {
        return this.createHistoryJobResponse(job, this.createUrlBuilder());
    }

    public HistoryJobResponse createHistoryJobResponse(HistoryJob job, RestUrlBuilder urlBuilder) {
        HistoryJobResponse response = new HistoryJobResponse();
        response.setId(job.getId());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setRetries(job.getRetries());
        response.setCreateTime(job.getCreateTime());
        response.setScopeType(job.getScopeType());
        response.setJobHandlerType(job.getJobHandlerType());
        response.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        response.setCustomValues(job.getCustomValues());
        if (job instanceof HistoryJobEntity) {
            HistoryJobEntity historyJobEntity = (HistoryJobEntity)job;
            response.setLockOwner(historyJobEntity.getLockOwner());
            response.setLockExpirationTime(historyJobEntity.getLockExpirationTime());
        }
        response.setTenantId(job.getTenantId());
        response.setUrl(urlBuilder.buildUrl(CmmnRestUrls.URL_HISTORY_JOB, new Object[]{job.getId()}));
        return response;
    }

    public List<RestVariableConverter> getVariableConverters() {
        return this.variableConverters;
    }

    protected void initializeVariableConverters() {
        this.variableConverters.add((RestVariableConverter)new StringRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new IntegerRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LongRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new ShortRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DoubleRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new BooleanRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new InstantRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateTimeRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new JsonObjectRestVariableConverter(this.objectMapper));
    }

    protected String formatUrl(String serverRootUrl, String[] fragments, Object ... arguments) {
        StringBuilder urlBuilder = new StringBuilder(serverRootUrl);
        for (String urlFragment : fragments) {
            urlBuilder.append("/");
            urlBuilder.append(MessageFormat.format(urlFragment, arguments));
        }
        return urlBuilder.toString();
    }

    protected RestUrlBuilder createUrlBuilder() {
        return RestUrlBuilder.fromCurrentRequest();
    }
}

