/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.milestone;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceResponse;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.RequestUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Milestone"}, description="Manage History Milestone Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricMilestoneInstanceCollectionResource
extends HistoricMilestoneInstanceBaseResource {
    private static Map<String, BiConsumer<HistoricMilestoneInstanceQueryRequest, String>> mapping = new HashMap<String, BiConsumer<HistoricMilestoneInstanceQueryRequest, String>>();
    private static BiConsumer<HistoricMilestoneInstanceQueryRequest, String> voidConsumer = (o1, o2) -> {};

    @ApiOperation(value="List of historic milestone instances", tags={"History Milestone"}, nickname="listHistoricMilestoneInstances")
    @ApiImplicitParams(value={@ApiImplicitParam(name="milestoneId", dataType="string", value="An id of the historic milestone instance.", paramType="query"), @ApiImplicitParam(name="milestoneName", dataType="string", value="The name of the historic milestone instance", paramType="query"), @ApiImplicitParam(name="caseInstanceId", dataType="string", value="The id of the case instance containing the milestone.", paramType="query"), @ApiImplicitParam(name="caseDefinitionId", dataType="string", value="The id of the definition of the case where the milestone is defined.", paramType="query"), @ApiImplicitParam(name="reachedBefore", dataType="string", value="Return only historic milestone instances that were reached before this date.", paramType="query"), @ApiImplicitParam(name="reachedAfter", dataType="string", value="Return only historic milestone instances that were reached after this date.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that historic milestone instances could be queried."), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @GetMapping(value={"/cmmn-history/historic-milestone-instances"}, produces={"application/json"})
    public DataResponse<HistoricMilestoneInstanceResponse> getHistoricMilestoneInstances(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        HistoricMilestoneInstanceQueryRequest queryRequest = new HistoricMilestoneInstanceQueryRequest();
        allRequestParams.forEach((key, value) -> Optional.ofNullable(value).ifPresent(v -> mapping.getOrDefault(key, voidConsumer).accept(queryRequest, (String)v)));
        return this.getQueryResponse(queryRequest, allRequestParams);
    }

    static {
        mapping.put("milestoneId", HistoricMilestoneInstanceQueryRequest::setId);
        mapping.put("milestoneName", HistoricMilestoneInstanceQueryRequest::setName);
        mapping.put("caseInstanceId", HistoricMilestoneInstanceQueryRequest::setCaseInstanceId);
        mapping.put("caseDefinitionId", HistoricMilestoneInstanceQueryRequest::setCaseDefinitionId);
        mapping.put("reachedBefore", (h, s) -> h.setReachedBefore(RequestUtil.parseLongDate((String)s)));
        mapping.put("reachedAfter", (h, s) -> h.setReachedAfter(RequestUtil.parseLongDate((String)s)));
    }
}

