/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.engine.RestIdentityLink;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionIdentityLinkCollectionResource
extends BaseCaseDefinitionResource {
    @ApiOperation(value="List candidate starters for a case definition", nickname="listCaseDefinitionIdentityLinks", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case definition was found and the requested identity links are returned."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/identitylinks"}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinks(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, HttpServletRequest request) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseDefinitionIdentityLinks(caseDefinition);
        }
        return this.restResponseFactory.createRestIdentityLinks(this.repositoryService.getIdentityLinksForCaseDefinition(caseDefinition.getId()));
    }

    @ApiOperation(value="Add a candidate starter to a case definition", tags={"Case Definitions"}, notes="It is possible to add either a user or a group.")
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the case definition was found and the identity link was created."), @ApiResponse(code=400, message="Indicates the body does not contain the correct information."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PostMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/identitylinks"}, produces={"application/json"})
    public RestIdentityLink createIdentityLink(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @RequestBody RestIdentityLink identityLink, HttpServletRequest request, HttpServletResponse response) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (identityLink.getGroup() == null && identityLink.getUser() == null) {
            throw new FlowableIllegalArgumentException("A group or a user is required to create an identity link.");
        }
        if (identityLink.getGroup() != null && identityLink.getUser() != null) {
            throw new FlowableIllegalArgumentException("Only one of user or group can be used to create an identity link.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.createCaseDefinitionIdentityLink(caseDefinition, identityLink);
        }
        if (identityLink.getGroup() != null) {
            this.repositoryService.addCandidateStarterGroup(caseDefinition.getId(), identityLink.getGroup());
        } else {
            this.repositoryService.addCandidateStarterUser(caseDefinition.getId(), identityLink.getUser());
        }
        identityLink.setType("candidate");
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createRestIdentityLink(identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), null, caseDefinition.getId(), null);
    }
}

