/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionModelResource
extends BaseCaseDefinitionResource {
    @ApiOperation(value="Get a case definition CMMN model", tags={"Case Definitions"}, nickname="getCmmnModelResource")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process definition was found and the model is returned. The response contains the full process definition model."), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/model"}, produces={"application/json"})
    public CmmnModel getModelResource(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        return this.repositoryService.getCmmnModel(caseDefinition.getId());
    }
}

