/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricIdentityLinkResponse;
import org.flowable.rest.service.api.history.HistoricTaskInstanceBaseResource;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Task"}, description="Manage History Task Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricTaskInstanceIdentityLinkCollectionResource
extends HistoricTaskInstanceBaseResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @ApiOperation(value="List identity links of a historic task instance", nickname="listHistoricTaskInstanceIdentityLinks", tags={"History Task"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the identity links are returned", response=HistoricIdentityLinkResponse.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the task instance could not be found.")})
    @GetMapping(value={"/history/historic-task-instances/{taskId}/identitylinks"}, produces={"application/json"})
    public List<HistoricIdentityLinkResponse> getTaskIdentityLinks(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        List identityLinks;
        HistoricTaskInstance task = this.getHistoricTaskInstanceFromRequestWithoutAccessCheck(taskId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoricTaskIdentityLinks(task);
        }
        if ((identityLinks = this.historyService.getHistoricIdentityLinksForTask(taskId)) != null) {
            return this.restResponseFactory.createHistoricIdentityLinkResponseList(identityLinks);
        }
        return new ArrayList<HistoricIdentityLinkResponse>();
    }
}

