/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.management.TableResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Database tables"}, description="Manage Database tables", authorizations={@Authorization(value="basicAuth")})
public class TableCollectionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value=" List tables", tags={"Database tables"}, nickname="listTables")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the request was successful.")})
    @GetMapping(value={"/management/tables"}, produces={"application/json"})
    public List<TableResponse> getTables(HttpServletRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessTableInfo();
        }
        return this.restResponseFactory.createTableResponseList(this.managementService.getTableCount());
    }
}

