/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.LongToBigIntNode;
import com.oracle.truffle.js.nodes.cast.LongToBigIntNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSEqualNode.class)
public final class JSEqualNodeGen
extends JSEqualNode {
    private static final InlineSupport.StateField OVERLOADED_JS_EQUAL_NODE_OVERLOADED_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)OverloadedData.lookup_(), (String)"overloaded_state_0_");
    private static final InlineSupport.StateField STATE_1_JSEqualNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
    private static final JSToBooleanNode INLINED_OVERLOADED_TO_BOOLEAN_NODE_ = JSToBooleanNodeGen.inline(InlineSupport.InlineTarget.create(JSToBooleanNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{OVERLOADED_JS_EQUAL_NODE_OVERLOADED_STATE_0_UPDATER.subUpdater(0, 15), InlineSupport.ReferenceField.create((MethodHandles.Lookup)OverloadedData.lookup_(), (String)"overloaded_toBooleanNode__field1_", Node.class)}));
    private static final LongToBigIntNode INLINED_FOREIGN_LONG_TO_BIG_INT_A_ = LongToBigIntNodeGen.inline(InlineSupport.InlineTarget.create(LongToBigIntNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_JSEqualNode_UPDATER.subUpdater(14, 2)}));
    private static final LongToBigIntNode INLINED_FOREIGN_LONG_TO_BIG_INT_B_ = LongToBigIntNodeGen.inline(InlineSupport.InlineTarget.create(LongToBigIntNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_JSEqualNode_UPDATER.subUpdater(16, 2)}));
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int state_1_;
    @Node.Child
    private JSStringToNumberNode stringToDouble;
    @Node.Child
    private InteropLibrary bInterop;
    @Node.Child
    private InteropLibrary aInterop;
    @Node.Child
    private JSToPrimitiveNode toPrimitiveNode;
    @Node.Child
    private IsPrimitiveNode isPrimitiveNode;
    @Node.Child
    private JSEqualNode nestedEqualNode;
    @Node.Child
    private IsObjectNode isObjectNode;
    @Node.Child
    private TruffleString.EqualNode string_equalsNode_;
    @Node.Child
    private OverloadedData overloaded_cache;

    private JSEqualNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    private boolean fallbackGuard_(int state_0, int state_1, Object leftNodeValue, Object rightNodeValue) {
        JSObject rightNodeValue_;
        JSDynamicObject rightNodeValue_2;
        JSDynamicObject leftNodeValue_;
        if ((state_0 & 4) == 0 && leftNodeValue instanceof Long && rightNodeValue instanceof Long) {
            return false;
        }
        if (((state_0 & 8) == 0 || (state_1 & 0x3F00) != 16128) && JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && leftNodeValue instanceof BigInt && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue)) {
            if (((state_0 & 0x20) == 0 || (state_1 & 0x700) != 1792) && rightNodeValue instanceof TruffleString) {
                return false;
            }
            if (((state_0 & 0x40) == 0 || (state_1 & 0x700) != 1792) && rightNodeValue instanceof Boolean) {
                return false;
            }
        }
        if (leftNodeValue instanceof Boolean) {
            if ((state_0 & 0x80) == 0 && rightNodeValue instanceof Boolean) {
                return false;
            }
            if (((state_0 & 0x200) == 0 || (state_1 & 0x3800) != 14336) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
            if ((state_0 & 0x400) == 0 && rightNodeValue instanceof TruffleString) {
                return false;
            }
        }
        if (leftNodeValue instanceof TruffleString) {
            if ((state_0 & 0x1000) == 0 && rightNodeValue instanceof TruffleString) {
                return false;
            }
            if (((state_0 & 0x2000) == 0 || (state_1 & 0x3800) != 14336) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
            if ((state_0 & 0x4000) == 0 && rightNodeValue instanceof Boolean) {
                return false;
            }
            if ((state_0 & 0x8000) == 0 && rightNodeValue instanceof BigInt) {
                return false;
            }
        }
        if ((state_0 & 0x10000) == 0 && leftNodeValue instanceof BigInt && rightNodeValue instanceof TruffleString) {
            return false;
        }
        if ((state_0 & 0x20000) == 0 && leftNodeValue instanceof Boolean && rightNodeValue instanceof BigInt) {
            return false;
        }
        if ((state_0 & 0x40000) == 0 && leftNodeValue instanceof BigInt && rightNodeValue instanceof Boolean) {
            return false;
        }
        if ((state_0 & 0x100000) == 0 && JSRuntime.isNullOrUndefined(leftNodeValue)) {
            return false;
        }
        if ((state_0 & 0x200000) == 0 && JSRuntime.isNullOrUndefined(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x400000) == 0 && (this.hasOverloadedOperators(leftNodeValue) || this.hasOverloadedOperators(rightNodeValue))) {
            return false;
        }
        if (leftNodeValue instanceof JSObject && rightNodeValue instanceof JSDynamicObject && !this.hasOverloadedOperators((Object)(leftNodeValue_ = (JSObject)((Object)leftNodeValue))) && !this.hasOverloadedOperators((Object)(rightNodeValue_2 = (JSDynamicObject)((Object)rightNodeValue)))) {
            return false;
        }
        if (leftNodeValue instanceof JSDynamicObject && rightNodeValue instanceof JSObject && !this.hasOverloadedOperators((Object)(leftNodeValue_ = (JSDynamicObject)((Object)leftNodeValue))) && !this.hasOverloadedOperators((Object)(rightNodeValue_2 = (JSObject)((Object)rightNodeValue)))) {
            return false;
        }
        if (leftNodeValue instanceof JSObject && !this.hasOverloadedOperators((Object)(leftNodeValue_ = (JSObject)((Object)leftNodeValue)))) {
            IsPrimitiveNode isPrimitiveNode_ = this.isPrimitiveNode;
            if ((state_0 & 0x4000000) == 0 || isPrimitiveNode_ == null || isPrimitiveNode_.executeBoolean(rightNodeValue)) {
                return false;
            }
        }
        if (rightNodeValue instanceof JSObject && !this.hasOverloadedOperators((Object)(rightNodeValue_ = (JSObject)((Object)rightNodeValue)))) {
            IsPrimitiveNode isPrimitiveNode_1 = this.isPrimitiveNode;
            if ((state_0 & 0x10000000) == 0 || isPrimitiveNode_1 == null || isPrimitiveNode_1.executeBoolean(leftNodeValue)) {
                return false;
            }
        }
        if (((state_0 & 0x40000000) == 0 || (state_1 & 0x3800) != 14336) && leftNodeValue instanceof BigInt && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if (((state_1 & 1) == 0 || (state_1 & 0x700) != 1792) && JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (leftNodeValue instanceof Symbol) {
            if ((state_1 & 2) == 0 && rightNodeValue instanceof Symbol) {
                return false;
            }
            if (!JSGuards.isSymbol(rightNodeValue)) {
                IsObjectNode isObjectNode_ = this.isObjectNode;
                if ((state_1 & 8) == 0 || isObjectNode_ == null || !isObjectNode_.executeBoolean(rightNodeValue)) {
                    return false;
                }
            }
        }
        if (rightNodeValue instanceof Symbol && !JSGuards.isSymbol(leftNodeValue)) {
            IsObjectNode isObjectNode_1 = this.isObjectNode;
            if ((state_1 & 0x20) == 0 || isObjectNode_1 == null || !isObjectNode_1.executeBoolean(leftNodeValue)) {
                return false;
            }
        }
        return (state_1 & 0x40) != 0 || !JSGuards.isForeignObjectOrNumber(leftNodeValue) && !JSGuards.isForeignObjectOrNumber(rightNodeValue);
    }

    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) {
            TruffleString rightNodeValue_;
            if ((state_0 & 3) != 0 && leftNodeValue instanceof Integer) {
                int n = (Integer)leftNodeValue;
                if ((state_0 & 1) != 0 && rightNodeValue instanceof Integer) {
                    int rightNodeValue_2 = (Integer)rightNodeValue;
                    return JSEqualNode.doInt(n, rightNodeValue_2);
                }
                if ((state_0 & 2) != 0 && rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_3 = (Boolean)rightNodeValue;
                    return JSEqualNode.doIntBoolean(n, rightNodeValue_3);
                }
            }
            if ((state_0 & 4) != 0 && leftNodeValue instanceof Long) {
                long l = (Long)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_4 = (Long)rightNodeValue;
                    return JSEqualNode.doLong(l, rightNodeValue_4);
                }
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue)) {
                double d = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue);
                if (JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue)) {
                    double rightNodeValue_5 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue);
                    return JSEqualNode.doDouble(d, rightNodeValue_5);
                }
            }
            if ((state_0 & 0x10) != 0 && leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_6 = (BigInt)rightNodeValue;
                    return JSEqualNode.doBigInt(bigInt, rightNodeValue_6);
                }
            }
            if ((state_0 & 0x60) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue)) {
                double d = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue);
                if ((state_0 & 0x20) != 0 && rightNodeValue instanceof TruffleString) {
                    TruffleString rightNodeValue_7 = (TruffleString)rightNodeValue;
                    JSStringToNumberNode stringToDouble_ = this.stringToDouble;
                    if (stringToDouble_ != null) {
                        return JSEqualNode.doDoubleString(d, rightNodeValue_7, stringToDouble_);
                    }
                }
                if ((state_0 & 0x40) != 0 && rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_8 = (Boolean)rightNodeValue;
                    return JSEqualNode.doDoubleBoolean(d, rightNodeValue_8);
                }
            }
            if ((state_0 & 0x780) != 0 && leftNodeValue instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue;
                if ((state_0 & 0x80) != 0 && rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_9 = (Boolean)rightNodeValue;
                    return JSEqualNode.doBoolean(bl, rightNodeValue_9);
                }
                if ((state_0 & 0x100) != 0 && rightNodeValue instanceof Integer) {
                    int rightNodeValue_10 = (Integer)rightNodeValue;
                    return JSEqualNode.doBooleanInt(bl, rightNodeValue_10);
                }
                if ((state_0 & 0x200) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue)) {
                    double rightNodeValue_11 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue);
                    return JSEqualNode.doBooleanDouble(bl, rightNodeValue_11);
                }
                if ((state_0 & 0x400) != 0 && rightNodeValue instanceof TruffleString) {
                    rightNodeValue_ = (TruffleString)rightNodeValue;
                    JSStringToNumberNode stringToDouble_1 = this.stringToDouble;
                    if (stringToDouble_1 != null) {
                        return JSEqualNode.doBooleanString(bl, rightNodeValue_, stringToDouble_1);
                    }
                }
            }
            if ((state_0 & 0xF800) != 0 && leftNodeValue instanceof TruffleString) {
                TruffleString truffleString = (TruffleString)leftNodeValue;
                if ((state_0 & 0x1800) != 0 && rightNodeValue instanceof TruffleString) {
                    TruffleString.EqualNode equalsNode__;
                    rightNodeValue_ = (TruffleString)rightNodeValue;
                    if ((state_0 & 0x800) != 0 && JSGuards.isReferenceEquals(truffleString, rightNodeValue_)) {
                        return JSEqualNode.doStringIdentity(truffleString, rightNodeValue_);
                    }
                    if ((state_0 & 0x1000) != 0 && (equalsNode__ = this.string_equalsNode_) != null) {
                        return JSEqualNode.doString(truffleString, rightNodeValue_, equalsNode__);
                    }
                }
                if ((state_0 & 0x2000) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue)) {
                    double rightNodeValue_12 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue);
                    JSStringToNumberNode stringToDouble_2 = this.stringToDouble;
                    if (stringToDouble_2 != null) {
                        return JSEqualNode.doStringDouble(truffleString, rightNodeValue_12, stringToDouble_2);
                    }
                }
                if ((state_0 & 0x4000) != 0 && rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_13 = (Boolean)rightNodeValue;
                    JSStringToNumberNode stringToDouble_3 = this.stringToDouble;
                    if (stringToDouble_3 != null) {
                        return JSEqualNode.doStringBoolean(truffleString, rightNodeValue_13, stringToDouble_3);
                    }
                }
                if ((state_0 & 0x8000) != 0 && rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_14 = (BigInt)rightNodeValue;
                    return JSEqualNode.doStringBigInt(truffleString, rightNodeValue_14);
                }
            }
            if ((state_0 & 0x10000) != 0 && leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof TruffleString) {
                    TruffleString rightNodeValue_15 = (TruffleString)rightNodeValue;
                    return JSEqualNode.doBigIntString(bigInt, rightNodeValue_15);
                }
            }
            if ((state_0 & 0x20000) != 0 && leftNodeValue instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_16 = (BigInt)rightNodeValue;
                    return JSEqualNode.doBooleanBigInt(bl, rightNodeValue_16);
                }
            }
            if ((state_0 & 0x40000) != 0 && leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_17 = (Boolean)rightNodeValue;
                    return JSEqualNode.doBigIntBoolean(bigInt, rightNodeValue_17);
                }
            }
            if ((state_0 & 0x780000) != 0) {
                OverloadedData overloadedData;
                InteropLibrary interopLibrary;
                InteropLibrary interopLibrary2;
                if ((state_0 & 0x80000) != 0 && JSRuntime.isNullOrUndefined(leftNodeValue) && JSRuntime.isNullOrUndefined(rightNodeValue)) {
                    return JSEqualNode.doBothNullOrUndefined(leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x100000) != 0 && (interopLibrary2 = this.bInterop) != null && JSRuntime.isNullOrUndefined(leftNodeValue)) {
                    return JSEqualNode.doLeftNullOrUndefined(leftNodeValue, rightNodeValue, interopLibrary2);
                }
                if ((state_0 & 0x200000) != 0 && (interopLibrary = this.aInterop) != null && JSRuntime.isNullOrUndefined(rightNodeValue)) {
                    return JSEqualNode.doRightNullOrUndefined(leftNodeValue, rightNodeValue, interopLibrary);
                }
                if ((state_0 & 0x400000) != 0 && (overloadedData = this.overloaded_cache) != null && (this.hasOverloadedOperators(leftNodeValue) || this.hasOverloadedOperators(rightNodeValue))) {
                    OverloadedData node__ = overloadedData;
                    return JSEqualNode.doOverloaded(leftNodeValue, rightNodeValue, node__, overloadedData.overloadedOperatorNode_, INLINED_OVERLOADED_TO_BOOLEAN_NODE_);
                }
            }
            if ((state_0 & 0x800000) != 0 && leftNodeValue instanceof JSObject) {
                JSObject jSObject = (JSObject)((Object)leftNodeValue);
                if (rightNodeValue instanceof JSDynamicObject) {
                    JSDynamicObject rightNodeValue_18 = (JSDynamicObject)((Object)rightNodeValue);
                    if (!this.hasOverloadedOperators((Object)jSObject) && !this.hasOverloadedOperators((Object)rightNodeValue_18)) {
                        return JSEqualNode.doJSObject(jSObject, rightNodeValue_18);
                    }
                }
            }
            if ((state_0 & 0x1000000) != 0 && leftNodeValue instanceof JSDynamicObject) {
                JSDynamicObject jSDynamicObject = (JSDynamicObject)((Object)leftNodeValue);
                if (rightNodeValue instanceof JSObject) {
                    JSObject rightNodeValue_19 = (JSObject)((Object)rightNodeValue);
                    if (!this.hasOverloadedOperators((Object)jSDynamicObject) && !this.hasOverloadedOperators((Object)rightNodeValue_19)) {
                        return JSEqualNode.doJSObject(jSDynamicObject, rightNodeValue_19);
                    }
                }
            }
            if ((state_0 & 0x2000000) != 0 && leftNodeValue instanceof JSObject) {
                JSEqualNode nestedEqualNode_;
                IsPrimitiveNode isPrimitiveNode_;
                JSToPrimitiveNode toPrimitiveNode_;
                JSObject jSObject = (JSObject)((Object)leftNodeValue);
                InteropLibrary bInterop_1 = this.bInterop;
                if (bInterop_1 != null && (toPrimitiveNode_ = this.toPrimitiveNode) != null && (isPrimitiveNode_ = this.isPrimitiveNode) != null && (nestedEqualNode_ = this.nestedEqualNode) != null && !this.hasOverloadedOperators((Object)jSObject) && isPrimitiveNode_.executeBoolean(rightNodeValue)) {
                    return JSEqualNode.doJSObjectVsPrimitive(jSObject, rightNodeValue, bInterop_1, toPrimitiveNode_, isPrimitiveNode_, nestedEqualNode_);
                }
            }
            if ((state_0 & 0x8000000) != 0 && rightNodeValue instanceof JSObject) {
                JSEqualNode nestedEqualNode_1;
                IsPrimitiveNode isPrimitiveNode_1;
                JSToPrimitiveNode toPrimitiveNode_1;
                JSObject jSObject = (JSObject)((Object)rightNodeValue);
                InteropLibrary aInterop_1 = this.aInterop;
                if (aInterop_1 != null && (toPrimitiveNode_1 = this.toPrimitiveNode) != null && (isPrimitiveNode_1 = this.isPrimitiveNode) != null && (nestedEqualNode_1 = this.nestedEqualNode) != null && !this.hasOverloadedOperators((Object)jSObject) && isPrimitiveNode_1.executeBoolean(leftNodeValue)) {
                    return JSEqualNode.doJSObjectVsPrimitive(leftNodeValue, jSObject, aInterop_1, toPrimitiveNode_1, isPrimitiveNode_1, nestedEqualNode_1);
                }
            }
            if ((state_0 & 0x60000000) != 0 && leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if ((state_0 & 0x20000000) != 0 && rightNodeValue instanceof Integer) {
                    int rightNodeValue_21 = (Integer)rightNodeValue;
                    return JSEqualNode.doBigIntAndInt(bigInt, rightNodeValue_21);
                }
                if ((state_0 & 0x40000000) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue)) {
                    double rightNodeValue_22 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue);
                    return JSEqualNode.doBigIntAndNumber(bigInt, rightNodeValue_22);
                }
            }
            if (((state_0 & Integer.MIN_VALUE) != 0 || (state_1 & 1) != 0) && rightNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)rightNodeValue;
                if ((state_0 & Integer.MIN_VALUE) != 0 && leftNodeValue instanceof Integer) {
                    int leftNodeValue_14 = (Integer)leftNodeValue;
                    return JSEqualNode.doIntAndBigInt(leftNodeValue_14, bigInt);
                }
                if ((state_1 & 1) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue)) {
                    double leftNodeValue_15 = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue);
                    return JSEqualNode.doNumberAndBigInt(leftNodeValue_15, bigInt);
                }
            }
            if ((state_1 & 6) != 0 && leftNodeValue instanceof Symbol) {
                IsObjectNode isObjectNode_;
                Symbol symbol = (Symbol)leftNodeValue;
                if ((state_1 & 2) != 0 && rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_24 = (Symbol)rightNodeValue;
                    return JSEqualNode.doSymbol(symbol, rightNodeValue_24);
                }
                if ((state_1 & 4) != 0 && (isObjectNode_ = this.isObjectNode) != null && !JSGuards.isSymbol(rightNodeValue) && !isObjectNode_.executeBoolean(rightNodeValue)) {
                    return JSEqualNode.doSymbolNotSymbol(symbol, rightNodeValue, isObjectNode_);
                }
            }
            if ((state_1 & 0xD0) != 0) {
                if ((state_1 & 0x10) != 0 && rightNodeValue instanceof Symbol) {
                    Symbol symbol = (Symbol)rightNodeValue;
                    IsObjectNode isObjectNode_1 = this.isObjectNode;
                    if (isObjectNode_1 != null && !JSGuards.isSymbol(leftNodeValue) && !isObjectNode_1.executeBoolean(leftNodeValue)) {
                        return JSEqualNode.doSymbolNotSymbol(leftNodeValue, symbol, isObjectNode_1);
                    }
                }
                if ((state_1 & 0xC0) != 0) {
                    JSEqualNode nestedEqualNode_2;
                    IsPrimitiveNode isPrimitiveNode_2;
                    JSToPrimitiveNode toPrimitiveNode_2;
                    InteropLibrary bInterop_2;
                    InteropLibrary interopLibrary;
                    if ((state_1 & 0x40) != 0 && (interopLibrary = this.aInterop) != null && (bInterop_2 = this.bInterop) != null && (toPrimitiveNode_2 = this.toPrimitiveNode) != null && (isPrimitiveNode_2 = this.isPrimitiveNode) != null && (nestedEqualNode_2 = this.nestedEqualNode) != null) {
                        boolean isAForeign__ = JSGuards.isForeignObjectOrNumber(leftNodeValue);
                        boolean isBForeign__ = JSGuards.isForeignObjectOrNumber(rightNodeValue);
                        if (isAForeign__ || isBForeign__) {
                            return this.doForeign(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, interopLibrary, bInterop_2, toPrimitiveNode_2, isPrimitiveNode_2, nestedEqualNode_2, INLINED_FOREIGN_LONG_TO_BIG_INT_A_, INLINED_FOREIGN_LONG_TO_BIG_INT_B_);
                        }
                    }
                    if ((state_1 & 0x80) != 0 && this.fallbackGuard_(state_0, state_1, leftNodeValue, rightNodeValue)) {
                        return JSEqualNode.doFallback(leftNodeValue, rightNodeValue);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if ((state_0 & 0xEBFFFFFE) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_int_int0(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFFFD) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_int_boolean1(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFFF7) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_double_double2(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFFBF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_double_boolean3(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFF7F) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_boolean_boolean4(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFEFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_boolean_int5(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFDFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_boolean_double6(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFFFF9F) == 0 && (state_1 & 0xD6) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_double7(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFDFBFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_boolean8(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xABFFDFFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_double9(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xEBFBBFFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_boolean10(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xCBFFFFFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_int11(state_0, state_1, frameValue);
        }
        if ((state_0 & 0x6BFFFFFF) == 0 && (state_1 & 0xD7) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
            return this.executeBoolean_int12(state_0, state_1, frameValue);
        }
        return this.executeBoolean_generic13(state_0, state_1, frameValue);
    }

    private boolean executeBoolean_int_int0(int state_0__, int state_1, VirtualFrame frameValue) {
        int rightNodeValue_;
        int leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return JSEqualNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int_boolean1(int state_0__, int state_1, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        int leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return JSEqualNode.doIntBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double2(int state_0__, int state_1, VirtualFrame frameValue) {
        double rightNodeValue_;
        double leftNodeValue_;
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        try {
            if ((state_1 & 0x600) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else if ((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        try {
            if ((state_1 & 0x3000) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else if ((state_1 & 0x2800) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) ? (Number)leftNodeValue_int : (Number)leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return JSEqualNode.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_boolean3(int state_0__, int state_1, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        double leftNodeValue_;
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        try {
            if ((state_1 & 0x600) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else if ((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) ? (Number)leftNodeValue_int : (Number)leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x40) != 0);
        return JSEqualNode.doDoubleBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean4(int state_0__, int state_1, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x80) != 0);
        return JSEqualNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_int5(int state_0__, int state_1, VirtualFrame frameValue) {
        int rightNodeValue_;
        boolean leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x100) != 0);
        return JSEqualNode.doBooleanInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_double6(int state_0__, int state_1, VirtualFrame frameValue) {
        double rightNodeValue_;
        boolean leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        try {
            if ((state_1 & 0x3000) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else if ((state_1 & 0x2800) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x200) != 0);
        return JSEqualNode.doBooleanDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double7(int state_0__, int state_1__, VirtualFrame frameValue) {
        double leftNodeValue_;
        int state_0 = state_0__;
        int state_1 = state_1__;
        int leftNodeValue_int = 0;
        try {
            if ((state_1 & 0x600) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else if ((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0x60) != 0 || (state_1 & 1) != 0) {
            Object rightNodeValue__;
            if ((state_0 & 0x20) != 0 && rightNodeValue_ instanceof TruffleString) {
                rightNodeValue__ = (TruffleString)rightNodeValue_;
                JSStringToNumberNode stringToDouble_ = this.stringToDouble;
                if (stringToDouble_ != null) {
                    return JSEqualNode.doDoubleString(leftNodeValue_, rightNodeValue__, stringToDouble_);
                }
            }
            if ((state_0 & 0x40) != 0 && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__2 = (Boolean)rightNodeValue_;
                return JSEqualNode.doDoubleBoolean(leftNodeValue_, rightNodeValue__2);
            }
            if ((state_1 & 1) != 0 && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return JSEqualNode.doNumberAndBigInt(leftNodeValue_, (BigInt)rightNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state_1 & 0x500) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) ? (Number)leftNodeValue_int : (Number)leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean8(int state_0__, int state_1, VirtualFrame frameValue) {
        boolean leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0x20400) != 0) {
            Object rightNodeValue__;
            if ((state_0 & 0x400) != 0 && rightNodeValue_ instanceof TruffleString) {
                rightNodeValue__ = (TruffleString)rightNodeValue_;
                JSStringToNumberNode stringToDouble_1 = this.stringToDouble;
                if (stringToDouble_1 != null) {
                    return JSEqualNode.doBooleanString(leftNodeValue_, rightNodeValue__, stringToDouble_1);
                }
            }
            if ((state_0 & 0x20000) != 0 && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return JSEqualNode.doBooleanBigInt(leftNodeValue_, (BigInt)rightNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double9(int state_0__, int state_1, VirtualFrame frameValue) {
        double rightNodeValue_;
        int state_0 = state_0__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        try {
            if ((state_1 & 0x3000) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else if ((state_1 & 0x2800) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0)) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state_0 & 0x40002000) != 0) {
            Object leftNodeValue__;
            if ((state_0 & 0x2000) != 0 && leftNodeValue_ instanceof TruffleString) {
                leftNodeValue__ = (TruffleString)leftNodeValue_;
                JSStringToNumberNode stringToDouble_2 = this.stringToDouble;
                if (stringToDouble_2 != null) {
                    return JSEqualNode.doStringDouble(leftNodeValue__, rightNodeValue_, stringToDouble_2);
                }
            }
            if ((state_0 & 0x40000000) != 0 && leftNodeValue_ instanceof BigInt) {
                leftNodeValue__ = (BigInt)leftNodeValue_;
                return JSEqualNode.doBigIntAndNumber((BigInt)leftNodeValue__, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state_1 & 0x2800) == 0 && ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) ? (Number)rightNodeValue_int : (Number)rightNodeValue_);
    }

    private boolean executeBoolean_boolean10(int state_0__, int state_1, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        int state_0 = state_0__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state_0 & 0x44000) != 0) {
            Object leftNodeValue__;
            if ((state_0 & 0x4000) != 0 && leftNodeValue_ instanceof TruffleString) {
                leftNodeValue__ = (TruffleString)leftNodeValue_;
                JSStringToNumberNode stringToDouble_3 = this.stringToDouble;
                if (stringToDouble_3 != null) {
                    return JSEqualNode.doStringBoolean(leftNodeValue__, rightNodeValue_, stringToDouble_3);
                }
            }
            if ((state_0 & 0x40000) != 0 && leftNodeValue_ instanceof BigInt) {
                leftNodeValue__ = (BigInt)leftNodeValue_;
                return JSEqualNode.doBigIntBoolean((BigInt)leftNodeValue__, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int11(int state_0__, int state_1, VirtualFrame frameValue) {
        int rightNodeValue_;
        int state_0 = state_0__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x20000000) != 0);
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return JSEqualNode.doBigIntAndInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int12(int state_0__, int state_1, VirtualFrame frameValue) {
        int leftNodeValue_;
        int state_0 = state_0__;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state_0 & Integer.MIN_VALUE) != 0);
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return JSEqualNode.doIntAndBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_generic13(int state_0__, int state_1__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int state_1 = state_1__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0xEBFFFFFF) != 0 || (state_1 & 0xD7) != 0) {
            TruffleString rightNodeValue__;
            if ((state_0 & 3) != 0 && leftNodeValue_ instanceof Integer) {
                int n = (Integer)leftNodeValue_;
                if ((state_0 & 1) != 0 && rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__2 = (Integer)rightNodeValue_;
                    return JSEqualNode.doInt(n, rightNodeValue__2);
                }
                if ((state_0 & 2) != 0 && rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__3 = (Boolean)rightNodeValue_;
                    return JSEqualNode.doIntBoolean(n, rightNodeValue__3);
                }
            }
            if ((state_0 & 4) != 0 && leftNodeValue_ instanceof Long) {
                long l = (Long)leftNodeValue_;
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__4 = (Long)rightNodeValue_;
                    return JSEqualNode.doLong(l, rightNodeValue__4);
                }
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_)) {
                double d = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_);
                if (JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_)) {
                    double rightNodeValue__5 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_);
                    return JSEqualNode.doDouble(d, rightNodeValue__5);
                }
            }
            if ((state_0 & 0x10) != 0 && leftNodeValue_ instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__6 = (BigInt)rightNodeValue_;
                    return JSEqualNode.doBigInt(bigInt, rightNodeValue__6);
                }
            }
            if ((state_0 & 0x60) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_)) {
                double d = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_);
                if ((state_0 & 0x20) != 0 && rightNodeValue_ instanceof TruffleString) {
                    TruffleString rightNodeValue__7 = (TruffleString)rightNodeValue_;
                    JSStringToNumberNode stringToDouble_ = this.stringToDouble;
                    if (stringToDouble_ != null) {
                        return JSEqualNode.doDoubleString(d, rightNodeValue__7, stringToDouble_);
                    }
                }
                if ((state_0 & 0x40) != 0 && rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__8 = (Boolean)rightNodeValue_;
                    return JSEqualNode.doDoubleBoolean(d, rightNodeValue__8);
                }
            }
            if ((state_0 & 0x780) != 0 && leftNodeValue_ instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue_;
                if ((state_0 & 0x80) != 0 && rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__9 = (Boolean)rightNodeValue_;
                    return JSEqualNode.doBoolean(bl, rightNodeValue__9);
                }
                if ((state_0 & 0x100) != 0 && rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__10 = (Integer)rightNodeValue_;
                    return JSEqualNode.doBooleanInt(bl, rightNodeValue__10);
                }
                if ((state_0 & 0x200) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_)) {
                    double rightNodeValue__11 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_);
                    return JSEqualNode.doBooleanDouble(bl, rightNodeValue__11);
                }
                if ((state_0 & 0x400) != 0 && rightNodeValue_ instanceof TruffleString) {
                    rightNodeValue__ = (TruffleString)rightNodeValue_;
                    JSStringToNumberNode stringToDouble_1 = this.stringToDouble;
                    if (stringToDouble_1 != null) {
                        return JSEqualNode.doBooleanString(bl, rightNodeValue__, stringToDouble_1);
                    }
                }
            }
            if ((state_0 & 0xF800) != 0 && leftNodeValue_ instanceof TruffleString) {
                TruffleString truffleString = (TruffleString)leftNodeValue_;
                if ((state_0 & 0x1800) != 0 && rightNodeValue_ instanceof TruffleString) {
                    TruffleString.EqualNode equalsNode__;
                    rightNodeValue__ = (TruffleString)rightNodeValue_;
                    if ((state_0 & 0x800) != 0 && JSGuards.isReferenceEquals(truffleString, rightNodeValue__)) {
                        return JSEqualNode.doStringIdentity(truffleString, rightNodeValue__);
                    }
                    if ((state_0 & 0x1000) != 0 && (equalsNode__ = this.string_equalsNode_) != null) {
                        return JSEqualNode.doString(truffleString, rightNodeValue__, equalsNode__);
                    }
                }
                if ((state_0 & 0x2000) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_)) {
                    double rightNodeValue__12 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_);
                    JSStringToNumberNode stringToDouble_2 = this.stringToDouble;
                    if (stringToDouble_2 != null) {
                        return JSEqualNode.doStringDouble(truffleString, rightNodeValue__12, stringToDouble_2);
                    }
                }
                if ((state_0 & 0x4000) != 0 && rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__13 = (Boolean)rightNodeValue_;
                    JSStringToNumberNode stringToDouble_3 = this.stringToDouble;
                    if (stringToDouble_3 != null) {
                        return JSEqualNode.doStringBoolean(truffleString, rightNodeValue__13, stringToDouble_3);
                    }
                }
                if ((state_0 & 0x8000) != 0 && rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__14 = (BigInt)rightNodeValue_;
                    return JSEqualNode.doStringBigInt(truffleString, rightNodeValue__14);
                }
            }
            if ((state_0 & 0x10000) != 0 && leftNodeValue_ instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue_;
                if (rightNodeValue_ instanceof TruffleString) {
                    TruffleString rightNodeValue__15 = (TruffleString)rightNodeValue_;
                    return JSEqualNode.doBigIntString(bigInt, rightNodeValue__15);
                }
            }
            if ((state_0 & 0x20000) != 0 && leftNodeValue_ instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__16 = (BigInt)rightNodeValue_;
                    return JSEqualNode.doBooleanBigInt(bl, rightNodeValue__16);
                }
            }
            if ((state_0 & 0x40000) != 0 && leftNodeValue_ instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue_;
                if (rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__17 = (Boolean)rightNodeValue_;
                    return JSEqualNode.doBigIntBoolean(bigInt, rightNodeValue__17);
                }
            }
            if ((state_0 & 0x780000) != 0) {
                OverloadedData overloadedData;
                InteropLibrary interopLibrary;
                InteropLibrary interopLibrary2;
                if ((state_0 & 0x80000) != 0 && JSRuntime.isNullOrUndefined(leftNodeValue_) && JSRuntime.isNullOrUndefined(rightNodeValue_)) {
                    return JSEqualNode.doBothNullOrUndefined(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x100000) != 0 && (interopLibrary2 = this.bInterop) != null && JSRuntime.isNullOrUndefined(leftNodeValue_)) {
                    return JSEqualNode.doLeftNullOrUndefined(leftNodeValue_, rightNodeValue_, interopLibrary2);
                }
                if ((state_0 & 0x200000) != 0 && (interopLibrary = this.aInterop) != null && JSRuntime.isNullOrUndefined(rightNodeValue_)) {
                    return JSEqualNode.doRightNullOrUndefined(leftNodeValue_, rightNodeValue_, interopLibrary);
                }
                if ((state_0 & 0x400000) != 0 && (overloadedData = this.overloaded_cache) != null && (this.hasOverloadedOperators(leftNodeValue_) || this.hasOverloadedOperators(rightNodeValue_))) {
                    OverloadedData node__ = overloadedData;
                    return JSEqualNode.doOverloaded(leftNodeValue_, rightNodeValue_, node__, overloadedData.overloadedOperatorNode_, INLINED_OVERLOADED_TO_BOOLEAN_NODE_);
                }
            }
            if ((state_0 & 0x800000) != 0 && leftNodeValue_ instanceof JSObject) {
                JSObject jSObject = (JSObject)((Object)leftNodeValue_);
                if (rightNodeValue_ instanceof JSDynamicObject) {
                    JSDynamicObject rightNodeValue__18 = (JSDynamicObject)((Object)rightNodeValue_);
                    if (!this.hasOverloadedOperators((Object)jSObject) && !this.hasOverloadedOperators((Object)rightNodeValue__18)) {
                        return JSEqualNode.doJSObject(jSObject, rightNodeValue__18);
                    }
                }
            }
            if ((state_0 & 0x1000000) != 0 && leftNodeValue_ instanceof JSDynamicObject) {
                JSDynamicObject jSDynamicObject = (JSDynamicObject)((Object)leftNodeValue_);
                if (rightNodeValue_ instanceof JSObject) {
                    JSObject rightNodeValue__19 = (JSObject)((Object)rightNodeValue_);
                    if (!this.hasOverloadedOperators((Object)jSDynamicObject) && !this.hasOverloadedOperators((Object)rightNodeValue__19)) {
                        return JSEqualNode.doJSObject(jSDynamicObject, rightNodeValue__19);
                    }
                }
            }
            if ((state_0 & 0x2000000) != 0 && leftNodeValue_ instanceof JSObject) {
                JSEqualNode nestedEqualNode_;
                IsPrimitiveNode isPrimitiveNode_;
                JSToPrimitiveNode toPrimitiveNode_;
                JSObject jSObject = (JSObject)((Object)leftNodeValue_);
                InteropLibrary bInterop_1 = this.bInterop;
                if (bInterop_1 != null && (toPrimitiveNode_ = this.toPrimitiveNode) != null && (isPrimitiveNode_ = this.isPrimitiveNode) != null && (nestedEqualNode_ = this.nestedEqualNode) != null && !this.hasOverloadedOperators((Object)jSObject) && isPrimitiveNode_.executeBoolean(rightNodeValue_)) {
                    return JSEqualNode.doJSObjectVsPrimitive(jSObject, rightNodeValue_, bInterop_1, toPrimitiveNode_, isPrimitiveNode_, nestedEqualNode_);
                }
            }
            if ((state_0 & 0x8000000) != 0 && rightNodeValue_ instanceof JSObject) {
                JSEqualNode nestedEqualNode_1;
                IsPrimitiveNode isPrimitiveNode_1;
                JSToPrimitiveNode toPrimitiveNode_1;
                JSObject jSObject = (JSObject)((Object)rightNodeValue_);
                InteropLibrary aInterop_1 = this.aInterop;
                if (aInterop_1 != null && (toPrimitiveNode_1 = this.toPrimitiveNode) != null && (isPrimitiveNode_1 = this.isPrimitiveNode) != null && (nestedEqualNode_1 = this.nestedEqualNode) != null && !this.hasOverloadedOperators((Object)jSObject) && isPrimitiveNode_1.executeBoolean(leftNodeValue_)) {
                    return JSEqualNode.doJSObjectVsPrimitive(leftNodeValue_, jSObject, aInterop_1, toPrimitiveNode_1, isPrimitiveNode_1, nestedEqualNode_1);
                }
            }
            if ((state_0 & 0x60000000) != 0 && leftNodeValue_ instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue_;
                if ((state_0 & 0x20000000) != 0 && rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__21 = (Integer)rightNodeValue_;
                    return JSEqualNode.doBigIntAndInt(bigInt, rightNodeValue__21);
                }
                if ((state_0 & 0x40000000) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_)) {
                    double rightNodeValue__22 = JSTypesGen.asImplicitDouble((state_1 & 0x3800) >>> 11, rightNodeValue_);
                    return JSEqualNode.doBigIntAndNumber(bigInt, rightNodeValue__22);
                }
            }
            if (((state_0 & Integer.MIN_VALUE) != 0 || (state_1 & 1) != 0) && rightNodeValue_ instanceof BigInt) {
                BigInt bigInt = (BigInt)rightNodeValue_;
                if ((state_0 & Integer.MIN_VALUE) != 0 && leftNodeValue_ instanceof Integer) {
                    int leftNodeValue__14 = (Integer)leftNodeValue_;
                    return JSEqualNode.doIntAndBigInt(leftNodeValue__14, bigInt);
                }
                if ((state_1 & 1) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_)) {
                    double leftNodeValue__15 = JSTypesGen.asImplicitDouble((state_1 & 0x700) >>> 8, leftNodeValue_);
                    return JSEqualNode.doNumberAndBigInt(leftNodeValue__15, bigInt);
                }
            }
            if ((state_1 & 6) != 0 && leftNodeValue_ instanceof Symbol) {
                IsObjectNode isObjectNode_;
                Symbol symbol = (Symbol)leftNodeValue_;
                if ((state_1 & 2) != 0 && rightNodeValue_ instanceof Symbol) {
                    Symbol rightNodeValue__24 = (Symbol)rightNodeValue_;
                    return JSEqualNode.doSymbol(symbol, rightNodeValue__24);
                }
                if ((state_1 & 4) != 0 && (isObjectNode_ = this.isObjectNode) != null && !JSGuards.isSymbol(rightNodeValue_) && !isObjectNode_.executeBoolean(rightNodeValue_)) {
                    return JSEqualNode.doSymbolNotSymbol(symbol, rightNodeValue_, isObjectNode_);
                }
            }
            if ((state_1 & 0xD0) != 0) {
                if ((state_1 & 0x10) != 0 && rightNodeValue_ instanceof Symbol) {
                    Symbol symbol = (Symbol)rightNodeValue_;
                    IsObjectNode isObjectNode_1 = this.isObjectNode;
                    if (isObjectNode_1 != null && !JSGuards.isSymbol(leftNodeValue_) && !isObjectNode_1.executeBoolean(leftNodeValue_)) {
                        return JSEqualNode.doSymbolNotSymbol(leftNodeValue_, symbol, isObjectNode_1);
                    }
                }
                if ((state_1 & 0xC0) != 0) {
                    JSEqualNode nestedEqualNode_2;
                    IsPrimitiveNode isPrimitiveNode_2;
                    JSToPrimitiveNode toPrimitiveNode_2;
                    InteropLibrary bInterop_2;
                    InteropLibrary interopLibrary;
                    if ((state_1 & 0x40) != 0 && (interopLibrary = this.aInterop) != null && (bInterop_2 = this.bInterop) != null && (toPrimitiveNode_2 = this.toPrimitiveNode) != null && (isPrimitiveNode_2 = this.isPrimitiveNode) != null && (nestedEqualNode_2 = this.nestedEqualNode) != null) {
                        boolean isAForeign__ = JSGuards.isForeignObjectOrNumber(leftNodeValue_);
                        boolean isBForeign__ = JSGuards.isForeignObjectOrNumber(rightNodeValue_);
                        if (isAForeign__ || isBForeign__) {
                            return this.doForeign(leftNodeValue_, rightNodeValue_, isAForeign__, isBForeign__, interopLibrary, bInterop_2, toPrimitiveNode_2, isPrimitiveNode_2, nestedEqualNode_2, INLINED_FOREIGN_LONG_TO_BIG_INT_A_, INLINED_FOREIGN_LONG_TO_BIG_INT_B_);
                        }
                    }
                    if ((state_1 & 0x80) != 0 && this.fallbackGuard_(state_0, state_1, leftNodeValue_, rightNodeValue_)) {
                        return JSEqualNode.doFallback(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        TruffleObject rightNodeValue_;
        TruffleObject leftNodeValue_;
        int doubleCast0;
        double leftNodeValue_2;
        int doubleCast02;
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if (leftNodeValue instanceof Integer) {
            int leftNodeValue_3 = (Integer)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                this.state_0_ = state_0 |= 1;
                return JSEqualNode.doInt(leftNodeValue_3, rightNodeValue_2);
            }
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_3 = (Boolean)rightNodeValue;
                this.state_0_ = state_0 |= 2;
                return JSEqualNode.doIntBoolean(leftNodeValue_3, rightNodeValue_3);
            }
        }
        if (leftNodeValue instanceof Long) {
            long leftNodeValue_4 = (Long)leftNodeValue;
            if (rightNodeValue instanceof Long) {
                long rightNodeValue_4 = (Long)rightNodeValue;
                this.state_0_ = state_0 |= 4;
                return JSEqualNode.doLong(leftNodeValue_4, rightNodeValue_4);
            }
        }
        if ((doubleCast02 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
            leftNodeValue_2 = JSTypesGen.asImplicitDouble(doubleCast02, leftNodeValue);
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
            if (doubleCast1 != 0) {
                double rightNodeValue_5 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                state_1 |= doubleCast02 << 8;
                this.state_1_ = state_1 |= doubleCast1 << 11;
                this.state_0_ = state_0 |= 8;
                return JSEqualNode.doDouble(leftNodeValue_2, rightNodeValue_5);
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_5 = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_6 = (BigInt)rightNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return JSEqualNode.doBigInt(leftNodeValue_5, rightNodeValue_6);
            }
        }
        if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
            leftNodeValue_2 = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
            if (rightNodeValue instanceof TruffleString) {
                JSStringToNumberNode stringToDouble_;
                TruffleString rightNodeValue_7 = (TruffleString)rightNodeValue;
                JSStringToNumberNode stringToDouble__shared = this.stringToDouble;
                if (stringToDouble__shared != null) {
                    stringToDouble_ = stringToDouble__shared;
                } else {
                    stringToDouble_ = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
                    if (stringToDouble_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.stringToDouble == null) {
                    VarHandle.storeStoreFence();
                    this.stringToDouble = stringToDouble_;
                }
                this.state_1_ = state_1 |= doubleCast0 << 8;
                this.state_0_ = state_0 |= 0x20;
                return JSEqualNode.doDoubleString(leftNodeValue_2, rightNodeValue_7, stringToDouble_);
            }
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_8 = (Boolean)rightNodeValue;
                this.state_1_ = state_1 |= doubleCast0 << 8;
                this.state_0_ = state_0 |= 0x40;
                return JSEqualNode.doDoubleBoolean(leftNodeValue_2, rightNodeValue_8);
            }
        }
        if (leftNodeValue instanceof Boolean) {
            boolean leftNodeValue_6 = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_9 = (Boolean)rightNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return JSEqualNode.doBoolean(leftNodeValue_6, rightNodeValue_9);
            }
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_10 = (Integer)rightNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return JSEqualNode.doBooleanInt(leftNodeValue_6, rightNodeValue_10);
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
            if (doubleCast1 != 0) {
                double rightNodeValue_11 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                this.state_1_ = state_1 |= doubleCast1 << 11;
                this.state_0_ = state_0 |= 0x200;
                return JSEqualNode.doBooleanDouble(leftNodeValue_6, rightNodeValue_11);
            }
            if (rightNodeValue instanceof TruffleString) {
                JSStringToNumberNode stringToDouble_1;
                TruffleString rightNodeValue_12 = (TruffleString)rightNodeValue;
                JSStringToNumberNode stringToDouble_1_shared = this.stringToDouble;
                if (stringToDouble_1_shared != null) {
                    stringToDouble_1 = stringToDouble_1_shared;
                } else {
                    stringToDouble_1 = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
                    if (stringToDouble_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.stringToDouble == null) {
                    VarHandle.storeStoreFence();
                    this.stringToDouble = stringToDouble_1;
                }
                this.state_0_ = state_0 |= 0x400;
                return JSEqualNode.doBooleanString(leftNodeValue_6, rightNodeValue_12, stringToDouble_1);
            }
        }
        if (leftNodeValue instanceof TruffleString) {
            TruffleString leftNodeValue_7 = (TruffleString)leftNodeValue;
            if (rightNodeValue instanceof TruffleString) {
                TruffleString rightNodeValue_13 = (TruffleString)rightNodeValue;
                if ((state_0 & 0x1000) == 0 && JSGuards.isReferenceEquals(leftNodeValue_7, rightNodeValue_13)) {
                    this.state_0_ = state_0 |= 0x800;
                    return JSEqualNode.doStringIdentity(leftNodeValue_7, rightNodeValue_13);
                }
                TruffleString.EqualNode equalsNode__ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                Objects.requireNonNull(equalsNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_equalsNode_ = equalsNode__;
                state_0 &= 0xFFFFF7FF;
                this.state_0_ = state_0 |= 0x1000;
                return JSEqualNode.doString(leftNodeValue_7, rightNodeValue_13, equalsNode__);
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
            if (doubleCast1 != 0) {
                JSStringToNumberNode stringToDouble_2;
                double rightNodeValue_14 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                JSStringToNumberNode stringToDouble_2_shared = this.stringToDouble;
                if (stringToDouble_2_shared != null) {
                    stringToDouble_2 = stringToDouble_2_shared;
                } else {
                    stringToDouble_2 = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
                    if (stringToDouble_2 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.stringToDouble == null) {
                    VarHandle.storeStoreFence();
                    this.stringToDouble = stringToDouble_2;
                }
                this.state_1_ = state_1 |= doubleCast1 << 11;
                this.state_0_ = state_0 |= 0x2000;
                return JSEqualNode.doStringDouble(leftNodeValue_7, rightNodeValue_14, stringToDouble_2);
            }
            if (rightNodeValue instanceof Boolean) {
                JSStringToNumberNode stringToDouble_3;
                boolean rightNodeValue_15 = (Boolean)rightNodeValue;
                JSStringToNumberNode stringToDouble_3_shared = this.stringToDouble;
                if (stringToDouble_3_shared != null) {
                    stringToDouble_3 = stringToDouble_3_shared;
                } else {
                    stringToDouble_3 = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
                    if (stringToDouble_3 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.stringToDouble == null) {
                    VarHandle.storeStoreFence();
                    this.stringToDouble = stringToDouble_3;
                }
                this.state_0_ = state_0 |= 0x4000;
                return JSEqualNode.doStringBoolean(leftNodeValue_7, rightNodeValue_15, stringToDouble_3);
            }
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_16 = (BigInt)rightNodeValue;
                this.state_0_ = state_0 |= 0x8000;
                return JSEqualNode.doStringBigInt(leftNodeValue_7, rightNodeValue_16);
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_8 = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof TruffleString) {
                TruffleString rightNodeValue_17 = (TruffleString)rightNodeValue;
                this.state_0_ = state_0 |= 0x10000;
                return JSEqualNode.doBigIntString(leftNodeValue_8, rightNodeValue_17);
            }
        }
        if (leftNodeValue instanceof Boolean) {
            boolean leftNodeValue_9 = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_18 = (BigInt)rightNodeValue;
                this.state_0_ = state_0 |= 0x20000;
                return JSEqualNode.doBooleanBigInt(leftNodeValue_9, rightNodeValue_18);
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_10 = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_19 = (Boolean)rightNodeValue;
                this.state_0_ = state_0 |= 0x40000;
                return JSEqualNode.doBigIntBoolean(leftNodeValue_10, rightNodeValue_19);
            }
        }
        if (JSRuntime.isNullOrUndefined(leftNodeValue) && JSRuntime.isNullOrUndefined(rightNodeValue)) {
            this.state_0_ = state_0 |= 0x80000;
            return JSEqualNode.doBothNullOrUndefined(leftNodeValue, rightNodeValue);
        }
        if (JSRuntime.isNullOrUndefined(leftNodeValue)) {
            InteropLibrary bInterop_;
            InteropLibrary bInterop__shared = this.bInterop;
            if (bInterop__shared != null) {
                bInterop_ = bInterop__shared;
            } else {
                bInterop_ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                if (bInterop_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.bInterop == null) {
                VarHandle.storeStoreFence();
                this.bInterop = bInterop_;
            }
            this.state_0_ = state_0 |= 0x100000;
            return JSEqualNode.doLeftNullOrUndefined(leftNodeValue, rightNodeValue, bInterop_);
        }
        if (JSRuntime.isNullOrUndefined(rightNodeValue)) {
            InteropLibrary aInterop_;
            InteropLibrary aInterop__shared = this.aInterop;
            if (aInterop__shared != null) {
                aInterop_ = aInterop__shared;
            } else {
                aInterop_ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                if (aInterop_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.aInterop == null) {
                VarHandle.storeStoreFence();
                this.aInterop = aInterop_;
            }
            this.state_0_ = state_0 |= 0x200000;
            return JSEqualNode.doRightNullOrUndefined(leftNodeValue, rightNodeValue, aInterop_);
        }
        OverloadedData node__ = null;
        if (this.hasOverloadedOperators(leftNodeValue) || this.hasOverloadedOperators(rightNodeValue)) {
            OverloadedData s22_;
            node__ = s22_ = (OverloadedData)this.insert(new OverloadedData());
            JSOverloadedBinaryNode overloadedOperatorNode__ = (JSOverloadedBinaryNode)s22_.insert(JSOverloadedBinaryNode.createHintDefault(JSEqualNode.getOverloadedOperatorName()));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s22_.overloadedOperatorNode_ = overloadedOperatorNode__;
            VarHandle.storeStoreFence();
            this.overloaded_cache = s22_;
            this.state_0_ = state_0 |= 0x400000;
            return JSEqualNode.doOverloaded(leftNodeValue, rightNodeValue, node__, overloadedOperatorNode__, INLINED_OVERLOADED_TO_BOOLEAN_NODE_);
        }
        if (leftNodeValue instanceof JSObject) {
            leftNodeValue_ = (JSObject)((Object)leftNodeValue);
            if (rightNodeValue instanceof JSDynamicObject) {
                JSDynamicObject rightNodeValue_20 = (JSDynamicObject)((Object)rightNodeValue);
                if (!this.hasOverloadedOperators(leftNodeValue_) && !this.hasOverloadedOperators((Object)rightNodeValue_20)) {
                    this.state_0_ = state_0 |= 0x800000;
                    return JSEqualNode.doJSObject((JSObject)leftNodeValue_, rightNodeValue_20);
                }
            }
        }
        if (leftNodeValue instanceof JSDynamicObject) {
            leftNodeValue_ = (JSDynamicObject)((Object)leftNodeValue);
            if (rightNodeValue instanceof JSObject) {
                JSObject rightNodeValue_21 = (JSObject)((Object)rightNodeValue);
                if (!this.hasOverloadedOperators(leftNodeValue_) && !this.hasOverloadedOperators((Object)rightNodeValue_21)) {
                    this.state_0_ = state_0 |= 0x1000000;
                    return JSEqualNode.doJSObject((JSDynamicObject)leftNodeValue_, rightNodeValue_21);
                }
            }
        }
        if (leftNodeValue instanceof JSObject && !this.hasOverloadedOperators(leftNodeValue_ = (JSObject)((Object)leftNodeValue))) {
            IsPrimitiveNode isPrimitiveNode_;
            IsPrimitiveNode isPrimitiveNode__shared = this.isPrimitiveNode;
            if (isPrimitiveNode__shared != null) {
                isPrimitiveNode_ = isPrimitiveNode__shared;
            } else {
                isPrimitiveNode_ = (IsPrimitiveNode)this.insert(IsPrimitiveNode.create());
                if (isPrimitiveNode_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if ((state_0 & 0x4000000) == 0) {
                if (this.isPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.isPrimitiveNode = isPrimitiveNode_;
                }
                state_0 |= 0x4000000;
            }
            if (isPrimitiveNode_.executeBoolean(rightNodeValue)) {
                JSEqualNode nestedEqualNode_;
                JSEqualNode nestedEqualNode__shared;
                JSToPrimitiveNode toPrimitiveNode_;
                JSToPrimitiveNode toPrimitiveNode__shared;
                InteropLibrary bInterop_1;
                InteropLibrary bInterop_1_shared = this.bInterop;
                if (bInterop_1_shared != null) {
                    bInterop_1 = bInterop_1_shared;
                } else {
                    bInterop_1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    if (bInterop_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bInterop == null) {
                    VarHandle.storeStoreFence();
                    this.bInterop = bInterop_1;
                }
                if ((toPrimitiveNode__shared = this.toPrimitiveNode) != null) {
                    toPrimitiveNode_ = toPrimitiveNode__shared;
                } else {
                    toPrimitiveNode_ = (JSToPrimitiveNode)this.insert(JSToPrimitiveNode.createHintDefault());
                    if (toPrimitiveNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.toPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.toPrimitiveNode = toPrimitiveNode_;
                }
                if (this.isPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.isPrimitiveNode = isPrimitiveNode_;
                }
                if ((nestedEqualNode__shared = this.nestedEqualNode) != null) {
                    nestedEqualNode_ = nestedEqualNode__shared;
                } else {
                    nestedEqualNode_ = (JSEqualNode)this.insert(JSEqualNode.create());
                    if (nestedEqualNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.nestedEqualNode == null) {
                    VarHandle.storeStoreFence();
                    this.nestedEqualNode = nestedEqualNode_;
                }
                this.state_0_ = state_0 |= 0x2000000;
                return JSEqualNode.doJSObjectVsPrimitive((JSObject)leftNodeValue_, rightNodeValue, bInterop_1, toPrimitiveNode_, isPrimitiveNode_, nestedEqualNode_);
            }
        }
        if (rightNodeValue instanceof JSObject && !this.hasOverloadedOperators(rightNodeValue_ = (JSObject)((Object)rightNodeValue))) {
            IsPrimitiveNode isPrimitiveNode_1;
            IsPrimitiveNode isPrimitiveNode_1_shared = this.isPrimitiveNode;
            if (isPrimitiveNode_1_shared != null) {
                isPrimitiveNode_1 = isPrimitiveNode_1_shared;
            } else {
                isPrimitiveNode_1 = (IsPrimitiveNode)this.insert(IsPrimitiveNode.create());
                if (isPrimitiveNode_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if ((state_0 & 0x10000000) == 0) {
                if (this.isPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.isPrimitiveNode = isPrimitiveNode_1;
                }
                state_0 |= 0x10000000;
            }
            if (isPrimitiveNode_1.executeBoolean(leftNodeValue)) {
                JSEqualNode nestedEqualNode_1;
                JSEqualNode nestedEqualNode_1_shared;
                JSToPrimitiveNode toPrimitiveNode_1;
                JSToPrimitiveNode toPrimitiveNode_1_shared;
                InteropLibrary aInterop_1;
                InteropLibrary aInterop_1_shared = this.aInterop;
                if (aInterop_1_shared != null) {
                    aInterop_1 = aInterop_1_shared;
                } else {
                    aInterop_1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    if (aInterop_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.aInterop == null) {
                    VarHandle.storeStoreFence();
                    this.aInterop = aInterop_1;
                }
                if ((toPrimitiveNode_1_shared = this.toPrimitiveNode) != null) {
                    toPrimitiveNode_1 = toPrimitiveNode_1_shared;
                } else {
                    toPrimitiveNode_1 = (JSToPrimitiveNode)this.insert(JSToPrimitiveNode.createHintDefault());
                    if (toPrimitiveNode_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.toPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.toPrimitiveNode = toPrimitiveNode_1;
                }
                if (this.isPrimitiveNode == null) {
                    VarHandle.storeStoreFence();
                    this.isPrimitiveNode = isPrimitiveNode_1;
                }
                if ((nestedEqualNode_1_shared = this.nestedEqualNode) != null) {
                    nestedEqualNode_1 = nestedEqualNode_1_shared;
                } else {
                    nestedEqualNode_1 = (JSEqualNode)this.insert(JSEqualNode.create());
                    if (nestedEqualNode_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.nestedEqualNode == null) {
                    VarHandle.storeStoreFence();
                    this.nestedEqualNode = nestedEqualNode_1;
                }
                this.state_0_ = state_0 |= 0x8000000;
                return JSEqualNode.doJSObjectVsPrimitive(leftNodeValue, (JSObject)rightNodeValue_, aInterop_1, toPrimitiveNode_1, isPrimitiveNode_1, nestedEqualNode_1);
            }
        }
        if (leftNodeValue instanceof BigInt) {
            leftNodeValue_ = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_22 = (Integer)rightNodeValue;
                this.state_0_ = state_0 |= 0x20000000;
                return JSEqualNode.doBigIntAndInt((BigInt)leftNodeValue_, rightNodeValue_22);
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
            if (doubleCast1 != 0) {
                double rightNodeValue_23 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                this.state_1_ = state_1 |= doubleCast1 << 11;
                this.state_0_ = state_0 |= 0x40000000;
                return JSEqualNode.doBigIntAndNumber((BigInt)leftNodeValue_, rightNodeValue_23);
            }
        }
        if (rightNodeValue instanceof BigInt) {
            rightNodeValue_ = (BigInt)rightNodeValue;
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_11 = (Integer)leftNodeValue;
                this.state_0_ = state_0 |= Integer.MIN_VALUE;
                return JSEqualNode.doIntAndBigInt(leftNodeValue_11, (BigInt)rightNodeValue_);
            }
            int doubleCast03 = JSTypesGen.specializeImplicitDouble(leftNodeValue);
            if (doubleCast03 != 0) {
                double leftNodeValue_12 = JSTypesGen.asImplicitDouble(doubleCast03, leftNodeValue);
                state_1 |= doubleCast03 << 8;
                this.state_1_ = state_1 |= 1;
                return JSEqualNode.doNumberAndBigInt(leftNodeValue_12, (BigInt)rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof Symbol) {
            leftNodeValue_ = (Symbol)leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                Symbol rightNodeValue_24 = (Symbol)rightNodeValue;
                this.state_1_ = state_1 |= 2;
                return JSEqualNode.doSymbol((Symbol)leftNodeValue_, rightNodeValue_24);
            }
            if (!JSGuards.isSymbol(rightNodeValue)) {
                IsObjectNode isObjectNode_;
                IsObjectNode isObjectNode__shared = this.isObjectNode;
                if (isObjectNode__shared != null) {
                    isObjectNode_ = isObjectNode__shared;
                } else {
                    isObjectNode_ = (IsObjectNode)this.insert(IsObjectNode.create());
                    if (isObjectNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if ((state_1 & 8) == 0) {
                    if (this.isObjectNode == null) {
                        VarHandle.storeStoreFence();
                        this.isObjectNode = isObjectNode_;
                    }
                    state_1 |= 8;
                }
                if (!isObjectNode_.executeBoolean(rightNodeValue)) {
                    if (this.isObjectNode == null) {
                        VarHandle.storeStoreFence();
                        this.isObjectNode = isObjectNode_;
                    }
                    this.state_1_ = state_1 |= 4;
                    return JSEqualNode.doSymbolNotSymbol((Symbol)leftNodeValue_, rightNodeValue, isObjectNode_);
                }
            }
        }
        if (rightNodeValue instanceof Symbol) {
            rightNodeValue_ = (Symbol)rightNodeValue;
            if (!JSGuards.isSymbol(leftNodeValue)) {
                IsObjectNode isObjectNode_1;
                IsObjectNode isObjectNode_1_shared = this.isObjectNode;
                if (isObjectNode_1_shared != null) {
                    isObjectNode_1 = isObjectNode_1_shared;
                } else {
                    isObjectNode_1 = (IsObjectNode)this.insert(IsObjectNode.create());
                    if (isObjectNode_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if ((state_1 & 0x20) == 0) {
                    if (this.isObjectNode == null) {
                        VarHandle.storeStoreFence();
                        this.isObjectNode = isObjectNode_1;
                    }
                    state_1 |= 0x20;
                }
                if (!isObjectNode_1.executeBoolean(leftNodeValue)) {
                    if (this.isObjectNode == null) {
                        VarHandle.storeStoreFence();
                        this.isObjectNode = isObjectNode_1;
                    }
                    this.state_1_ = state_1 |= 0x10;
                    return JSEqualNode.doSymbolNotSymbol(leftNodeValue, (Symbol)rightNodeValue_, isObjectNode_1);
                }
            }
        }
        boolean isBForeign__ = false;
        boolean isAForeign__ = false;
        isAForeign__ = JSGuards.isForeignObjectOrNumber(leftNodeValue);
        isBForeign__ = JSGuards.isForeignObjectOrNumber(rightNodeValue);
        if (isAForeign__ || isBForeign__) {
            JSEqualNode nestedEqualNode_2;
            JSEqualNode nestedEqualNode_2_shared;
            IsPrimitiveNode isPrimitiveNode_2;
            IsPrimitiveNode isPrimitiveNode_2_shared;
            JSToPrimitiveNode toPrimitiveNode_2;
            JSToPrimitiveNode toPrimitiveNode_2_shared;
            InteropLibrary bInterop_2;
            InteropLibrary bInterop_2_shared;
            InteropLibrary aInterop_2;
            InteropLibrary aInterop_2_shared = this.aInterop;
            if (aInterop_2_shared != null) {
                aInterop_2 = aInterop_2_shared;
            } else {
                aInterop_2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                if (aInterop_2 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.aInterop == null) {
                VarHandle.storeStoreFence();
                this.aInterop = aInterop_2;
            }
            if ((bInterop_2_shared = this.bInterop) != null) {
                bInterop_2 = bInterop_2_shared;
            } else {
                bInterop_2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                if (bInterop_2 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.bInterop == null) {
                VarHandle.storeStoreFence();
                this.bInterop = bInterop_2;
            }
            if ((toPrimitiveNode_2_shared = this.toPrimitiveNode) != null) {
                toPrimitiveNode_2 = toPrimitiveNode_2_shared;
            } else {
                toPrimitiveNode_2 = (JSToPrimitiveNode)this.insert(JSToPrimitiveNode.createHintDefault());
                if (toPrimitiveNode_2 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toPrimitiveNode == null) {
                VarHandle.storeStoreFence();
                this.toPrimitiveNode = toPrimitiveNode_2;
            }
            if ((isPrimitiveNode_2_shared = this.isPrimitiveNode) != null) {
                isPrimitiveNode_2 = isPrimitiveNode_2_shared;
            } else {
                isPrimitiveNode_2 = (IsPrimitiveNode)this.insert(IsPrimitiveNode.create());
                if (isPrimitiveNode_2 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.isPrimitiveNode == null) {
                VarHandle.storeStoreFence();
                this.isPrimitiveNode = isPrimitiveNode_2;
            }
            if ((nestedEqualNode_2_shared = this.nestedEqualNode) != null) {
                nestedEqualNode_2 = nestedEqualNode_2_shared;
            } else {
                nestedEqualNode_2 = (JSEqualNode)this.insert(JSEqualNode.create());
                if (nestedEqualNode_2 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.nestedEqualNode == null) {
                VarHandle.storeStoreFence();
                this.nestedEqualNode = nestedEqualNode_2;
            }
            this.state_1_ = state_1 |= 0x40;
            return this.doForeign(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, aInterop_2, bInterop_2, toPrimitiveNode_2, isPrimitiveNode_2, nestedEqualNode_2, INLINED_FOREIGN_LONG_TO_BIG_INT_A_, INLINED_FOREIGN_LONG_TO_BIG_INT_B_);
        }
        this.state_1_ = state_1 |= 0x80;
        return JSEqualNode.doFallback(leftNodeValue, rightNodeValue);
    }

    @NeverDefault
    public static JSEqualNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSEqualNodeGen(left, right);
    }

    @GeneratedBy(value=JSEqualNode.class)
    @DenyReplace
    private static final class OverloadedData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int overloaded_state_0_;
        @Node.Child
        JSOverloadedBinaryNode overloadedOperatorNode_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node overloaded_toBooleanNode__field1_;

        OverloadedData() {
        }

        private static MethodHandles.Lookup lookup_() {
            return MethodHandles.lookup();
        }
    }
}

