/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.Locale;

public abstract class ToTemporalCalendarSlotValueNode
extends JavaScriptBaseNode {
    private final TruffleString defaultValue;

    protected ToTemporalCalendarSlotValueNode(TruffleString defaultValue) {
        this.defaultValue = defaultValue;
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode create() {
        return ToTemporalCalendarSlotValueNode.createWithDefault(null);
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode createWithISO8601() {
        return ToTemporalCalendarSlotValueNode.createWithDefault(TemporalConstants.ISO8601);
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode createWithDefault(TruffleString defaultValue) {
        return ToTemporalCalendarSlotValueNodeGen.create(defaultValue);
    }

    public abstract TruffleString execute(Object var1);

    @Specialization
    public TruffleString toTemporalCalendarSlotValue(Object temporalCalendarLike, @Cached IsObjectNode isObjectNode, @Cached TruffleString.FromJavaStringNode fromJavaString, @Cached TruffleString.ToJavaStringNode toJavaString) {
        if (this.defaultValue != null && temporalCalendarLike == Undefined.instance) {
            return this.defaultValue;
        }
        if (isObjectNode.executeBoolean(temporalCalendarLike)) {
            if (temporalCalendarLike instanceof JSTemporalCalendarHolder) {
                JSTemporalCalendarHolder calendarHolder = (JSTemporalCalendarHolder)((Object)temporalCalendarLike);
                return calendarHolder.getCalendar();
            }
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
        if (!(temporalCalendarLike instanceof TruffleString)) {
            throw Errors.createTypeErrorNotAString(temporalCalendarLike);
        }
        TruffleString identifier = TemporalUtil.parseTemporalCalendarString((TruffleString)temporalCalendarLike);
        if (!TemporalUtil.isBuiltinCalendar(identifier)) {
            throw TemporalErrors.createRangeErrorCalendarUnknown();
        }
        return fromJavaString.execute(Strings.javaStringToLowerCase(toJavaString.execute((AbstractTruffleString)identifier), Locale.US), TruffleString.Encoding.UTF_16);
    }
}

