/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.hikaricp.internal.HikariConfigurationUtil;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private HikariConfig hikariConfig = null;
    private HikariDataSource hikariDataSource = null;

    public void configure(Map<String, Object> configuration) throws HibernateException {
        try {
            ConnectionInfoLogger.CONNECTION_INFO_LOGGER.configureConnectionPool("HikariCP");
            this.hikariConfig = HikariConfigurationUtil.loadConfiguration(configuration);
            this.hikariDataSource = new HikariDataSource(this.hikariConfig);
        }
        catch (Exception e) {
            ConnectionInfoLogger.CONNECTION_INFO_LOGGER.unableToInstantiateConnectionPool(e);
            throw new ConnectionProviderConfigurationException("Could not configure HikariCP: " + e.getMessage(), (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource != null ? this.hikariDataSource.getConnection() : null;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        DatabaseConnectionInfoImpl databaseConnectionInfoImpl;
        block9: {
            Connection connection = this.hikariDataSource.getConnection();
            try {
                DatabaseConnectionInfoImpl info = new DatabaseConnectionInfoImpl(HikariCPConnectionProvider.class, this.hikariConfig.getJdbcUrl(), StringHelper.isBlank((String)this.hikariConfig.getDriverClassName()) ? DatabaseConnectionInfoImpl.getDriverName((Connection)connection) : this.hikariConfig.getDriverClassName(), dialect.getClass(), dialect.getVersion(), DatabaseConnectionInfoImpl.hasSchema((Connection)connection), DatabaseConnectionInfoImpl.hasCatalog((Connection)connection), this.hikariConfig.getSchema() != null ? this.hikariConfig.getSchema() : DatabaseConnectionInfoImpl.getSchema((Connection)connection), this.hikariConfig.getCatalog() != null ? this.hikariConfig.getCatalog() : DatabaseConnectionInfoImpl.getCatalog((Connection)connection), Boolean.toString(this.hikariConfig.isAutoCommit()), this.hikariConfig.getTransactionIsolation() != null ? this.hikariConfig.getTransactionIsolation() : ConnectionProviderInitiator.toIsolationNiceName((Integer)DatabaseConnectionInfoImpl.getIsolation((Connection)connection)), Integer.valueOf(this.hikariConfig.getMinimumIdle()), Integer.valueOf(this.hikariConfig.getMaximumPoolSize()), DatabaseConnectionInfoImpl.getFetchSize((Connection)connection));
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
                databaseConnectionInfoImpl = info;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JDBCConnectionException("Could not create connection", e);
                }
            }
            connection.close();
        }
        return databaseConnectionInfoImpl;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return unwrapType.isAssignableFrom(HikariCPConnectionProvider.class) || unwrapType.isAssignableFrom(HikariDataSource.class) || unwrapType.isAssignableFrom(HikariConfig.class);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (unwrapType.isAssignableFrom(HikariCPConnectionProvider.class)) {
            return (T)this;
        }
        if (unwrapType.isAssignableFrom(HikariDataSource.class)) {
            return (T)this.hikariDataSource;
        }
        if (unwrapType.isAssignableFrom(HikariConfig.class)) {
            return (T)this.hikariConfig;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.hikariDataSource != null) {
            ConnectionInfoLogger.CONNECTION_INFO_LOGGER.cleaningUpConnectionPool("HikariCP");
            this.hikariDataSource.close();
        }
    }
}

