/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6401)
public class CheckRemoteStoreTask
implements Function<EmbeddedCacheManager, Boolean> {
    @ProtoField(value=1)
    final String cacheName;

    @ProtoFactory
    public CheckRemoteStoreTask(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Boolean apply(EmbeddedCacheManager embeddedCacheManager) {
        PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf((Cache)embeddedCacheManager.getCache(this.cacheName), PersistenceManager.class);
        try {
            ArrayList stores = new ArrayList(persistenceManager.getStores(RemoteStore.class));
            return stores.size() == 1;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

