/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.telemetry.impl;

import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.telemetry.impl.NoOpTelemetryService;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryServiceImpl;

public class TelemetryServiceFactory {
    private static final Log log = LogFactory.getLog(TelemetryService.class);
    public static final TelemetryService INSTANCE = TelemetryServiceFactory.telemetryService();

    public static TelemetryService telemetryService(boolean propagationEnabled) {
        if (INSTANCE == null) {
            return NoOpTelemetryService.INSTANCE;
        }
        if (propagationEnabled) {
            log.openTelemetryPropagationEnabled();
            return INSTANCE;
        }
        log.openTelemetryPropagationDisabled();
        return NoOpTelemetryService.INSTANCE;
    }

    private static TelemetryService telemetryService() {
        try {
            Class.forName("io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator", false, TelemetryService.class.getClassLoader());
            return TelemetryServiceImpl.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            log.noOpenTelemetryAPI();
        }
        catch (Throwable e) {
            log.errorCreatingPropagationContext(e);
        }
        return null;
    }
}

