/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.logging.Log;

@Listener(sync=false)
class CrashedMemberDetectorListener {
    private final Cache<Address, ServerAddress> addressCache;
    private static final Log log = Log.getLog(CrashedMemberDetectorListener.class);

    CrashedMemberDetectorListener(Cache<Address, ServerAddress> cache, HotRodServer server) {
        this.addressCache = cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
    }

    @ViewChanged
    public void handleViewChange(ViewChangedEvent e) {
        this.detectCrashedMember(e);
    }

    void detectCrashedMember(ViewChangedEvent e) {
        try {
            if (this.addressCache.getStatus().allowInvocations()) {
                List<Address> goneMembers = e.getOldMembers().stream().filter(o -> !e.getNewMembers().contains(o)).collect(Collectors.toList());
                log.tracef("View change received: %s, removing members %s", e, goneMembers);
                goneMembers.forEach(arg_0 -> this.addressCache.remove(arg_0));
            }
        }
        catch (Throwable t) {
            log.errorDetectingCrashedMember(t);
        }
    }
}

