/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.context.Flag;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.telemetry.InfinispanSpanContext;

public class HotRodHeader
implements InfinispanSpanContext {
    private static final Log log = Log.getLog(HotRodHeader.class);
    HotRodOperation op;
    byte version;
    long messageId;
    String cacheName;
    int flag;
    short clientIntel;
    int topologyId;
    MediaType keyType;
    MediaType valueType;
    Map<String, byte[]> otherParams;

    public HotRodHeader(HotRodHeader header) {
        this(header.op, header.version, header.messageId, header.cacheName, header.flag, header.clientIntel, header.topologyId, header.keyType, header.valueType, header.otherParams);
    }

    public HotRodHeader(HotRodOperation op, byte version, long messageId, String cacheName, int flag, short clientIntel, int topologyId, MediaType keyType, MediaType valueType, Map<String, byte[]> otherParams) {
        this.op = op;
        this.version = version;
        this.messageId = messageId;
        this.cacheName = cacheName;
        this.flag = flag;
        this.clientIntel = clientIntel;
        this.topologyId = topologyId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.otherParams = otherParams;
    }

    public boolean hasFlag(ProtocolFlag f) {
        return (this.flag & f.getValue()) == f.getValue();
    }

    public HotRodOperation getOp() {
        return this.op;
    }

    public MediaType getKeyMediaType() {
        return this.keyType == null ? MediaType.APPLICATION_UNKNOWN : this.keyType;
    }

    public MediaType getValueMediaType() {
        return this.valueType == null ? MediaType.APPLICATION_UNKNOWN : this.valueType;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public int getFlag() {
        return this.flag;
    }

    public short getClientIntel() {
        return this.clientIntel;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public VersionedEncoder encoder() {
        return HotRodVersion.getEncoder(this.version);
    }

    boolean isSkipCacheLoad() {
        if (this.version < 20) {
            return false;
        }
        return this.op.canSkipCacheLoading() && this.hasFlag(ProtocolFlag.SkipCacheLoader);
    }

    boolean isSkipIndexing() {
        if (this.version < 20) {
            return false;
        }
        return this.op.canSkipIndexing() && this.hasFlag(ProtocolFlag.SkipIndexing);
    }

    AdvancedCache<byte[], byte[]> getOptimizedCache(AdvancedCache<byte[], byte[]> c, boolean transactional, boolean clustered) {
        if (clustered && !transactional && this.op.isConditional()) {
            log.warnConditionalOperationNonTransactional(this.op.toString());
        }
        if (this.flag == 0) {
            if (this.op.isNotConditionalAndCanReturnPrevious()) {
                return c.withFlags(Flag.IGNORE_RETURN_VALUES);
            }
            return c;
        }
        return this.getOptimizedCacheWithFlags(c, transactional, clustered);
    }

    private AdvancedCache<byte[], byte[]> getOptimizedCacheWithFlags(AdvancedCache<byte[], byte[]> c, boolean transactional, boolean clustered) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (this.hasFlag(ProtocolFlag.SkipListenerNotification)) {
            flags.add(Flag.SKIP_LISTENER_NOTIFICATION);
        }
        if (this.version < 20) {
            if (!this.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
                switch (this.op) {
                    case PUT: 
                    case PUT_IF_ABSENT: {
                        flags.add(Flag.IGNORE_RETURN_VALUES);
                    }
                }
            }
            return c.withFlags(flags);
        }
        if (this.op.canSkipCacheLoading() && this.hasFlag(ProtocolFlag.SkipCacheLoader)) {
            flags.add(Flag.SKIP_CACHE_LOAD);
        }
        if (this.op.canSkipIndexing() && this.hasFlag(ProtocolFlag.SkipIndexing)) {
            flags.add(Flag.SKIP_INDEXING);
        }
        if (!this.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
            if (this.op.isNotConditionalAndCanReturnPrevious()) {
                flags.add(Flag.IGNORE_RETURN_VALUES);
            }
        } else if (!transactional && this.op.canReturnPreviousValue()) {
            log.warnForceReturnPreviousNonTransactional(this.op.toString());
        }
        return c.withFlags(flags);
    }

    public String toString() {
        return "HotRodHeader{op=" + String.valueOf((Object)this.op) + ", version=" + this.version + ", messageId=" + this.messageId + ", cacheName='" + this.cacheName + "', flag=" + this.flag + ", clientIntel=" + this.clientIntel + ", topologyId=" + this.topologyId + ", keyType=" + String.valueOf(this.keyType) + ", valueType=" + String.valueOf(this.valueType) + ", otherParams=" + String.valueOf(this.otherParams) + "}";
    }

    public Iterable<String> keys() {
        return this.otherParams == null ? Collections.emptyList() : this.otherParams.keySet();
    }

    public String getKey(String key) {
        return Optional.ofNullable(this.otherParams).map(stringMap -> (byte[])stringMap.get(key)).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).orElse(null);
    }
}

