/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.ServerAddress;

@ProtoTypeId(value=6610)
public class MultiHomedServerAddress
implements ServerAddress {
    @ProtoField(value=1)
    final int port;
    @ProtoField(value=2)
    final List<InetAddressWithNetMask> addresses;
    static byte[] netMaskByPrefix = new byte[]{-128, -64, -32, -16, -8, -4, -2};

    public MultiHomedServerAddress(int port, boolean networkPrefixOverride) {
        this.port = port;
        this.addresses = new ArrayList<InetAddressWithNetMask>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                for (InterfaceAddress address : intf.getInterfaceAddresses()) {
                    this.addresses.add(new InetAddressWithNetMask(address.getAddress(), address.getNetworkPrefixLength(), networkPrefixOverride));
                }
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    @ProtoFactory
    MultiHomedServerAddress(List<InetAddressWithNetMask> addresses, int port) {
        this.addresses = addresses;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiHomedServerAddress that = (MultiHomedServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.addresses.equals(that.addresses);
    }

    public int hashCode() {
        int result = this.addresses.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "MultiHomedServerAddress{port=" + this.port + ", addresses=" + String.valueOf(this.addresses) + "}";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost(InetAddress localAddress) {
        for (InetAddressWithNetMask address : this.addresses) {
            if (!MultiHomedServerAddress.inetAddressMatchesInterfaceAddress(localAddress.getAddress(), address.address.getAddress(), address.prefixLength)) continue;
            if (HotRodServer.log.isDebugEnabled()) {
                HotRodServer.log.debugf("Matched incoming address '%s' with '%s'", localAddress, address);
            }
            return address.address.getHostAddress();
        }
        throw new IllegalArgumentException("No interface address matching '" + String.valueOf(localAddress) + "' in " + String.valueOf(this));
    }

    public static boolean inetAddressMatchesInterfaceAddress(byte[] inetAddress, byte[] interfaceAddress, int prefixLength) {
        if (HotRodServer.log.isDebugEnabled()) {
            HotRodServer.log.debugf("Matching incoming address '%s' with '%s'/%d", inetAddress, interfaceAddress, prefixLength);
        }
        if (inetAddress.length != interfaceAddress.length) {
            return false;
        }
        for (int i = 0; i < inetAddress.length; ++i) {
            byte a = inetAddress[i];
            byte b = interfaceAddress[i];
            if (prefixLength >= 8) {
                if (a != b) {
                    return false;
                }
                prefixLength -= 8;
                continue;
            }
            if (prefixLength <= 0) continue;
            byte mask = netMaskByPrefix[prefixLength - 1];
            if ((a & mask) != (b & mask)) {
                return false;
            }
            prefixLength = 0;
        }
        return true;
    }

    @ProtoTypeId(value=6611)
    public static class InetAddressWithNetMask {
        public static final InetAddressWithNetMask RFC1918_CIDR_10 = new InetAddressWithNetMask(new byte[]{10, 0, 0, 0}, 8);
        public static final InetAddressWithNetMask RFC1918_CIDR_172 = new InetAddressWithNetMask(new byte[]{-84, 16, 0, 0}, 12);
        public static final InetAddressWithNetMask RFC1918_CIDR_192 = new InetAddressWithNetMask(new byte[]{-64, -88, 0, 0}, 16);
        public static final InetAddressWithNetMask RFC3927_LINK_LOCAL = new InetAddressWithNetMask(new byte[]{-87, -2, 0, 0}, 16);
        public static final InetAddressWithNetMask RFC1112_RESERVED = new InetAddressWithNetMask(new byte[]{-16, 0, 0, 0}, 4);
        public static final InetAddressWithNetMask RFC6598_SHARED_SPACE = new InetAddressWithNetMask(new byte[]{100, 64, 0, 0}, 10);
        public static final InetAddressWithNetMask RFC4193_ULA = new InetAddressWithNetMask(new byte[]{-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7);
        public static final InetAddressWithNetMask RFC4193_LINK_LOCAL = new InetAddressWithNetMask(new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10);
        public static final List<InetAddressWithNetMask> PRIVATE_NETWORKS = Arrays.asList(RFC1918_CIDR_10, RFC1918_CIDR_172, RFC1918_CIDR_192, RFC3927_LINK_LOCAL, RFC1112_RESERVED, RFC6598_SHARED_SPACE, RFC4193_ULA, RFC4193_LINK_LOCAL);
        final InetAddress address;
        final short prefixLength;

        public InetAddressWithNetMask(InetAddress address, short prefixLength, boolean networkPrefixOverride) {
            this.address = address;
            short prefix = prefixLength;
            if (networkPrefixOverride) {
                byte[] a = address.getAddress();
                for (InetAddressWithNetMask net : PRIVATE_NETWORKS) {
                    if (!MultiHomedServerAddress.inetAddressMatchesInterfaceAddress(a, net.address.getAddress(), net.prefixLength)) continue;
                    prefix = net.prefixLength;
                    break;
                }
            }
            this.prefixLength = prefix;
        }

        private InetAddressWithNetMask(byte[] address, short prefixLength) {
            try {
                this.address = InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            this.prefixLength = prefixLength;
        }

        public InetAddressWithNetMask(InetAddress address, short prefixLength) {
            this.address = address;
            this.prefixLength = prefixLength;
        }

        @ProtoFactory
        static InetAddressWithNetMask protoFactory(String hostAddress, short prefixLength) {
            try {
                int scopeSeparator = hostAddress.lastIndexOf(37);
                return new InetAddressWithNetMask(InetAddress.getByName(scopeSeparator < 0 ? hostAddress : hostAddress.substring(0, scopeSeparator)), prefixLength);
            }
            catch (UnknownHostException e) {
                throw new MarshallingException(String.format("Unable to resolve InetAddress by name '%s'", hostAddress), (Throwable)e);
            }
        }

        @ProtoField(value=1)
        String getHostAddress() {
            return this.address.getHostAddress();
        }

        @ProtoField(value=2)
        short getPrefixLength() {
            return this.prefixLength;
        }

        public String toString() {
            return String.valueOf(this.address) + "/" + this.prefixLength;
        }
    }
}

