/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.commons.util.ByRef;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.counter.listener.ClientCounterEvent;
import org.infinispan.server.hotrod.logging.Log;

class ClientNotificationManager {
    private static final Log log = Log.getLog(ClientNotificationManager.class);
    private final Map<String, Handle<Listener>> counterListener;
    private final CounterManager counterManager;
    private final Channel channel;
    private final VersionedEncoder encoder;
    private final Queue<ClientCounterEvent> eventQueue;
    private final byte[] listenerId;

    ClientNotificationManager(byte[] listenerId, CounterManager counterManager, Channel channel, VersionedEncoder encoder) {
        this.listenerId = listenerId;
        this.counterManager = counterManager;
        this.channel = channel;
        this.encoder = encoder;
        this.counterListener = new ConcurrentHashMap<String, Handle<Listener>>();
        this.eventQueue = new ConcurrentLinkedQueue<ClientCounterEvent>();
    }

    boolean addCounterListener(byte version, String counterName) {
        if (log.isTraceEnabled()) {
            log.tracef("Add listener for counter '%s'", counterName);
        }
        ByRef status = new ByRef((Object)true);
        this.counterListener.computeIfAbsent(counterName, name -> this.createListener(version, (String)name, (ByRef<Boolean>)status));
        return (Boolean)status.get();
    }

    void removeCounterListener(String counterName) {
        if (log.isTraceEnabled()) {
            log.tracef("Remove listener for counter '%s'", counterName);
        }
        this.counterListener.computeIfPresent(counterName, (name, handle) -> {
            handle.remove();
            return null;
        });
    }

    boolean isEmpty() {
        return this.counterListener.isEmpty();
    }

    void removeAll() {
        if (log.isTraceEnabled()) {
            log.trace("Remove all listeners");
        }
        this.counterListener.values().forEach(Handle::remove);
        this.counterListener.clear();
    }

    void channelActive(Channel otherChannel) {
        boolean sameChannel;
        boolean bl = sameChannel = this.channel == otherChannel;
        if (log.isTraceEnabled()) {
            log.tracef("Channel active! is same channel? %s", sameChannel);
        }
        if (sameChannel) {
            this.sendEvents();
        }
    }

    private void sendEvents() {
        ClientCounterEvent event;
        if (log.isTraceEnabled()) {
            log.tracef("Send events! is writable? %s", this.channel.isWritable());
        }
        boolean written = false;
        while (this.channel.isWritable() && (event = this.eventQueue.poll()) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Sending event %s", event);
            }
            ByteBuf buf = this.channel.alloc().ioBuffer();
            this.encoder.writeCounterEvent(event, buf);
            this.channel.write((Object)buf);
            written = true;
        }
        if (written) {
            this.channel.flush();
        }
    }

    private Handle<Listener> createListener(byte version, String counterName, ByRef<Boolean> status) {
        CounterConfiguration configuration = this.counterManager.getConfiguration(counterName);
        if (configuration == null) {
            status.set((Object)false);
            return null;
        }
        Handle handle = configuration.type() == CounterType.WEAK ? this.counterManager.getWeakCounter(counterName).addListener((CounterListener)new Listener(counterName, version)) : this.counterManager.getStrongCounter(counterName).addListener((CounterListener)new Listener(counterName, version));
        status.set((Object)true);
        return handle;
    }

    private void trySendEvents() {
        boolean writable = this.channel.isWritable();
        if (log.isTraceEnabled()) {
            log.tracef("Try to send events after notification. is writable? %s", writable);
        }
        if (this.channel.isWritable()) {
            this.channel.eventLoop().execute(this::sendEvents);
        }
    }

    private class Listener
    implements CounterListener {
        private final String counterName;
        private final byte version;

        private Listener(String counterName, byte version) {
            this.counterName = counterName;
            this.version = version;
        }

        public void onUpdate(CounterEvent entry) {
            if (log.isTraceEnabled()) {
                log.tracef("Event received! %s", entry);
            }
            ClientNotificationManager.this.eventQueue.add(new ClientCounterEvent(ClientNotificationManager.this.listenerId, this.version, this.counterName, entry));
            ClientNotificationManager.this.trySendEvents();
        }
    }
}

