/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

@ProtoTypeId(value=6607)
public class SetDecisionFunction
extends TxFunction {
    @ProtoField(value=1)
    final boolean commit;

    @ProtoFactory
    public SetDecisionFunction(boolean commit) {
        this.commit = commit;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            return this.commit ? this.advanceToCommit(view) : this.advanceToRollback(view);
        }
        return Status.NO_TRANSACTION.value;
    }

    private byte advanceToRollback(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        TxState state = (TxState)view.get();
        Status prevState = state.getStatus();
        switch (prevState) {
            case ACTIVE: 
            case PREPARED: 
            case PREPARING: 
            case MARK_ROLLBACK: {
                view.set((Object)state.setStatus(Status.MARK_ROLLBACK, true, this.timeService), new MetaParam.Writable[0]);
                return Status.OK.value;
            }
        }
        return prevState.value;
    }

    private byte advanceToCommit(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        TxState state = (TxState)view.get();
        Status prevState = state.getStatus();
        switch (prevState) {
            case PREPARED: 
            case PREPARING: 
            case MARK_COMMIT: {
                view.set((Object)state.setStatus(Status.MARK_COMMIT, false, this.timeService), new MetaParam.Writable[0]);
                return Status.OK.value;
            }
        }
        return prevState.value;
    }

    public String toString() {
        return "SetDecisionFunction{commit=" + this.commit + "}";
    }
}

