/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.commons.encryption;

import org.jahia.commons.encryption.PBKDF2Digester;
import org.jasypt.digest.PooledStringDigester;
import org.jasypt.digest.StringDigester;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public final class EncryptionUtils {
    private static StringDigester getSHA1DigesterLegacy() {
        return SHA1DigesterHolder.INSTANCE;
    }

    private static StringEncryptor getStringEncryptor() {
        return StringEncryptorHolder.INSTANCE;
    }

    public static String passwordBaseDecrypt(String encrypted) {
        return EncryptionUtils.getStringEncryptor().decrypt(encrypted);
    }

    public static String passwordBaseEncrypt(String source) {
        return EncryptionUtils.getStringEncryptor().encrypt(source);
    }

    public static String pbkdf2Digest(String source) {
        return EncryptionUtils.pbkdf2Digest(source, false);
    }

    public static String pbkdf2Digest(String source, boolean prefixWithId) {
        PBKDF2Digester digester = PBKDF2Digester.getInstance();
        return prefixWithId ? digester.getId() + ":" + digester.digest(source) : digester.digest(source);
    }

    public static String sha1DigestLegacy(String source) {
        return EncryptionUtils.getSHA1DigesterLegacy().digest(source);
    }

    private EncryptionUtils() {
    }

    private static class StringEncryptorHolder {
        static final StandardPBEStringEncryptor INSTANCE = new StandardPBEStringEncryptor();

        private StringEncryptorHolder() {
        }

        static {
            INSTANCE.setPassword(new String(new byte[]{74, 97, 104, 105, 97, 32, 120, 67, 77, 32, 54, 46, 53}));
        }
    }

    private static class SHA1DigesterHolder {
        static final PooledStringDigester INSTANCE = new PooledStringDigester();

        private SHA1DigesterHolder() {
        }

        static {
            INSTANCE.setAlgorithm("SHA-1");
            INSTANCE.setSaltSizeBytes(0);
            INSTANCE.setIterations(1);
            INSTANCE.setPoolSize(4);
        }
    }
}

