/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.community.modules.channels.filters;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelExclusionFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(ChannelExclusionFilter.class);
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (resource.getNode().isNodeType("jmix:channelSelection")) {
            if (!resource.getNode().hasProperty("j:channelSelection")) {
                logger.warn("Channel selection activated on resource {} but no channels selected, please select channels for this function to be activated properly.", (Object)resource.getPath());
                return null;
            }
            return this.filterChannel(resource, renderContext);
        }
        return null;
    }

    public String getExcludedResult(Resource resource, RenderContext context) {
        if (!context.isEditMode() || context.getChannel() != null && !context.getChannel().getIdentifier().equals("generic")) {
            return "";
        }
        if (!resource.hasWrapper("unselectedChannel")) {
            resource.pushWrapper("unselectedChannel");
        }
        return null;
    }

    private String filterChannel(Resource resource, RenderContext renderContext) throws RepositoryException {
        boolean isExcluding = ChannelExclusionFilter.isExcluding(resource);
        Value[] channelExclusionValues = ChannelExclusionFilter.getChannelExclusionValues(resource);
        Channel currentChannel = renderContext.getChannel();
        for (Value channelExclusionValue : channelExclusionValues) {
            String exclusionValueString = channelExclusionValue.getString();
            if (exclusionValueString == null || !this.channelService.matchChannel(exclusionValueString, currentChannel)) continue;
            return isExcluding ? this.getExcludedResult(resource, renderContext) : null;
        }
        if (!isExcluding) {
            return this.getExcludedResult(resource, renderContext);
        }
        return null;
    }

    private static boolean isExcluding(Resource resource) throws RepositoryException {
        String channelRule = resource.getNode().hasProperty("j:channelIncludeOrExclude") ? resource.getNode().getProperty("j:channelIncludeOrExclude").getString() : "exclude";
        return channelRule.equalsIgnoreCase("exclude");
    }

    private static Value[] getChannelExclusionValues(Resource resource) throws RepositoryException {
        JCRPropertyWrapper channelExclusionProperty = resource.getNode().getProperty("j:channelSelection");
        return channelExclusionProperty.getValues();
    }
}

