/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

final class FrequencySketch<E> {
    static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    static final long RESET_MASK = 0x7777777777777777L;
    static final long ONE_MASK = 0x1111111111111111L;
    int sampleSize;
    int tableMask;
    long[] table;
    int size;

    public void ensureCapacity(@NonNegative long maximumSize) {
        Caffeine.requireArgument(maximumSize >= 0L);
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[maximum == 0 ? 1 : Caffeine.ceilingPowerOfTwo(maximum)];
        this.tableMask = Math.max(0, this.table.length - 1);
        int n2 = this.sampleSize = maximumSize == 0L ? 10 : 10 * maximum;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    public boolean isNotInitialized() {
        return this.table == null;
    }

    public @NonNegative int frequency(@NonNull E e2) {
        if (this.isNotInitialized()) {
            return 0;
        }
        int hash = this.spread(e2.hashCode());
        int start = (hash & 3) << 2;
        int frequency = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < 4; ++i2) {
            int index = this.indexOf(hash, i2);
            int count = (int)(this.table[index] >>> (start + i2 << 2) & 0xFL);
            frequency = Math.min(frequency, count);
        }
        return frequency;
    }

    public void increment(@NonNull E e2) {
        if (this.isNotInitialized()) {
            return;
        }
        int hash = this.spread(e2.hashCode());
        int start = (hash & 3) << 2;
        int index0 = this.indexOf(hash, 0);
        int index1 = this.indexOf(hash, 1);
        int index2 = this.indexOf(hash, 2);
        int index3 = this.indexOf(hash, 3);
        boolean added = this.incrementAt(index0, start);
        added |= this.incrementAt(index1, start + 1);
        added |= this.incrementAt(index2, start + 2);
        if ((added |= this.incrementAt(index3, start + 3)) && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    boolean incrementAt(int i2, int j2) {
        int offset = j2 << 2;
        long mask = 15L << offset;
        if ((this.table[i2] & mask) != mask) {
            int n2 = i2;
            this.table[n2] = this.table[n2] + (1L << offset);
            return true;
        }
        return false;
    }

    void reset() {
        int count = 0;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            count += Long.bitCount(this.table[i2] & 0x1111111111111111L);
            this.table[i2] = this.table[i2] >>> 1 & 0x7777777777777777L;
        }
        this.size = (this.size >>> 1) - (count >>> 2);
    }

    int indexOf(int item, int i2) {
        long hash = ((long)item + SEED[i2]) * SEED[i2];
        hash += hash >>> 32;
        return (int)hash & this.tableMask;
    }

    int spread(int x2) {
        x2 = (x2 >>> 16 ^ x2) * 73244475;
        x2 = (x2 >>> 16 ^ x2) * 73244475;
        return x2 >>> 16 ^ x2;
    }
}

