/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol.a;

import com.mysql.cj.BindValue;
import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.InternalDate;
import com.mysql.cj.protocol.InternalTime;
import com.mysql.cj.protocol.InternalTimestamp;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.ServerSession;
import com.mysql.cj.protocol.a.AbstractValueEncoder;
import com.mysql.cj.protocol.a.NativeConstants;
import com.mysql.cj.protocol.a.NativePacketPayload;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.TimeUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class StringValueEncoder
extends AbstractValueEncoder {
    private CharsetEncoder charsetEncoder;

    @Override
    public void init(PropertySet pset, ServerSession serverSess, ExceptionInterceptor excInterceptor) {
        super.init(pset, serverSess, excInterceptor);
        if (this.serverSession.getCharsetSettings().getRequiresEscapingEncoder()) {
            this.charsetEncoder = Charset.forName((String)this.charEncoding.getValue()).newEncoder();
        }
    }

    @Override
    public byte[] getBytes(BindValue binding) {
        switch (binding.getMysqlType()) {
            case NULL: {
                return StringUtils.getBytes("null");
            }
            case CHAR: 
            case ENUM: 
            case SET: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case BINARY: 
            case GEOMETRY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                String x2 = (String)binding.getValue();
                if (binding.isNational() && !((String)this.charEncoding.getValue()).equalsIgnoreCase("UTF-8") && !((String)this.charEncoding.getValue()).equalsIgnoreCase("utf8")) {
                    StringBuilder buf = new StringBuilder((int)((double)x2.length() * 1.1 + 4.0));
                    buf.append("_utf8");
                    StringUtils.escapeString(buf, x2, this.serverSession.useAnsiQuotedIdentifiers(), null);
                    return StringUtils.getBytes(buf.toString(), "UTF-8");
                }
                int stringLength = x2.length();
                if (this.serverSession.isNoBackslashEscapesSet()) {
                    if (!this.isEscapeNeededForString(x2, stringLength)) {
                        return StringUtils.getBytesWrapped(x2, '\'', '\'', (String)this.charEncoding.getValue());
                    }
                    return this.escapeBytesIfNeeded(StringUtils.getBytes(x2, (String)this.charEncoding.getValue()));
                }
                if (this.isEscapeNeededForString(x2, stringLength)) {
                    String escString = StringUtils.escapeString(new StringBuilder((int)((double)x2.length() * 1.1)), x2, this.serverSession.useAnsiQuotedIdentifiers(), this.charsetEncoder).toString();
                    return StringUtils.getBytes(escString, (String)this.charEncoding.getValue());
                }
                return StringUtils.getBytesWrapped(x2, '\'', '\'', (String)this.charEncoding.getValue());
            }
        }
        return StringUtils.getBytes(this.getString(binding), (String)this.charEncoding.getValue());
    }

    @Override
    public String getString(BindValue binding) {
        String x2 = (String)binding.getValue();
        switch (binding.getMysqlType()) {
            case NULL: {
                return "null";
            }
            case BOOLEAN: 
            case BIT: {
                Boolean b2 = null;
                if ("true".equalsIgnoreCase(x2) || "Y".equalsIgnoreCase(x2)) {
                    b2 = true;
                } else if ("false".equalsIgnoreCase(x2) || "N".equalsIgnoreCase(x2)) {
                    b2 = false;
                } else if (x2.matches("-?\\d+\\.?\\d*")) {
                    b2 = !x2.matches("-?[0]+[.]*[0]*");
                } else {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.66", new Object[]{x2}), this.exceptionInterceptor);
                }
                return String.valueOf(b2 != false ? 1 : 0);
            }
            case TINYINT: 
            case TINYINT_UNSIGNED: 
            case SMALLINT: 
            case SMALLINT_UNSIGNED: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: 
            case INT: {
                return String.valueOf(Integer.parseInt(x2));
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return String.valueOf(Long.parseLong(x2));
            }
            case BIGINT_UNSIGNED: {
                return String.valueOf(new BigInteger(x2).longValue());
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return StringUtils.fixDecimalExponent(Float.toString(Float.parseFloat(x2)));
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return StringUtils.fixDecimalExponent(Double.toString(Double.parseDouble(x2)));
            }
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                return this.getScaled(new BigDecimal(x2), binding.getScaleOrLength()).toPlainString();
            }
            case CHAR: 
            case ENUM: 
            case SET: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case BINARY: 
            case GEOMETRY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                StringBuilder sb = new StringBuilder("'");
                sb.append(x2);
                sb.append("'");
                return sb.toString();
            }
            case DATE: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(((LocalDate)dt).format(TimeUtil.DATE_FORMATTER));
                    sb.append("'");
                    return sb.toString();
                }
                if (dt instanceof LocalDateTime) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(((LocalDateTime)dt).format(TimeUtil.DATE_FORMATTER));
                    sb.append("'");
                    return sb.toString();
                }
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{dt.getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
            }
            case DATETIME: 
            case TIMESTAMP: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(LocalDateTime.of((LocalDate)dt, TimeUtil.DEFAULT_TIME).format(TimeUtil.DATETIME_FORMATTER_WITH_OPTIONAL_MICROS));
                    sb.append("'");
                    return sb.toString();
                }
                if (dt instanceof LocalDateTime) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(this.adjustLocalDateTime((LocalDateTime)dt, binding.getField()).format(TimeUtil.DATETIME_FORMATTER_WITH_OPTIONAL_MICROS));
                    sb.append("'");
                    return sb.toString();
                }
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{dt.getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
            }
            case TIME: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalTime) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(this.adjustLocalTime((LocalTime)dt, binding.getField()).format(TimeUtil.TIME_FORMATTER_WITH_OPTIONAL_MICROS));
                    sb.append("'");
                    return sb.toString();
                }
                if (dt instanceof LocalDateTime) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(this.adjustLocalTime(((LocalDateTime)dt).toLocalTime(), binding.getField()).format(TimeUtil.TIME_FORMATTER_WITH_OPTIONAL_MICROS));
                    sb.append("'");
                    return sb.toString();
                }
                if (dt instanceof Duration) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(TimeUtil.getDurationString(this.adjustDuration((Duration)dt, binding.getField())));
                    sb.append("'");
                    return sb.toString();
                }
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{dt.getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
            }
            case YEAR: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    return String.valueOf(((LocalDate)dt).getYear());
                }
                if (dt instanceof LocalDateTime) {
                    return String.valueOf(((LocalDateTime)dt).getYear());
                }
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{dt.getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    @Override
    public void encodeAsQueryAttribute(Message msg, BindValue binding) {
        NativePacketPayload intoPacket = (NativePacketPayload)msg;
        String x2 = (String)binding.getValue();
        intoPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, StringUtils.getBytes(x2, (String)this.charEncoding.getValue()));
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        NativePacketPayload intoPacket = (NativePacketPayload)msg;
        String x2 = (String)binding.getValue();
        switch (binding.getMysqlType()) {
            case BOOLEAN: 
            case BIT: {
                Boolean b2 = null;
                if ("true".equalsIgnoreCase(x2) || "Y".equalsIgnoreCase(x2)) {
                    b2 = true;
                } else if ("false".equalsIgnoreCase(x2) || "N".equalsIgnoreCase(x2)) {
                    b2 = false;
                } else if (x2.matches("-?\\d+\\.?\\d*")) {
                    b2 = !x2.matches("-?[0]+[.]*[0]*");
                } else {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.66", new Object[]{x2}), this.exceptionInterceptor);
                }
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT1, b2 != false ? 1L : 0L);
                return;
            }
            case TINYINT: 
            case TINYINT_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT1, Long.parseLong(x2));
                return;
            }
            case SMALLINT: 
            case SMALLINT_UNSIGNED: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT2, Long.parseLong(x2));
                return;
            }
            case INT: 
            case INT_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT4, Long.parseLong(x2));
                return;
            }
            case BIGINT: 
            case BIGINT_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT8, Long.parseLong(x2));
                return;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT4, Float.floatToIntBits(Float.parseFloat(x2)));
                return;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT8, Double.doubleToLongBits(Double.parseDouble(x2)));
                return;
            }
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                BigDecimal bd = this.getScaled(new BigDecimal(x2), binding.getScaleOrLength());
                intoPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, StringUtils.getBytes(bd.toPlainString(), (String)this.charEncoding.getValue()));
                return;
            }
            case CHAR: 
            case ENUM: 
            case SET: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case BINARY: 
            case GEOMETRY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (binding.isNational() && !((String)this.charEncoding.getValue()).equalsIgnoreCase("UTF-8") && !((String)this.charEncoding.getValue()).equalsIgnoreCase("utf8")) {
                    throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.31"), this.exceptionInterceptor);
                }
                try {
                    intoPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, StringUtils.getBytes(x2, (String)this.charEncoding.getValue()));
                }
                catch (CJException uEE) {
                    throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.31") + (String)this.charEncoding.getValue() + "'", uEE, this.exceptionInterceptor);
                }
                return;
            }
            case DATE: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    this.writeDate(msg, InternalDate.from((LocalDate)dt));
                    return;
                }
                if (!(dt instanceof LocalDateTime)) break;
                this.writeDateTime(msg, InternalTimestamp.from((LocalDateTime)dt));
                return;
            }
            case DATETIME: 
            case TIMESTAMP: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    this.writeDateTime(msg, InternalTimestamp.from((LocalDate)dt));
                    return;
                }
                if (!(dt instanceof LocalDateTime)) break;
                this.writeDateTime(msg, InternalTimestamp.from((LocalDateTime)dt));
                return;
            }
            case TIME: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalTime) {
                    this.writeTime(msg, InternalTime.from((LocalTime)dt));
                    return;
                }
                if (!(dt instanceof Duration)) break;
                this.writeTime(msg, InternalTime.from(this.adjustDuration(Duration.ofNanos(((Duration)binding.getValue()).toNanos()), binding.getField())));
                return;
            }
            case YEAR: {
                Object dt = TimeUtil.parseToDateTimeObject(x2, binding.getMysqlType());
                if (dt instanceof LocalDate) {
                    intoPacket.writeInteger(NativeConstants.IntegerDataType.INT4, ((LocalDate)dt).getYear());
                    return;
                }
                if (!(dt instanceof LocalDateTime)) break;
                intoPacket.writeInteger(NativeConstants.IntegerDataType.INT4, ((LocalDateTime)dt).getYear());
                return;
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    private boolean isEscapeNeededForString(String x2, int stringLength) {
        for (int i2 = 0; i2 < stringLength; ++i2) {
            char c2 = x2.charAt(i2);
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\"': 
                case '\'': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }
}

