/*
 * Decompiled with CFR 0.152.
 */
package mssql.security.provider;

public class MD4 {
    private final byte[] xBuf = new byte[4];
    private int xBufOff;
    private long byteCount;
    private static final int DIGEST_LENGTH = 16;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X = new int[16];
    private int xOff;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;

    public MD4() {
        this.reset();
    }

    public MD4(MD4 t2) {
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        this.byteCount = t2.byteCount;
        this.copyIn(t2);
    }

    private void copyIn(MD4 t2) {
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        this.byteCount = t2.byteCount;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    public String getAlgorithmName() {
        return "MD4";
    }

    public int getDigestSize() {
        return 16;
    }

    protected void processWord(byte[] in, int inOff) {
        this.X[this.xOff++] = in[inOff] & 0xFF | (in[inOff + 1] & 0xFF) << 8 | (in[inOff + 2] & 0xFF) << 16 | (in[inOff + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength >>> 32);
    }

    private void unpackWord(int word, byte[] out, int outOff) {
        out[outOff] = (byte)word;
        out[outOff + 1] = (byte)(word >>> 8);
        out[outOff + 2] = (byte)(word >>> 16);
        out[outOff + 3] = (byte)(word >>> 24);
    }

    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] in, int inOff, int len) {
        len = Math.max(0, len);
        int i2 = 0;
        if (this.xBufOff != 0) {
            while (i2 < len) {
                this.xBuf[this.xBufOff++] = in[inOff + i2++];
                if (this.xBufOff != 4) continue;
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int limit = (len - i2 & 0xFFFFFFFC) + i2;
        while (i2 < limit) {
            this.processWord(in, inOff + i2);
            i2 += 4;
        }
        while (i2 < len) {
            this.xBuf[this.xBufOff++] = in[inOff + i2++];
        }
        this.byteCount += (long)len;
    }

    public void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        this.unpackWord(this.H1, out, outOff);
        this.unpackWord(this.H2, out, outOff + 4);
        this.unpackWord(this.H3, out, outOff + 8);
        this.unpackWord(this.H4, out, outOff + 12);
        this.reset();
        return 16;
    }

    public void reset() {
        int i2;
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (i2 = 0; i2 < this.xBuf.length; ++i2) {
            this.xBuf[i2] = 0;
        }
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.xOff = 0;
        for (i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int rotateLeft(int x2, int n2) {
        return x2 << n2 | x2 >>> 32 - n2;
    }

    private int F(int u2, int v2, int w2) {
        return u2 & v2 | ~u2 & w2;
    }

    private int G(int u2, int v2, int w2) {
        return u2 & v2 | u2 & w2 | v2 & w2;
    }

    private int H(int u2, int v2, int w2) {
        return u2 ^ v2 ^ w2;
    }

    protected void processBlock() {
        int a2 = this.H1;
        int b2 = this.H2;
        int c2 = this.H3;
        int d2 = this.H4;
        a2 = this.rotateLeft(a2 + this.F(b2, c2, d2) + this.X[0], 3);
        d2 = this.rotateLeft(d2 + this.F(a2, b2, c2) + this.X[1], 7);
        c2 = this.rotateLeft(c2 + this.F(d2, a2, b2) + this.X[2], 11);
        b2 = this.rotateLeft(b2 + this.F(c2, d2, a2) + this.X[3], 19);
        a2 = this.rotateLeft(a2 + this.F(b2, c2, d2) + this.X[4], 3);
        d2 = this.rotateLeft(d2 + this.F(a2, b2, c2) + this.X[5], 7);
        c2 = this.rotateLeft(c2 + this.F(d2, a2, b2) + this.X[6], 11);
        b2 = this.rotateLeft(b2 + this.F(c2, d2, a2) + this.X[7], 19);
        a2 = this.rotateLeft(a2 + this.F(b2, c2, d2) + this.X[8], 3);
        d2 = this.rotateLeft(d2 + this.F(a2, b2, c2) + this.X[9], 7);
        c2 = this.rotateLeft(c2 + this.F(d2, a2, b2) + this.X[10], 11);
        b2 = this.rotateLeft(b2 + this.F(c2, d2, a2) + this.X[11], 19);
        a2 = this.rotateLeft(a2 + this.F(b2, c2, d2) + this.X[12], 3);
        d2 = this.rotateLeft(d2 + this.F(a2, b2, c2) + this.X[13], 7);
        c2 = this.rotateLeft(c2 + this.F(d2, a2, b2) + this.X[14], 11);
        b2 = this.rotateLeft(b2 + this.F(c2, d2, a2) + this.X[15], 19);
        a2 = this.rotateLeft(a2 + this.G(b2, c2, d2) + this.X[0] + 1518500249, 3);
        d2 = this.rotateLeft(d2 + this.G(a2, b2, c2) + this.X[4] + 1518500249, 5);
        c2 = this.rotateLeft(c2 + this.G(d2, a2, b2) + this.X[8] + 1518500249, 9);
        b2 = this.rotateLeft(b2 + this.G(c2, d2, a2) + this.X[12] + 1518500249, 13);
        a2 = this.rotateLeft(a2 + this.G(b2, c2, d2) + this.X[1] + 1518500249, 3);
        d2 = this.rotateLeft(d2 + this.G(a2, b2, c2) + this.X[5] + 1518500249, 5);
        c2 = this.rotateLeft(c2 + this.G(d2, a2, b2) + this.X[9] + 1518500249, 9);
        b2 = this.rotateLeft(b2 + this.G(c2, d2, a2) + this.X[13] + 1518500249, 13);
        a2 = this.rotateLeft(a2 + this.G(b2, c2, d2) + this.X[2] + 1518500249, 3);
        d2 = this.rotateLeft(d2 + this.G(a2, b2, c2) + this.X[6] + 1518500249, 5);
        c2 = this.rotateLeft(c2 + this.G(d2, a2, b2) + this.X[10] + 1518500249, 9);
        b2 = this.rotateLeft(b2 + this.G(c2, d2, a2) + this.X[14] + 1518500249, 13);
        a2 = this.rotateLeft(a2 + this.G(b2, c2, d2) + this.X[3] + 1518500249, 3);
        d2 = this.rotateLeft(d2 + this.G(a2, b2, c2) + this.X[7] + 1518500249, 5);
        c2 = this.rotateLeft(c2 + this.G(d2, a2, b2) + this.X[11] + 1518500249, 9);
        b2 = this.rotateLeft(b2 + this.G(c2, d2, a2) + this.X[15] + 1518500249, 13);
        a2 = this.rotateLeft(a2 + this.H(b2, c2, d2) + this.X[0] + 1859775393, 3);
        d2 = this.rotateLeft(d2 + this.H(a2, b2, c2) + this.X[8] + 1859775393, 9);
        c2 = this.rotateLeft(c2 + this.H(d2, a2, b2) + this.X[4] + 1859775393, 11);
        b2 = this.rotateLeft(b2 + this.H(c2, d2, a2) + this.X[12] + 1859775393, 15);
        a2 = this.rotateLeft(a2 + this.H(b2, c2, d2) + this.X[2] + 1859775393, 3);
        d2 = this.rotateLeft(d2 + this.H(a2, b2, c2) + this.X[10] + 1859775393, 9);
        c2 = this.rotateLeft(c2 + this.H(d2, a2, b2) + this.X[6] + 1859775393, 11);
        b2 = this.rotateLeft(b2 + this.H(c2, d2, a2) + this.X[14] + 1859775393, 15);
        a2 = this.rotateLeft(a2 + this.H(b2, c2, d2) + this.X[1] + 1859775393, 3);
        d2 = this.rotateLeft(d2 + this.H(a2, b2, c2) + this.X[9] + 1859775393, 9);
        c2 = this.rotateLeft(c2 + this.H(d2, a2, b2) + this.X[5] + 1859775393, 11);
        b2 = this.rotateLeft(b2 + this.H(c2, d2, a2) + this.X[13] + 1859775393, 15);
        a2 = this.rotateLeft(a2 + this.H(b2, c2, d2) + this.X[3] + 1859775393, 3);
        d2 = this.rotateLeft(d2 + this.H(a2, b2, c2) + this.X[11] + 1859775393, 9);
        c2 = this.rotateLeft(c2 + this.H(d2, a2, b2) + this.X[7] + 1859775393, 11);
        b2 = this.rotateLeft(b2 + this.H(c2, d2, a2) + this.X[15] + 1859775393, 15);
        this.H1 += a2;
        this.H2 += b2;
        this.H3 += c2;
        this.H4 += d2;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }
}

