/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.GDKMessage;

class OraCharsetAL16UTF16LE
extends OraCharset {
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{-3, -1};

    OraCharsetAL16UTF16LE(String string, int n2) {
        super(string, n2);
    }

    @Override
    public boolean contains(Charset charset) {
        return true;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 0.5f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 2.0f, 2.0f, REPLACEMENT_CHAR_IN_BYTES);
    }

    @Override
    String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = OraCharsetAL16UTF16LE.AL16UTF16LEBytesToJavaChars(byArray, n2, n3, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }

    @Override
    String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = OraCharsetAL16UTF16LE.AL16UTF16LEBytesToJavaChars(byArray, n2, n3, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new SQLException(GDKMessage.getORAMessage(17037));
        }
    }

    @Override
    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        OraCharsetAL16UTF16LE.javaCharsToAL16UTF16LEBytes(cArray, cArray.length, byArray);
        return byArray;
    }

    @Override
    byte[] convert(String string) {
        return this.convertWithReplacement(string);
    }
}

