/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.GDKMessage;

class OraCharsetUTF
extends OraCharset {
    OraCharsetUTF(String string, int n2) {
        super(string, n2);
    }

    @Override
    public boolean contains(Charset charset) {
        return true;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 1.0f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 1.0f, 3.0f);
    }

    @Override
    String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int n4 = OraCharsetUTF.UTFToJavaChar(byArray, n2, n3, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }

    @Override
    String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n4 = OraCharsetUTF.UTFToJavaChar(byArray, n2, n3, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new SQLException(GDKMessage.getORAMessage(17037));
        }
    }

    @Override
    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 3];
        int n2 = OraCharsetUTF.javaCharsToUTF(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }
}

