/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.text.converter.GDKMessage;

public abstract class CharacterConverterMSOLISO2022JPBase
extends CharacterConverter12Byte {
    protected static int MAXLIMIT = 65536;
    static final int BUCKETSIZE = 200;
    static final byte REPLACEMENT_CHAR_IN_BYTE = 63;
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{63};
    static final int ASCII_JISROMAN = 0;
    static final int JISX0208 = 1;
    static final int JISX0212 = 2;
    static final int HALF_WIDTH_KATAKANA = 3;
    static final byte[] JISROMAN_ESCSEQ = new byte[]{27, 40, 66};
    static final byte[] JISX0208_ESCSEQ = new byte[]{27, 36, 66};
    static final byte[] JISX0212_ESCSEQ = new byte[]{27, 36, 40, 68};
    static final byte[] HALF_WIDTH_KATAKANA_ESCSEQ = new byte[]{27, 40, 73};
    static final int FULLWIDTH_MODE = 1;
    static final int HALFWIDTH_MODE = 2;
    public int[] m_oraCharExtraLevel1 = null;
    public char[] m_oraCharExtraLevel2 = null;

    public CharacterConverterMSOLISO2022JPBase() {
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 10.0f;
    }

    @Override
    int toUnicode(int n2) throws SQLException {
        return n2;
    }

    @Override
    int toUnicodeWithReplacement(int n2) {
        if (n2 >= 0 && n2 <= 127) {
            return n2;
        }
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] : this.m_ucsCharReplacement;
        return n5;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            return this.toUnicodeStringMain(byArray, n2, n3, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            return this.toUnicodeStringMain(byArray, n2, n3, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            char[] cArray = new char[]{(char)this.m_ucsCharReplacement};
            return new String(cArray);
        }
    }

    private String toUnicodeStringMain(byte[] byArray, int n2, int n3, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        int n4 = n2;
        int n5 = n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = new String("");
        n5 = this.getNextEscpSeq(byArray, n4);
        if (n5 == -1) {
            string = string + this.toUnicodeChars(byArray, 0, byArray.length - 1, 0, characterConverterBehavior);
            bl5 = true;
        } else if (n5 != 0) {
            string = string + this.toUnicodeChars(byArray, 0, n5 - 1, 0, characterConverterBehavior);
        }
        while (!bl5) {
            int n6;
            n4 = n5;
            if ((n5 = this.getNextEscpSeq(byArray, n5 + 1)) == -1) {
                n5 = byArray.length;
                bl5 = true;
            }
            if ((n6 = this.checkEscpSeq(byArray, n4)) == 0 || n6 == 1 || n6 == 3) {
                if (n4 + 3 == n5) continue;
                string = string + this.toUnicodeChars(byArray, n4 + 3, n5 - 1, n6, characterConverterBehavior);
                continue;
            }
            if (n6 == 2) {
                if (n4 + 4 == n5) continue;
                string = string + this.toUnicodeChars(byArray, n4 + 4, n5 - 1, n6, characterConverterBehavior);
                continue;
            }
            characterConverterBehavior.onFailConversion(n4);
        }
        return string;
    }

    private String toUnicodeChars(byte[] byArray, int n2, int n3, int n4, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        String string;
        block5: {
            block4: {
                string = new String("");
                if (n3 < n2) {
                    throw new SQLException();
                }
                if (n4 == 0) {
                    return new String(byArray, n2, n3 - n2 + 1);
                }
                if (n4 != 1 && n4 != 2) break block4;
                for (int i2 = n2; i2 < n3; i2 += 2) {
                    int n5 = byArray[i2] & 0xFF;
                    int n6 = byArray[i2 + 1] & 0xFF;
                    int n7 = this.m_ucsCharLevel1[n5] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] : this.m_ucsCharReplacement;
                    string = string + new String(new char[]{(char)n7});
                }
                break block5;
            }
            if (n4 != 3) break block5;
            for (int i3 = n2; i3 <= n3; ++i3) {
                int n8 = 0;
                int n9 = byArray[i3] & 0xFF;
                int n10 = this.m_ucsCharLevel1[n8] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] : this.m_ucsCharReplacement;
                string = string + new String(new char[]{(char)n10});
            }
        }
        return string;
    }

    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int[] nArray = new int[]{string.length()};
        if (nArray[0] == 0) {
            return new byte[0];
        }
        char[] cArray = new char[nArray[0]];
        string.getChars(0, nArray[0], cArray, 0);
        return this.toISO2022JPStringMain(cArray, 0, null, 0, nArray, CharacterConverterBehavior.REPORT_ERROR);
    }

    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        try {
            return this.toISO2022JPStringMain(cArray, n2, byArray, n3, nArray, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public abstract byte[] toISO2022JPStringMain(char[] var1, int var2, byte[] var3, int var4, int[] var5, CharacterConverterBehavior var6) throws SQLException;

    public byte[] toISO2022JPStringFWHW(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray, CharacterConverterBehavior characterConverterBehavior, int n4) throws SQLException {
        byte[] byArray2;
        int n5;
        int n6;
        int n7;
        int n8 = nArray[0];
        int n9 = n2 + n8;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(0);
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray3 = new byte[200];
        arrayList.add(byArray3);
        for (int i2 = n2; i2 < n9; ++i2) {
            if (cArray[i2] >= '\u0000' && cArray[i2] <= '\u007f') {
                if (n10 != 0) {
                    n10 = 0;
                    n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                    n11 += 3;
                }
                n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)cArray[i2]});
                ++n11;
                continue;
            }
            if (cArray[i2] >= '\u00a1' && cArray[i2] <= '\u00ff') {
                n7 = cArray[i2] >> 8 & 0xFF;
                n6 = cArray[i2] & 0xFF;
                if (this.m_oraCharExtraLevel1[n7] == -1 || this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n7] + n6] == '\uffff') continue;
                n5 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n7] + n6];
                if ((char)(n5 & 0xFF) == n5) {
                    if (n10 != 0) {
                        n10 = 0;
                        n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                        n11 += 3;
                    }
                    n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)(n5 & 0xFF)});
                    ++n11;
                    continue;
                }
                if (n10 != 1) {
                    n10 = 1;
                    n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                    n11 += 3;
                }
                n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)(n5 >> 8 & 0xFF), (byte)(n5 & 0xFF)});
                n11 += 2;
                continue;
            }
            n7 = cArray[i2] >> 8 & 0xFF;
            n6 = cArray[i2] & 0xFF;
            if (this.m_oraCharExtraLevel1[n7] != -1 && this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n7] + n6] != '\uffff') {
                if (n4 == 1) {
                    if (n10 != 1) {
                        n10 = 1;
                        n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                        n11 += 3;
                    }
                    n5 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n7] + n6];
                    n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)(n5 >> 8 & 0xFF), (byte)(n5 & 0xFF)});
                    n11 += 2;
                    continue;
                }
                if (n10 != 3) {
                    n10 = 3;
                    n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                    n11 += 3;
                }
                n5 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n7] + n6];
                n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)(n5 & 0xFF)});
                ++n11;
                continue;
            }
            if (this.m_oraCharLevel1[n7] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n6] != '\uffff') {
                if (n10 != 1) {
                    n10 = 1;
                    n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                    n11 += 3;
                }
                n5 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n6];
                n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{(byte)(n5 >> 8 & 0xFF), (byte)(n5 & 0xFF)});
                n11 += 2;
                continue;
            }
            if (characterConverterBehavior == CharacterConverterBehavior.REPLACEMENT) {
                if (n10 != 0) {
                    n10 = 0;
                    n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, n10);
                    n11 += 3;
                }
                n5 = this.m_1ByteOraCharReplacement;
                n12 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n12, arrayList, new byte[]{63});
                ++n11;
                continue;
            }
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        if (n10 != 0) {
            n12 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n12, arrayList, 0);
            n11 += 3;
        }
        if (byArray != null) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n11];
            n3 = 0;
        }
        n7 = 0;
        n6 = n3;
        for (n5 = 0; n5 < arrayList.size(); ++n5) {
            int n13 = (n11 - n6) / 200 > 0 ? 200 : n11 % 200;
            n7 = 0;
            while (n7 < n13) {
                byArray2[n6] = ((byte[])arrayList.get(n5))[n7];
                ++n7;
                ++n6;
            }
        }
        nArray[0] = n11;
        return byArray2;
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharExtraLevel1 = new int[256];
        char[] cArray = new char[MAXLIMIT];
        int n5 = 0;
        int[][] nArray = new int[MAXLIMIT][2];
        int n6 = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            this.m_oraCharLevel1[n4] = -1;
        }
        for (n4 = 0; n4 < MAXLIMIT; ++n4) {
            cArray[n4] = 65535;
        }
        for (n4 = 0; n4 < 65535; ++n4) {
            int n7 = this.toUnicodeWithReplacement(n4);
            if (n7 == this.m_ucsCharReplacement) continue;
            nArray[n6][0] = n7;
            nArray[n6][1] = n4;
            ++n6;
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            n3 = nArray[n4][0] >>> 8 & 0xFF;
            n2 = nArray[n4][0] & 0xFF;
            if (this.m_oraCharLevel1[n3] == -1) {
                this.m_oraCharLevel1[n3] = n5;
                n5 += 256;
            }
            if (cArray[this.m_oraCharLevel1[n3] + n2] != '\uffff') continue;
            cArray[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[n4][1] & 0xFFFF);
        }
        this.m_oraCharLevel2 = new char[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_oraCharLevel2[n4] = cArray[n4];
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n5 = 0;
            for (n4 = 0; n4 < 256; ++n4) {
                this.m_oraCharExtraLevel1[n4] = -1;
            }
            for (n4 = 0; n4 < MAXLIMIT; ++n4) {
                cArray[n4] = 65535;
            }
            int n8 = this.extraUnicodeToOracleMapping.length;
            for (n4 = 0; n4 < n8; ++n4) {
                int n9 = this.extraUnicodeToOracleMapping[n4][0];
                int n10 = this.extraUnicodeToOracleMapping[n4][1];
                n3 = n9 >>> 8 & 0xFF;
                n2 = n9 & 0xFF;
                if (this.m_oraCharExtraLevel1[n3] == -1) {
                    this.m_oraCharExtraLevel1[n3] = n5;
                    n5 += 256;
                }
                if (cArray[this.m_oraCharExtraLevel1[n3] + n2] != '\uffff') continue;
                cArray[this.m_oraCharExtraLevel1[n3] + n2] = (char)n10;
            }
            this.m_oraCharExtraLevel2 = new char[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                this.m_oraCharExtraLevel2[n4] = cArray[n4];
            }
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    private static int insertToBucket(int n2, ArrayList arrayList, byte[] byArray) {
        if (n2 + byArray.length - 1 >= 200) {
            int n3 = 0;
            while (n3 < byArray.length) {
                if (n2 >= 200) {
                    byte[] byArray2 = new byte[200];
                    arrayList.add(byArray2);
                    n2 = 0;
                }
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n2] = byArray[n3];
                ++n3;
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < byArray.length) {
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n2] = byArray[n4];
                ++n4;
                ++n2;
            }
        }
        return n2;
    }

    private int checkEscpSeq(byte[] byArray, int n2) throws SQLException {
        if (n2 + 2 >= byArray.length) {
            return -1;
        }
        if (byArray[n2 + 1] == 40) {
            if (byArray[n2 + 2] == 66 || byArray[n2 + 2] == 74) {
                return 0;
            }
            if (byArray[n2 + 2] == 73) {
                return 3;
            }
        } else if (byArray[n2 + 1] == 36) {
            if (byArray[n2 + 2] == 64 || byArray[n2 + 2] == 66) {
                return 1;
            }
            if (byArray[n2 + 2] == 40 && byArray[n2 + 3] == 68) {
                return 2;
            }
        }
        return -1;
    }

    private static int insertEscSeq(int n2, ArrayList arrayList, int n3) {
        byte[] byArray = null;
        if (n3 == 0) {
            byArray = JISROMAN_ESCSEQ;
        } else if (n3 == 1) {
            byArray = JISX0208_ESCSEQ;
        } else if (n3 == 2) {
            byArray = JISX0212_ESCSEQ;
        } else if (n3 == 3) {
            byArray = HALF_WIDTH_KATAKANA_ESCSEQ;
        }
        return CharacterConverterMSOLISO2022JPBase.insertToBucket(n2, arrayList, byArray);
    }

    private int getNextEscpSeq(byte[] byArray, int n2) {
        while (n2 < byArray.length) {
            if (byArray[n2] == 27) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static abstract class CharacterConverterBehavior {
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n2) throws SQLException {
                throw new SQLException();
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n2) throws SQLException {
            }
        };

        public abstract void onFailConversion(int var1) throws SQLException;
    }
}

