/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.IOException;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.http5.Http5FileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;

public class Http5FileContentInfoFactory
implements FileContentInfoFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        String contentMimeType = null;
        String contentCharset = null;
        try (Http5FileObject http4File = (Http5FileObject)FileObjectUtils.getAbstractFileObject(fileContent.getFile());){
            HttpResponse lastHeadResponse = http4File.getLastHeadResponse();
            Header header = lastHeadResponse.getFirstHeader("Content-Type");
            if (header != null) {
                ContentType contentType = ContentType.parse((CharSequence)header.getValue());
                contentMimeType = contentType.getMimeType();
                if (contentType.getCharset() != null) {
                    contentCharset = contentType.getCharset().name();
                }
            }
            DefaultFileContentInfo defaultFileContentInfo = new DefaultFileContentInfo(contentMimeType, contentCharset);
            return defaultFileContentInfo;
        }
        catch (IOException e2) {
            throw new FileSystemException(e2);
        }
    }
}

