/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.ram.RamFileData;
import org.apache.commons.vfs2.provider.ram.RamFileObject;

public class RamFileOutputStream
extends OutputStream {
    protected RamFileObject file;
    protected byte[] buffer1 = new byte[1];
    protected boolean closed;
    private IOException exception;

    public RamFileOutputStream(RamFileObject file) {
        this.file = file;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        RamFileData data = this.file.getData();
        int size = data.size();
        int newSize = size + len;
        try {
            this.file.resize(newSize);
        }
        catch (IOException e2) {
            this.exception = e2;
            throw e2;
        }
        System.arraycopy(b2, off, data.getContent(), size, len);
    }

    @Override
    public void write(int b2) throws IOException {
        this.buffer1[0] = (byte)b2;
        this.write(this.buffer1);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            this.closed = true;
            this.file.endOutput();
        }
        catch (Exception e2) {
            throw new FileSystemException(e2);
        }
    }
}

