/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.util.URIBitSets;

public class URIUtils {
    private static final Log LOG = LogFactory.getLog(URIUtils.class);
    private static final String DEFAULT_PROTOCOL_CHARSET = "UTF-8";

    private static String encode(String unescaped, BitSet allowed, String charset) {
        byte[] rawdata = URLCodecUtils.encodeUrl(allowed, EncodingUtils.getBytes(unescaped, charset));
        return EncodingUtils.getAsciiString(rawdata, 0, rawdata.length);
    }

    public static String encodePath(String unescaped) {
        return URIUtils.encodePath(unescaped, DEFAULT_PROTOCOL_CHARSET);
    }

    public static String encodePath(String unescaped, String charset) {
        if (unescaped == null) {
            throw new IllegalArgumentException("The string to encode may not be null.");
        }
        return URIUtils.encode(unescaped, URIBitSets.allowed_abs_path, charset);
    }

    private URIUtils() {
    }

    private static class URLCodecUtils {
        private static final byte ESCAPE_CHAR = 37;
        private static final BitSet WWW_FORM_URL_SAFE;
        private static final int RADIX = 16;

        static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            if (urlsafe == null) {
                urlsafe = WWW_FORM_URL_SAFE;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int n2 : bytes) {
                int b2 = n2;
                if (b2 < 0) {
                    b2 = 256 + b2;
                }
                if (urlsafe.get(b2)) {
                    if (b2 == 32) {
                        b2 = 43;
                    }
                    buffer.write(b2);
                    continue;
                }
                buffer.write(37);
                char hex1 = URLCodecUtils.hexDigit(b2 >> 4);
                char hex2 = URLCodecUtils.hexDigit(b2);
                buffer.write(hex1);
                buffer.write(hex2);
            }
            return buffer.toByteArray();
        }

        private static char hexDigit(int b2) {
            return Character.toUpperCase(Character.forDigit(b2 & 0xF, 16));
        }

        private URLCodecUtils() {
        }

        static {
            int i2;
            WWW_FORM_URL_SAFE = new BitSet(256);
            for (i2 = 97; i2 <= 122; ++i2) {
                WWW_FORM_URL_SAFE.set(i2);
            }
            for (i2 = 65; i2 <= 90; ++i2) {
                WWW_FORM_URL_SAFE.set(i2);
            }
            for (i2 = 48; i2 <= 57; ++i2) {
                WWW_FORM_URL_SAFE.set(i2);
            }
            WWW_FORM_URL_SAFE.set(45);
            WWW_FORM_URL_SAFE.set(95);
            WWW_FORM_URL_SAFE.set(46);
            WWW_FORM_URL_SAFE.set(42);
            WWW_FORM_URL_SAFE.set(32);
        }
    }

    private static class EncodingUtils {
        static String getAsciiString(byte[] data, int offset, int length) {
            return new String(data, offset, length, StandardCharsets.US_ASCII);
        }

        static byte[] getBytes(String data, String charsetName) {
            if (data == null) {
                throw new IllegalArgumentException("data may not be null");
            }
            if (StringUtils.isEmpty(charsetName)) {
                throw new IllegalArgumentException("charset may not be null or empty");
            }
            try {
                return data.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e2) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: " + charsetName + ". System encoding used.");
                }
                return data.getBytes(Charset.defaultCharset());
            }
        }

        private EncodingUtils() {
        }
    }
}

