/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorOutputStream;
import org.apache.derby.client.am.BlobOutputStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveBlobLocatorInputStream;

public class ClientBlob
extends Lob
implements Blob {
    byte[] binaryString_ = null;
    InputStream binaryStream_ = null;
    int dataOffset_;

    public ClientBlob(byte[] byArray, Agent agent, int n2) {
        super(agent, false);
        this.binaryString_ = byArray;
        this.dataType_ |= 0x40;
        this.setSqlLength(byArray.length - n2);
        this.dataOffset_ = n2;
    }

    ClientBlob(Agent agent, InputStream inputStream, int n2) {
        super(agent, false);
        this.binaryStream_ = inputStream;
        this.dataType_ |= 0x20;
        this.setSqlLength(n2);
    }

    ClientBlob(Agent agent, InputStream inputStream) {
        super(agent, ClientBlob.isLayerBStreamingPossible(agent));
        this.binaryStream_ = inputStream;
        this.dataType_ |= 0x20;
    }

    public ClientBlob(Agent agent, int n2) {
        super(agent, false);
        this.locator_ = n2;
        this.dataType_ |= 0x80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length", new Object[0]);
                }
                this.checkForClosedConnection();
                long l2 = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().blobGetLength(this.locator_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBytes", (int)l2, n2);
                }
                if (l2 <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2);
                }
                if (l2 > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), l2);
                }
                if (n2 < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), n2);
                }
                byte[] byArray = this.getBytesX(l2, n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
                }
                return byArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private byte[] getBytesX(long l2, int n2) throws SqlException {
        byte[] byArray;
        this.checkForClosedConnection();
        long l3 = Math.min(this.sqlLength() - l2 + 1L, (long)n2);
        if (this.isLocator()) {
            byArray = this.agent_.connection_.locatorProcedureCall().blobGetBytes(this.locator_, l2, (int)l3);
        } else {
            byArray = new byte[(int)l3];
            System.arraycopy(this.binaryString_, (int)l2 + this.dataOffset_ - 1, byArray, 0, (int)l3);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBinaryStream", new Object[0]);
                }
                InputStream inputStream = this.getBinaryStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    InputStream getBinaryStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isBinaryStream()) {
            return this.binaryStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this);
        }
        return new ByteArrayInputStream(this.binaryString_, this.dataOffset_, this.binaryString_.length - this.dataOffset_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(byte[], long)", byArray, l2);
                }
                if (byArray == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (l2 < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2);
                }
                long l3 = this.positionX(byArray, l2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(byte[], long)", l3);
                }
                return l3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(byte[] byArray, long l2) throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, byArray, l2);
        }
        return this.binaryStringPosition(byArray, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Blob blob, long l2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(Blob, long)", blob, l2);
                }
                if (blob == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (l2 < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2);
                }
                long l3 = this.positionX(blob, l2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Blob, long)", l3);
                }
                return l3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(Blob blob, long l2) throws SqlException {
        this.checkForClosedConnection();
        try {
            if (this.isLocator()) {
                if (blob instanceof ClientBlob && ((ClientBlob)blob).isLocator()) {
                    return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromLocator(this.locator_, ((ClientBlob)blob).getLocator(), l2);
                }
                return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, blob.getBytes(1L, (int)blob.length()), l2);
            }
            return this.binaryStringPosition(blob.getBytes(1L, (int)blob.length()), l2);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBytes", (int)l2, byArray);
                }
                int n2 = this.setBytesX(l2, byArray, 0, byArray.length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBytes", (int)l2, byArray, n2, n3);
                }
                int n4 = this.setBytesX(l2, byArray, n2, n3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", n4);
                }
                return n4;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    int setBytesX(long l2, byte[] byArray, int n2, int n3) throws SqlException {
        if (l2 <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2);
        }
        if (l2 >= Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), l2);
        }
        if (l2 - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), l2);
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), n2);
        }
        if (n3 < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (n3 > byArray.length - n2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), n3);
        }
        int n4 = Math.min(byArray.length - n2, n3);
        if (this.isLocator()) {
            byte[] byArray2 = byArray;
            if (n2 > 0 || n4 < byArray.length) {
                byArray2 = new byte[n4];
                System.arraycopy(byArray, n2, byArray2, 0, n4);
            }
            this.agent_.connection_.locatorProcedureCall().blobSetBytes(this.locator_, l2, n4, byArray2);
            if (l2 + (long)n4 - 1L > this.sqlLength()) {
                this.setSqlLength(l2 + (long)n4 - 1L);
            }
            this.incrementUpdateCount();
        } else {
            if (this.binaryString_.length - this.dataOffset_ - (int)l2 + 1 < n4) {
                byte[] byArray3 = new byte[(int)l2 + n4 + this.dataOffset_ - 1];
                System.arraycopy(this.binaryString_, 0, byArray3, 0, this.binaryString_.length);
                this.binaryString_ = byArray3;
            }
            System.arraycopy(byArray, n2, this.binaryString_, (int)l2 + this.dataOffset_ - 1, n4);
            this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
            this.setSqlLength(this.binaryString_.length - this.dataOffset_);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBinaryStream", (int)l2);
                }
                if (l2 < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2);
                }
                OutputStream outputStream = this.isLocator() ? new BlobLocatorOutputStream(this.agent_.connection_, this, l2) : new BlobOutputStream(this, l2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBinaryStream", outputStream);
                }
                return outputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, " truncate", (int)l2);
                }
                if (l2 < 0L || l2 > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), l2, "len", "Blob.truncate()");
                }
                if (l2 == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobTruncate(this.locator_, l2);
                    this.setSqlLength(l2);
                    this.incrementUpdateCount();
                } else {
                    long l3 = (int)l2 + this.dataOffset_;
                    byte[] byArray = new byte[(int)l2 + this.dataOffset_];
                    System.arraycopy(this.binaryString_, 0, byArray, 0, (int)l3);
                    this.binaryString_ = byArray;
                    this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
                    this.setSqlLength(this.binaryString_.length - this.dataOffset_);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free", new Object[0]);
                }
                if (this.isBinaryStream()) {
                    try {
                        this.binaryStream_.close();
                    }
                    catch (IOException iOException) {
                        throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]);
                    }
                } else if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobReleaseLocator(this.locator_);
                } else {
                    this.binaryString_ = null;
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBinaryStream", (int)l2, l3);
                }
                this.checkPosAndLength(l2, l3);
                InputStream inputStream = this.isLocator() ? new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this, l2, l3) : new ByteArrayInputStream(this.binaryString_, (int)((long)this.dataOffset_ + l2 - 1L), (int)l3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isBinaryString() {
        return (this.dataType_ & 0x40) == 64;
    }

    public boolean isBinaryStream() {
        return (this.dataType_ & 0x20) == 32;
    }

    private long binaryStringPosition(byte[] byArray, long l2) {
        int n2 = (int)l2 + this.dataOffset_ - 1;
        while (n2 + byArray.length <= this.binaryString_.length) {
            if (this.isSubString(byArray, n2)) {
                return n2 - this.dataOffset_ + 1;
            }
            ++n2;
        }
        return -1L;
    }

    private boolean isSubString(byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] != this.binaryString_[n2]) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    @Override
    protected void materializeStream() throws SqlException {
        this.binaryStream_ = super.materializeStream(this.binaryStream_, "java.sql.Blob");
    }
}

